/*
*  Module:  redraw surface
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: RedrawSurface
*
*  Purpose: This function draws surface psr on pxSurface and grays the redraw
*           button.  If bExpose is TRUE this function forces an expose event
*	    for the picture window.
*
*  Author:  Bret Johnson
*/

void RedrawSurface(psr, bExpose)
PSURFACE    psr;
BOOL	    bExpose;
{
    DrawSurface(pxSurface, psr); 	/* Redraw the surface on the pixmap */

    /* If requested, force an expose event for the entire picture window */
    if (bExpose)
        XClearArea(pds, wnPicture, 0, 0, 0, 0, True);

    bRedrawValid = FALSE;

    /* Gray the redraw button */
    DrawRedrawButton();
}

