/*
*  Module:  slider bar input
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: SliderBarInput
*
*  Purpose: This function returns the scalar equivalent of a bar position in
*           a slider bar.  x is the x-coordinate of the bar in the silder bar
*	    window.  scMin and scMax are the scalar equivalents of the slider
*	    bar's extreme values.  
*
*  Author:  Bret Johnson
*/

SCALAR SliderBarInput(x, scMin, scMax)
unsigned int	x;
SCALAR		scMin, scMax;
{
    SCALAR	scProportion;


    /* Move input from left or right border of slider bar in one pixel */
    if (x == 0)
	x = 1;
    else if (x == SliderBarWidth - 1)
	x = SliderBarWidth - 2;

    scProportion = (SCALAR) (x - 1) / (SCALAR) (SliderBarWidth - 3);
    return (scMax - scMin) * scProportion + scMin;
}

