/*
*  Module:  draw controls
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Functions: DrawThetaSliderBar, DrawEtaSliderBar, DrawDistanceSliderBar,
*	      DrawParallelCheckBox, DrawConnect1CheckBox, DrawConnect2CheckBox,
*	      DrawPARCheckBox, DrawAutoRedrawCheckBox, DrawEqnTitleCheckBox,
*	      DrawRedrawButton
*
*  Purpose: These functions draw their associted controls in the control
*	    window.  The controls are grayed and checked as appropriate.  The
*	    slider bar's bars are positioned correctly.
*
*  Author:  Bret Johnson
*/

void DrawThetaSliderBar(psr)
PSURFACE   psr;
{
    DrawSliderBar( (int) xptTheta.x, (int) xptTheta.y, wnControl, wnTheta, 
      sThetaLabel, sThetaMinLabel, sThetaMaxLabel, scTheta, THETA_MIN,
      THETA_MAX, psr->bParSpace, 1.0 / 4.0 );
}


void DrawEtaSliderBar(psr)
PSURFACE   psr;
{
    DrawSliderBar( (int) xptEta.x,  (int) xptEta.y, wnControl, wnEta, sEtaLabel,
       sEtaMinLabel, sEtaMaxLabel, scEta, ETA_MIN, ETA_MAX, psr->bParSpace, 
       1.0 / 8.0 );
}


void DrawDistanceSliderBar()
{
    DrawSliderBar( (int) xptDistance.x, (int) xptDistance.y, wnControl, 
      wnDistance, sDistanceLabel, sDistanceMinLabel, sDistanceMaxLabel, scD, 
      scDistanceMin, scDistanceMax, bParallel, 1.0 / 9.0 );
}


void DrawParallelCheckBox(psr)
PSURFACE   psr;
{
    DrawCheckBox( (int) xptParallel.x,  (int) xptParallel.y, wnControl, 
      wnParallel, sParallelLabel, bParallel, psr->bParSpace );
}


void DrawConnect1CheckBox(psr)
PSURFACE   psr;
{
    DrawCheckBox( (int) xptConnect1.x, (int) xptConnect1.y, wnControl, 
      wnConnect1, sConnect1Label, bConnect1, IS_GEODESICS(psr->type) );
}


void DrawConnect2CheckBox(psr)
PSURFACE   psr;
{
    DrawCheckBox( (int) xptConnect2.x, (int) xptConnect2.y, wnControl, 
      wnConnect2, sConnect2Label, bConnect2, IS_GEODESICS(psr->type) );
}


void DrawPARCheckBox()
{
    DrawCheckBox( (int) xptPAR.x,  (int) xptPAR.y, wnControl, wnPAR, sPARLabel,
      bPAR, FALSE );
}


void DrawAutoRedrawCheckBox()
{
    DrawCheckBox( (int) xptAutoRedraw.x,  (int) xptAutoRedraw.y, wnControl, 
      wnAutoRedraw, sAutoRedrawLabel, bAutoRedraw, FALSE );
}


void DrawEqnTitleCheckBox()
{
    DrawCheckBox( (int) xptEqnTitle.x,  (int) xptEqnTitle.y, wnControl, 
      wnEqnTitle, sEqnTitleLabel, bEqnTitle, FALSE );
}


void DrawRedrawButton()
{
    DrawButton(wnRedraw, sRedrawLabel, !bRedrawValid);
}

