/*
*  Module:  main
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*
*  Author:  Bret Johnson
*
*  Purpose: This X11 program reads a data file produced by one of the project
*           Riemann math programs and displays this data in a window (called the
*	    picture window).  Another top-level window, the control window, 
*	    is placed on the screen to allow the user interactive control over
*	    the viewer's location in three space and other parameters.  Complete
*	    documentation for xdisp can be found in another file.
*/

#define MAIN
#include "control.h"
#include "events.h"
#include <X11/keysym.h>

main(argc, argv)
int	argc;
char	*argv[];
{
    SURFACE      sr; 
    FILE        *pfData;
    XEvent       xev;
    KeySym       ks;
    BOOL	 bFirstExpose = TRUE;	/* TRUE if expose event is the first */
    char	*sGeometry,
		*sControlGeometry;


    /* Set global variables to their defaults */
    GlobalArgv		= argv;
    bRedrawValid        = FALSE;    
    sThetaLabel         = "Theta:  ";
    sEtaLabel           = "Eta:  ";
    sDistanceLabel      = "Distance:  ";
    sParallelLabel      = "  Parallel Projection";
    sConnect1Label      = "  Connect Direction One";
    sConnect2Label      = "  Connect Direction Two";
    sPARLabel           = "  Preserve Aspect Ratio";
    sAutoRedrawLabel    = "  Auto Redraw";
    sEqnTitleLabel      = "  Use Equation as Title";
    sRedrawLabel        = "Redraw";
    sThetaMinLabel      = "-180 ";
    sThetaMaxLabel      = " 180";
    sEtaMinLabel        = "-180 ";
    sEtaMaxLabel        = " 180";
    sDistanceMinLabel   = "object size ";
    sDistanceMaxLabel   = " object size X10";
    sProgramName	= "xdisp";
    InterlineSpacing    = 3;
    PictureBorderWidth  = 5;

    /* Parse the command line, read the resource database, and set the */
    /*   parameters accordingly */
    ProcessOptions(argc, argv, &pfData, &sGeometry, &sControlGeometry);

    if (bDebug)
	XSynchronize(pds, 1);

    pxlBlack = BlackPixel(pds, screen);
    pxlWhite = WhitePixel(pds, screen);

    ReadSurface(pfData, &sr);

    /* If viewing the parameter space, always have the viewer look straight */
    /*   down onto the surface */
    if (sr.bParSpace) {
        bParallel = TRUE;
        scTheta = -90;
        scEta = 90;
    }
    
    /* Set sEqnTitle to the equation defining the surface */
    if (IS_IMPLICIT(sr.type))
	sEqnTitle = sr.sEquation1;
    else {
	sEqnTitle = malloc( strlen(sr.sEquation1) + strlen(sr.sEquation2) +
	  strlen(sr.sEquation3) + 20 );

	sprintf(sEqnTitle, "%s; %s; %s", sr.sEquation1, sr.sEquation2, 
	  sr.sEquation3);
    }

    /* Initalize the closest and furthest distance that can be input on the */
    /*   distance slider bar */
    scDistanceMin = sr.scSurfaceSize;
    scDistanceMax = sr.scSurfaceSize * 10.0;

    /* If the user didn't specify a distance, set the distance to its */
    /*   default; otherwise, ensure that the distance is at least the object */
    /*   size */
    if (!bUSDistance)
        scD = sr.scSurfaceSize * 5.0;
    else if (scD < sr.scSurfaceSize)
	scD = sr.scSurfaceSize;

    if (bVerbose)
	DumpSurface(&sr);

    if (bNoDraw)
	exit(0);

    /* Create and map the picture window */
    InitializePictureWindow(sGeometry, &sr);

    gcPicture = XCreateGC(pds, wnPicture, 0, 0);
    gcGray    = XCreateGC(pds, wnPicture, 0, 0);
    gcControl = XCreateGC(pds, wnPicture, 0, 0);

    MakeSurfacePixmap();
    DrawSurface(pxSurface, &sr);

    /* Handle events as they occur */
    while (TRUE) {

        XNextEvent(pds, &xev);

        if (bDebug)
	    printf("Event %s\n", event_type[xev.type]);

        switch (xev.type) {

	    case ButtonPress:
		HandleButtonPress(&xev, &sr);
		break;

	    case ConfigureNotify:
		/* If the window has been resized, redraw the picture */
		if (xev.xconfigure.width != PictureWindowWidth || 
		  xev.xconfigure.height != PictureWindowHeight) {
		    XFreePixmap(pds, pxSurface);
		    MakeSurfacePixmap();
                    RedrawSurface(&sr, FALSE);
		}
		break;

	    case Expose:
		/* If this is the first expose event, create and map the */
		/*   control window and its children */
		if (bFirstExpose) {
    		    InitializeControlWindow(sControlGeometry);
		    bFirstExpose = FALSE;
		}
                if (xev.xexpose.window == wnPicture)
		    XCopyArea(pds, pxSurface, wnPicture, gcPicture, 
		      xev.xexpose.x, xev.xexpose.y, xev.xexpose.width, 
		      xev.xexpose.height, xev.xexpose.x, xev.xexpose.y);
	  	else if (xev.xexpose.window == wnControl && 
                       xev.xexpose.count == 0)
		         DrawControlWindow(&sr);
		break;

	    case KeyPress:  
	        ks = XLookupKeysym(&xev, 0);
	        if (ks == XK_q) {	    		/* Quit */
	            XCloseDisplay(pds);
	            exit(0);
	        }
	        else if (ks == XK_r) 			/* Redraw */
		    if (bRedrawValid)
		        RedrawSurface(&sr, TRUE);
		    else XBell(pds, 100);
	        break;
	     
	    case MappingNotify:
		XRefreshKeyboardMapping(&xev);
		break;

	} /* switch */
    } /* while */
} /* main */

