/*
 * Decompiled with CFR 0.152.
 */
package jgridmaker;

import java.awt.Container;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import javax.swing.JComponent;
import jgridmaker.GMCPJButton;
import jgridmaker.GMCPJCheckBox;
import jgridmaker.GMCPJLabel;
import jgridmaker.GMCPJPanel;
import jgridmaker.GMCPJSlider;
import jgridmaker.GMCPJTextArea;
import jgridmaker.GMComponentMaker;
import jgridmaker.GMPCJTextField;
import jgridmaker.JGridParser;

public final class JGridMaker {
    public static boolean REPORT_TOTAL_TIME = false;
    private static boolean _buildin_registered = false;
    private static long TOTAL_TIME = 0L;

    public static synchronized void make_grid(final Container container, final String layout, final HashMap<String, JComponent> obj_map) {
        if (!EventQueue.isDispatchThread() && Thread.currentThread().getId() != 1L) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JGridMaker.make_grid(container, layout, (HashMap<String, JComponent>)obj_map);
                }
            });
            return;
        }
        long start = System.currentTimeMillis();
        if (!_buildin_registered) {
            GMComponentMaker.register_component_parser(new GMCPJButton());
            GMComponentMaker.register_component_parser(new GMCPJTextArea());
            GMComponentMaker.register_component_parser(new GMPCJTextField());
            GMComponentMaker.register_component_parser(new GMCPJSlider());
            GMComponentMaker.register_component_parser(new GMCPJCheckBox());
            GMComponentMaker.register_component_parser(new GMCPJPanel());
            GMComponentMaker.register_component_parser(new GMCPJLabel());
            _buildin_registered = true;
        }
        String xml_layout = "<gridmaker>" + layout + "</gridmaker>";
        xml_layout = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + xml_layout.replace("'", "\"");
        JGridParser my_parser = new JGridParser();
        my_parser.parse_layout(container, xml_layout, obj_map);
        TOTAL_TIME += System.currentTimeMillis() - start;
        if (REPORT_TOTAL_TIME) {
            long secs = TOTAL_TIME / 1000L;
            long rest = TOTAL_TIME - secs * 1000L;
            System.out.println("parsing total time = " + secs + " " + rest);
        }
    }

    public static synchronized void make_grid(final Container container, final File layout_file, final HashMap<String, JComponent> obj_map) {
        if (!EventQueue.isDispatchThread() && Thread.currentThread().getId() != 1L) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JGridMaker.make_grid(container, layout_file, (HashMap<String, JComponent>)obj_map);
                }
            });
            return;
        }
        String layout = new String("");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(layout_file));
            while ((line = in.readLine()) != null) {
                layout = String.valueOf(layout) + line;
            }
            in.close();
            JGridParser my_parser = new JGridParser();
            my_parser.parse_layout(container, layout, obj_map);
        }
        catch (Exception ex) {
            System.err.println("Unhandled Exception in GridMaker::make_grid " + ex);
            System.exit(0);
        }
    }
}

