/*
 * Decompiled with CFR 0.152.
 */
package jgridmaker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jgridmaker.GMComponentMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class JGridParser
extends DefaultHandler {
    public static String KEY_TABLE = "table";
    public static String KEY_TR = "tr";
    public static String KEY_TD = "td";
    public static String KEY_COLGROUP = "colgroup";
    public static String KEY_COL = "col";
    public static String KEY_GRIDMAKER = "gridmaker";
    private Dimension _dim;
    private HashMap<String, JComponent> _obj_map;
    private Container _main_container;
    private Stack<TableInfo> _inner_tables;
    private TableInfo _ti;
    private JComponent _pre_table_comp;
    private String _pre_table_str;
    private TableInfo _last_table = null;

    public void parse_layout(Container container, String xml_layout, HashMap<String, JComponent> obj_map) {
        this._main_container = container;
        this._obj_map = obj_map;
        JGridParser handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        StringReader xml_layout_stream = new StringReader(xml_layout);
        InputSource xml_layout_source = new InputSource(xml_layout_stream);
        this._inner_tables = new Stack();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xml_layout_source, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        eName = eName.toLowerCase();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                ++i;
            }
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints panel_c = new GridBagConstraints();
        panel_c.fill = 1;
        panel_c.weighty = 0.0;
        panel_c.weightx = 0.0;
        this._dim = new Dimension();
        int margin_px = 0;
        if (KEY_TABLE.equals(eName)) {
            Container container = this._inner_tables.size() == 0 ? this._main_container : new JPanel();
            this._ti = new TableInfo(container);
            this._inner_tables.add(this._ti);
            if (attrs != null) {
                String astr = attrs.getValue("cellpadding");
                if (astr != null) {
                    this._ti._table_cellpadding = Integer.parseInt(astr);
                }
                if ((astr = attrs.getValue("border")) != null) {
                    this._ti._border_px = Integer.parseInt(astr);
                }
                if ((astr = attrs.getValue("bgcolor")) != null) {
                    this._ti._table_bgcolor = Color.decode(astr);
                }
                if ((astr = attrs.getValue("margin")) != null) {
                    margin_px = Integer.parseInt(astr);
                }
                if ((astr = attrs.getValue("bordercolor")) != null) {
                    this._ti._border_color = Color.decode(astr);
                }
                if ((astr = attrs.getValue("anchor")) != null) {
                    this._ti._table_anchor = this.get_anchor(astr);
                }
                if ((astr = attrs.getValue("width")) != null) {
                    if (astr.endsWith("%")) {
                        double width = Integer.parseInt(astr.substring(0, astr.length() - 1));
                        panel_c.weightx = width / 100.0;
                    } else {
                        this._dim.width = Integer.parseInt(astr);
                    }
                }
                if ((astr = attrs.getValue("height")) != null) {
                    if (astr.endsWith("%")) {
                        double height = Integer.parseInt(astr.substring(0, astr.length() - 1));
                        panel_c.weighty = height / 100.0;
                    } else {
                        this._dim.height = Integer.parseInt(astr);
                    }
                }
            }
            panel.setBackground(this._ti._container.getBackground());
            this._ti._container.setLayout(new GridBagLayout());
            panel_c.gridx = 1;
            panel_c.gridy = 1;
            panel_c.insets = new Insets(0, 0, 0, 0);
            this._ti._container.add((Component)panel, panel_c);
            panel_c.weightx = 1.0 - panel_c.weightx;
            panel_c.gridx = 0;
            panel_c.gridy = 1;
            panel_c.insets = new Insets(0, margin_px, 0, 0);
            JPanel border_panel = new JPanel();
            border_panel.setPreferredSize(new Dimension(0, 0));
            border_panel.setBackground(this._ti._container.getBackground());
            this._ti._container.add((Component)border_panel, panel_c);
            panel_c.gridx = 2;
            panel_c.gridy = 1;
            panel_c.insets = new Insets(0, 0, 0, margin_px);
            border_panel = new JPanel();
            border_panel.setPreferredSize(new Dimension(0, 0));
            border_panel.setBackground(this._ti._container.getBackground());
            this._ti._container.add((Component)border_panel, panel_c);
            panel_c.weighty = 1.0 - panel_c.weighty;
            panel_c.gridwidth = 3;
            panel_c.insets = new Insets(margin_px, 0, 0, 0);
            panel_c.gridx = 0;
            panel_c.gridy = 0;
            border_panel = new JPanel();
            border_panel.setPreferredSize(new Dimension(0, 0));
            border_panel.setBackground(this._ti._container.getBackground());
            this._ti._container.add((Component)border_panel, panel_c);
            panel_c.insets = new Insets(0, 0, margin_px, 0);
            panel_c.gridx = 0;
            panel_c.gridy = 2;
            border_panel = new JPanel();
            border_panel.setPreferredSize(new Dimension(0, 0));
            border_panel.setBackground(this._ti._container.getBackground());
            this._ti._container.add((Component)border_panel, panel_c);
            this._ti._container = panel;
        } else if (KEY_TR.equals(eName)) {
            if (this._ti._max_x < ((TableInfo)this._ti)._c_ocell.gridx) {
                this._ti._max_x = ((TableInfo)this._ti)._c_ocell.gridx;
            }
            this._ti._tr_bgcolor = this._ti._table_bgcolor;
            this._ti._tr_anchor = this._ti._table_anchor;
            this._ti._tr_height = 1.0;
            this._ti._tr_height_fixed = false;
            ++((TableInfo)this._ti)._c_ocell.gridy;
            ((TableInfo)this._ti)._c_ocell.gridx = -1;
            if (attrs != null) {
                String astr = attrs.getValue("bgcolor");
                if (astr != null) {
                    this._ti._tr_bgcolor = Color.decode(astr);
                }
                if ((astr = attrs.getValue("anchor")) != null) {
                    this._ti._tr_anchor = this.get_anchor(astr);
                }
                if ((astr = attrs.getValue("height")) != null) {
                    if (astr.endsWith("%")) {
                        double height = Integer.parseInt(astr.substring(0, astr.length() - 1));
                        this._ti._tr_height = height / 100.0;
                    } else {
                        this._ti._tr_height = Integer.parseInt(astr);
                        this._ti._tr_height_fixed = true;
                    }
                }
            }
        } else if (KEY_TD.equals(eName)) {
            this._ti._outer_panel = new JPanel();
            this._ti._td_bgcolor = this._ti._tr_bgcolor;
            do {
                ++((TableInfo)this._ti)._c_ocell.gridx;
            } while (this._ti._cell_usage[((TableInfo)this._ti)._c_ocell.gridx][((TableInfo)this._ti)._c_ocell.gridy]);
            ((TableInfo)this._ti)._c_ocell.gridheight = 1;
            ((TableInfo)this._ti)._c_ocell.gridwidth = 1;
            ((TableInfo)this._ti)._c_ocell.weighty = 1.0;
            ((TableInfo)this._ti)._c_ocell.weightx = 1.0;
            if (this._ti._tr_height_fixed) {
                this._dim.height = (int)this._ti._tr_height;
            } else {
                ((TableInfo)this._ti)._c_ocell.weighty = this._ti._tr_height;
            }
            ((TableInfo)this._ti)._c_icell.fill = 0;
            ((TableInfo)this._ti)._c_icell.anchor = this._ti._tr_anchor;
            ((TableInfo)this._ti)._c_icell.insets = new Insets(this._ti._table_cellpadding, this._ti._table_cellpadding, this._ti._table_cellpadding, this._ti._table_cellpadding);
            if (attrs != null) {
                String astr = attrs.getValue("colspan");
                if (astr != null) {
                    ((TableInfo)this._ti)._c_ocell.gridwidth = Integer.parseInt(astr);
                }
                if ((astr = attrs.getValue("rowspan")) != null) {
                    ((TableInfo)this._ti)._c_ocell.gridheight = Integer.parseInt(astr);
                }
                if ((astr = attrs.getValue("anchor")) != null) {
                    ((TableInfo)this._ti)._c_icell.anchor = this.get_anchor(astr);
                }
                if ((astr = attrs.getValue("fill")) != null) {
                    if ("horizontal".equals(astr)) {
                        ((TableInfo)this._ti)._c_icell.fill = 2;
                        ((TableInfo)this._ti)._c_icell.weightx = 1.0;
                    }
                    if ("vertical".equals(astr)) {
                        ((TableInfo)this._ti)._c_icell.fill = 3;
                        ((TableInfo)this._ti)._c_icell.weightx = 1.0;
                    }
                    if ("both".equals(astr)) {
                        ((TableInfo)this._ti)._c_icell.fill = 1;
                        ((TableInfo)this._ti)._c_icell.weightx = 1.0;
                    }
                }
                if ((astr = attrs.getValue("width")) != null) {
                    if (astr.endsWith("%")) {
                        double width = Integer.parseInt(astr.substring(0, astr.length() - 1));
                        ((TableInfo)this._ti)._c_ocell.weightx = width / 100.0;
                    } else {
                        this._dim.width = Integer.parseInt(astr);
                    }
                }
                if ((astr = attrs.getValue("height")) != null) {
                    if (astr.endsWith("%")) {
                        double height = Integer.parseInt(astr.substring(0, astr.length() - 1));
                        ((TableInfo)this._ti)._c_ocell.weighty = height / 100.0;
                    } else {
                        this._dim.height = Integer.parseInt(astr);
                    }
                }
                if ((astr = attrs.getValue("bgcolor")) != null) {
                    this._ti._td_bgcolor = Color.decode(astr);
                }
            }
            int x = ((TableInfo)this._ti)._c_ocell.gridx;
            while (x < ((TableInfo)this._ti)._c_ocell.gridx + ((TableInfo)this._ti)._c_ocell.gridwidth) {
                int y = ((TableInfo)this._ti)._c_ocell.gridy;
                while (y < ((TableInfo)this._ti)._c_ocell.gridy + ((TableInfo)this._ti)._c_ocell.gridheight) {
                    this._ti._cell_usage[x][y] = true;
                    ++y;
                }
                ++x;
            }
            if (this._ti._border_px != 0) {
                int b;
                int l = 0;
                if (((TableInfo)this._ti)._c_ocell.gridx == 0) {
                    l = this._ti._border_px;
                }
                int t = ((TableInfo)this._ti)._c_ocell.gridy == 0 ? this._ti._border_px : 0;
                int r = b = this._ti._border_px;
                this._ti._border = BorderFactory.createMatteBorder(t, l, b, r, this._ti._border_color);
            }
            if (this._ti._colgroup != null) {
                ((TableInfo)this._ti)._c_ocell.weightx = 0.0;
                x = ((TableInfo)this._ti)._c_ocell.gridx;
                while (x < ((TableInfo)this._ti)._c_ocell.gridx + ((TableInfo)this._ti)._c_ocell.gridwidth) {
                    ((TableInfo)this._ti)._c_ocell.weightx += this._ti._colgroup.get(x).doubleValue();
                    ++x;
                }
            }
        } else if (KEY_COLGROUP.equals(eName)) {
            this._ti._colgroup = new Vector();
        } else if (KEY_COL.equals(eName)) {
            String astr;
            if (attrs != null && (astr = attrs.getValue("width")) != null) {
                double width = Integer.parseInt(astr.substring(0, astr.length() - 1));
                this._ti._colgroup.add(width / 100.0);
            }
        } else if (GMComponentMaker.is_component_registered(eName)) {
            if (this._ti == null) {
                this._pre_table_comp = GMComponentMaker.create_component(eName, attrs, this._obj_map);
            } else {
                this._ti._comp = GMComponentMaker.create_component(eName, attrs, this._obj_map);
            }
        } else if (!KEY_GRIDMAKER.equals(eName)) {
            this.throw_error(true, "JGridMaker: Unknown tag: <" + eName + ">");
        }
        if (this._ti != null) {
            this._ti._str = new String();
        } else {
            this._pre_table_str = new String();
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if (KEY_TD.equals(eName = eName.toLowerCase())) {
            JComponent comp;
            if (this._last_table != null) {
                comp = (JPanel)this._last_table._container;
                this._last_table = null;
            } else if (this._ti._str.startsWith("::")) {
                String id = this._ti._str.substring(2, this._ti._str.length() - 2);
                this.throw_error(!this._obj_map.containsKey(id), "Component Missing for " + id);
                comp = this._obj_map.get(id);
                this.throw_error(comp == null, "Null Pointer for " + id);
            } else {
                String label_key;
                comp = new JLabel(this._ti._str);
                int i = 0;
                do {
                    label_key = "JGMLABEL: " + this._ti._str + i;
                    ++i;
                } while (this._obj_map.containsKey(label_key));
                this._obj_map.put(label_key, comp);
            }
            if (this._ti._border_px != 0) {
                this._ti._outer_panel.setBorder(this._ti._border);
            }
            if (this._ti._td_bgcolor != null) {
                comp.setBackground(this._ti._td_bgcolor);
                this._ti._outer_panel.setBackground(this._ti._td_bgcolor);
            } else {
                this._ti._outer_panel.setBackground(this._ti._container.getBackground());
            }
            this._ti._outer_panel.setLayout(new GridBagLayout());
            this._ti._outer_panel.add((Component)comp, this._ti._c_icell);
            this._ti._container.add((Component)this._ti._outer_panel, this._ti._c_ocell);
        } else if (KEY_TABLE.equals(eName)) {
            if (this._ti._colgroup != null) {
                GridBagConstraints c = new GridBagConstraints();
                c.gridy = ((TableInfo)this._ti)._c_ocell.gridy + 1;
                c.gridx = 0;
                while (c.gridx < this._ti._max_x) {
                    c.weightx = this._ti._colgroup.get(c.gridx);
                    JPanel dummy = new JPanel();
                    dummy.setPreferredSize(new Dimension(0, 0));
                    this._ti._container.add((Component)dummy, c);
                    ++c.gridx;
                }
            }
            this._last_table = this._inner_tables.pop();
            this._ti = this._inner_tables.size() != 0 ? (TableInfo)this._inner_tables.lastElement() : null;
        } else if (GMComponentMaker.is_component_registered(eName)) {
            if (this._ti == null) {
                GMComponentMaker.end_component(eName, this._pre_table_comp, this._pre_table_str);
            } else {
                GMComponentMaker.end_component(eName, this._ti._comp, this._ti._str);
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this._ti != null) {
            TableInfo tableInfo = this._ti;
            tableInfo._str = String.valueOf(tableInfo._str) + s;
        } else {
            this._pre_table_str = String.valueOf(this._pre_table_str) + s;
        }
    }

    private int get_anchor(String astr) {
        int result = 10;
        if ("center".equals(astr)) {
            result = 10;
        } else if ("north".equals(astr)) {
            result = 11;
        } else if ("northeast".equals(astr)) {
            result = 12;
        } else if ("east".equals(astr)) {
            result = 13;
        } else if ("southeast".equals(astr)) {
            result = 14;
        } else if ("south".equals(astr)) {
            result = 15;
        } else if ("southwest".equals(astr)) {
            result = 16;
        } else if ("west".equals(astr)) {
            result = 17;
        } else if ("northwest".equals(astr)) {
            result = 18;
        }
        return result;
    }

    private void throw_error(boolean error, String msg) {
        if (error) {
            System.err.println("JGridMaker ERROR: " + msg);
        }
    }

    private class TableInfo {
        public Container _container;
        public boolean[][] _cell_usage;
        public int _table_cellpadding;
        public int _table_anchor;
        public int _tr_anchor;
        public double _tr_height;
        public boolean _tr_height_fixed;
        public Color _table_bgcolor;
        public Color _tr_bgcolor;
        public Color _td_bgcolor;
        public Color _border_color;
        public int _border_px;
        public Border _border;
        public Vector<Double> _colgroup;
        private final GridBagConstraints _c_ocell;
        private final GridBagConstraints _c_icell;
        private int _max_x;
        private JPanel _outer_panel;
        private JComponent _comp;
        private String _str;

        public TableInfo(Container container) {
            this._container = container;
            this._table_cellpadding = 2;
            this._td_bgcolor = null;
            this._tr_bgcolor = null;
            this._border = null;
            this._border_color = null;
            this._border_px = 0;
            this._colgroup = null;
            this._border_color = Color.black;
            this._table_anchor = 10;
            this._c_ocell = new GridBagConstraints();
            this._c_ocell.gridx = -1;
            this._c_ocell.gridy = -1;
            this._c_ocell.insets = new Insets(0, 0, 0, 0);
            this._c_ocell.fill = 1;
            this._c_icell = new GridBagConstraints();
            this._c_icell.gridy = 0;
            this._c_icell.gridx = 0;
            this._c_icell.weighty = 1.0;
            this._c_icell.weightx = 1.0;
            this._max_x = 0;
            this._cell_usage = new boolean[256][256];
            int x = 0;
            while (x < 256) {
                int y = 0;
                while (y < 256) {
                    this._cell_usage[x][y] = false;
                    ++y;
                }
                ++x;
            }
        }
    }
}

