/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.vecmath.Point3d;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.geomarker.GMPoint;
import misc.geomarker.GeoMarker;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public class GeoMarkerSelector
extends JPanel
implements YObserverWantsAWTThread,
ListSelectionListener {
    public static String GM_SELECTION_CHANGED = "__gm__selector__";
    protected final JList _jl_seg_list;
    protected final Class<?> _gm_type;
    protected final DefaultListModel _seg_list_model;
    protected final LinkedList<GeoMarker> _selected_gms;
    protected JLabel _label;

    public GeoMarkerSelector(Class<?> gm_type) {
        this._gm_type = gm_type;
        this._label = null;
        this._selected_gms = new LinkedList();
        this._seg_list_model = new DefaultListModel();
        this._jl_seg_list = new JList(this._seg_list_model);
        this._jl_seg_list.setCellRenderer(new MyCellRenderer());
        this._jl_seg_list.setSelectionMode(0);
        this._jl_seg_list.setPrototypeCellValue(new GMPoint("Fingerknochen", new Point3d(1.0, 1.0, 1.0)));
        this._jl_seg_list.addListSelectionListener(this);
        JScrollPane jsp_list_scroller = new JScrollPane(this._jl_seg_list);
        jsp_list_scroller.setHorizontalScrollBarPolicy(31);
        jsp_list_scroller.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)jsp_list_scroller, "Center");
        ImageStack is = MasterControl.get_is();
        is.addObserver(this, "SegSelector()");
        for (GeoMarker gm : is.get_marker_list()) {
            if (gm.getClass() != this._gm_type) continue;
            this._seg_list_model.addElement(gm);
            gm.addObserver(this, "GeoMarkerSelector::update new marker");
        }
    }

    public GeoMarkerSelector(Class<?> gm_type, boolean show_cb, String label) {
        this(gm_type);
        this._label = new JLabel(label, 0);
        this.add((Component)this._label, "North");
    }

    public LinkedList<GeoMarker> get_selected_markers() {
        return this._selected_gms;
    }

    public GeoMarker get_selected_marker() {
        return this._selected_gms.isEmpty() ? null : this._selected_gms.getFirst();
    }

    public void setSelectionMode(int mode) {
        this._jl_seg_list.setSelectionMode(mode);
    }

    public void setSelectedIndex(int index) {
        this._jl_seg_list.setSelectedIndex(index);
        this.check_for_changes();
    }

    public void setSelectedIndex(int[] indices) {
        this._jl_seg_list.setSelectedIndices(indices);
        this.check_for_changes();
    }

    public boolean check_for_changes() {
        boolean change = false;
        int i = 0;
        while (i < this._seg_list_model.getSize()) {
            GeoMarker gm = (GeoMarker)this._seg_list_model.getElementAt(i);
            if (this._jl_seg_list.isSelectedIndex(i)) {
                if (!this._selected_gms.contains(gm)) {
                    this._selected_gms.add(gm);
                    change = true;
                }
            } else if (this._selected_gms.contains(gm)) {
                this._selected_gms.remove(gm);
                change = true;
            }
            ++i;
        }
        return change;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.check_for_changes()) {
            this.firePropertyChange(GM_SELECTION_CHANGED, null, null);
        }
    }

    @Override
    public void update(YObservable yo, Message m) {
        GeoMarker gm;
        Class<?> gm_type;
        if (yo instanceof ImageStack) {
            GeoMarker gm2;
            Class<?> gm_type2;
            if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
                this._seg_list_model.clear();
            } else if (m._type == ImageStack.M_NEW_MARKER && (gm_type2 = (gm2 = (GeoMarker)m._obj).getClass()) == this._gm_type) {
                this._seg_list_model.addElement(gm2);
                gm2.addObserver(this, "GeoMarkerSelector::update new marker");
            }
        } else if (yo instanceof GeoMarker && (gm_type = (gm = (GeoMarker)yo).getClass()) == this._gm_type) {
            if (m._type == ImageStack.M_DEL_MARKER) {
                gm.deleteObserver(this);
                this._selected_gms.remove(gm);
                this._seg_list_model.removeElement(gm);
                this.check_for_changes();
                this.firePropertyChange(GM_SELECTION_CHANGED, null, null);
            } else if (m._type == GeoMarker.M_MARKER_LABEL_CHANGED) {
                this.repaint();
            } else if (m._type == GeoMarker.M_MARKER_COL_CHANGED) {
                this.repaint();
            }
        }
    }

    final class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        final JLabel _jl_text;
        final JPanel _jp_color_box;

        public MyCellRenderer() {
            this.setOpaque(true);
            this._jl_text = new JLabel("---");
            Dimension box_size = new Dimension(12, 12);
            this._jp_color_box = new JPanel();
            this._jp_color_box.setPreferredSize(box_size);
            this._jp_color_box.setMaximumSize(box_size);
            this._jp_color_box.setMinimumSize(box_size);
            this._jp_color_box.setOpaque(true);
            this._jp_color_box.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            JPanel jp_color_box_parent = new JPanel(new FlowLayout());
            jp_color_box_parent.setOpaque(false);
            jp_color_box_parent.add(this._jp_color_box);
            this.setLayout(new BorderLayout());
            this.add((Component)jp_color_box_parent, "West");
            this.add((Component)this._jl_text, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof GeoMarker) {
                Color def_fg;
                Color def_bg;
                GeoMarker gm = (GeoMarker)value;
                this._jl_text.setText(gm.get_label());
                this._jp_color_box.setBackground(gm.get_color());
                if (isSelected) {
                    def_bg = list.getSelectionBackground();
                    def_fg = list.getSelectionForeground();
                } else {
                    def_bg = list.getBackground();
                    def_fg = list.getForeground();
                }
                Color bg = new Color(def_bg.getRed(), def_bg.getGreen(), def_bg.getBlue());
                Color fg = new Color(def_fg.getRed(), def_fg.getGreen(), def_fg.getBlue());
                this.setBackground(bg);
                this.setForeground(fg);
            }
            return this;
        }
    }
}

