/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ColorBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.geomarker.GeoMarker;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.MarkerRenderer;

public class GeoMarkerShowTable
extends JPanel
implements YObserverWantsAWTThread,
TableModelListener {
    private final JTable _jt_geo_marker;
    private ArrayList<GeoMarker> _markers;
    private final DefaultTableModel _table_model;
    private final MarkerRenderer _mr;

    public GeoMarkerShowTable(MarkerRenderer mr) {
        this._mr = mr;
        Object[] columns = new Object[]{"", "Marker", ""};
        Object[][] data = new Object[0][3];
        this._table_model = new DefaultTableModel(data, columns){

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Color.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Boolean.class;
                    }
                }
                return null;
            }
        };
        this._table_model.addTableModelListener(this);
        this._markers = new ArrayList();
        this._jt_geo_marker = new JTable(this._table_model);
        this._jt_geo_marker.setDefaultRenderer(Color.class, new ColorBox());
        this._jt_geo_marker.getColumnModel().getColumn(0).setMinWidth(20);
        this._jt_geo_marker.getColumnModel().getColumn(0).setPreferredWidth(20);
        this._jt_geo_marker.getColumnModel().getColumn(0).setMaxWidth(20);
        this._jt_geo_marker.getColumnModel().getColumn(2).setMinWidth(20);
        this._jt_geo_marker.getColumnModel().getColumn(2).setPreferredWidth(20);
        this._jt_geo_marker.getColumnModel().getColumn(2).setMaxWidth(20);
        this._jt_geo_marker.setRowHeight(20);
        this._jt_geo_marker.getTableHeader().setResizingAllowed(false);
        this._jt_geo_marker.setPreferredScrollableViewportSize(this._jt_geo_marker.getPreferredSize());
        this._jt_geo_marker.setTableHeader(null);
        JScrollPane jsp_table_scroller = new JScrollPane(this._jt_geo_marker);
        jsp_table_scroller.setHorizontalScrollBarPolicy(31);
        jsp_table_scroller.setVerticalScrollBarPolicy(22);
        jsp_table_scroller.setColumnHeader(null);
        this.setLayout(new BorderLayout());
        this.add((Component)jsp_table_scroller, "Center");
        jsp_table_scroller.revalidate();
        ImageStack is = MasterControl.get_is();
        Set<String> marker_names = is.get_marker_names();
        Iterator<String> igm = marker_names.iterator();
        while (igm.hasNext()) {
            GeoMarker gm = is.get_marker(igm.next());
            this.add_gm(gm);
        }
        is.addObserver(this, "GeoMarkerShowTable()");
    }

    private void add_gm(GeoMarker gm) {
        Object[] row = new Object[]{gm.get_color(), gm.get_label(), new Boolean(true)};
        this._table_model.addRow(row);
        this._markers.add(gm);
        gm.addObserver(this, "GeoMarkerShowTable::update new marker");
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            while (this._table_model.getRowCount() > 0) {
                this._table_model.removeRow(0);
            }
            this._markers.clear();
        } else if (m._type == ImageStack.M_NEW_MARKER) {
            this.add_gm((GeoMarker)m._obj);
        } else if (m._type == ImageStack.M_DEL_MARKER) {
            GeoMarker gm = (GeoMarker)m._obj;
            int i = 0;
            while (i < this._markers.size()) {
                if (this._markers.get(i) == gm) {
                    this._table_model.removeRow(i);
                    this._markers.remove(i);
                }
                ++i;
            }
        } else if (m._type == GeoMarker.M_MARKER_LABEL_CHANGED) {
            this.repaint();
        } else if (m._type == GeoMarker.M_MARKER_COL_CHANGED) {
            this.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        if (tme.getType() == 0) {
            int row_index = tme.getFirstRow();
            Vector row = this._table_model.getDataVector().elementAt(row_index);
            this._mr.set_marker_visible(this._markers.get(row_index), (Boolean)row.get(2));
        }
    }
}

