/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.VoxelCubeHistogram;
import misc.Voxel;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.BGImageRenderer2d;
import settings.Settings;
import settings.SettingsOwner;

public final class HistoPanel
extends JPanel
implements ComponentListener,
YObserverWantsAWTThread,
SettingsOwner {
    public static final String OPT_USE_LOG = Settings.register_bool_opt(HistoPanel.class, "use logarithm", "Use logarithmic scaling", true);
    public static final String OPT_SHOW_ALL = Settings.register_bool_opt(HistoPanel.class, "show full range", "Shows the complete histogram range or crops to first/last nonzero value", false);
    public static final String OPT_LABELS_USE_IS = Settings.register_bool_opt(HistoPanel.class, "use intercept+slope", "Shows the value labels modified with intercept/slope", true);
    private BufferedImage _bimg;
    private static final int DELTA_X = 0;
    private static final int DELTA_Y = 15;
    private int _w;
    private int _h;
    private int _histo_min;
    private int _histo_max;
    private BGImageRenderer2d _ir2d = null;
    private final String _name;
    private double _factor;
    private int[] _area_i1 = new int[0];
    private int[] _area_i2 = new int[0];
    private Color[] _area_col = new Color[0];
    private final VoxelCubeHistogram _vch;
    private final boolean _draw_border;
    private final boolean _draw_roi;

    public HistoPanel(VoxelCubeHistogram vch, String name) {
        this(vch, name, true, true);
    }

    public HistoPanel(VoxelCubeHistogram vch, String name, boolean draw_border, boolean draw_roi) {
        this._bimg = new BufferedImage(10, 10, 2);
        this._name = name;
        this._draw_border = draw_border;
        this._draw_roi = draw_roi;
        this._vch = vch;
        this._vch.addObserver(this, "HistoPanel()");
        this.addComponentListener(this);
        MasterControl.get_is().addObserver(this, "HistoPanel()");
        Settings.register_owner(this);
        this.setOpaque(false);
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2) {
            this.init_min_max();
            this.update_image();
        }
    }

    private void update_image() {
        this._w = this.getWidth();
        this._h = this.getHeight();
        if (this._draw_border) {
            this._w -= 0;
            this._h -= 15;
        }
        if (this._w <= 2) {
            this._w = 3;
        }
        if (this._h <= 2) {
            this._h = 3;
        }
        if (MasterControl.get_is().get_state() == 2) {
            int height;
            int width;
            if (this._draw_border) {
                width = this._w - 2;
                height = this._h - 2;
            } else {
                width = this._w;
                height = this._h;
            }
            if (this._bimg == null || this._bimg.getWidth() != width || this._bimg.getHeight() != height) {
                this._bimg = new BufferedImage(width, height, 2);
            }
            Color c = this.getBackground();
            this._vch.render_image(this._bimg, c, Color.LIGHT_GRAY, Settings.get_bool_option(this, OPT_USE_LOG), Settings.get_bool_option(this, OPT_SHOW_ALL));
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void highlight_interval(int i1, int i2, Color col) {
        this._area_i1 = new int[1];
        this._area_i2 = new int[1];
        this._area_col = new Color[1];
        this._area_i1[0] = i1;
        this._area_i2[0] = i2;
        this._area_col[0] = col;
        this.repaint();
    }

    public void highlight_intervals(int[] i1, int[] i2, Color[] col) {
        this._area_i1 = new int[i1.length];
        this._area_i2 = new int[i2.length];
        this._area_col = new Color[col.length];
        int i = 0;
        while (i < col.length) {
            this._area_i2[i] = i1[i];
            this._area_i2[i] = i2[i];
            this._area_col[i] = col[i];
            ++i;
        }
        this.repaint();
    }

    public void set_renderer(BGImageRenderer2d ir2d) {
        this._ir2d = ir2d;
        if (this._ir2d == null) {
            Settings.register_class_listener(BGImageRenderer2d.class, this);
        } else {
            Settings.register_obj_listener(this._ir2d, this);
        }
        if (MasterControl.get_is().get_state() != 0) {
            this.update_image();
        }
    }

    private void init_min_max() {
        if (Settings.get_bool_option(this, OPT_SHOW_ALL).booleanValue()) {
            this._histo_min = 0;
            this._histo_max = this._vch._histo.length;
        } else {
            this._histo_min = this._vch._min_nonzero_index;
            this._histo_max = this._vch._max_nonzero_index;
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == VoxelCubeHistogram.M_VCH_UPDATE) {
            this.init_min_max();
            this.update_image();
        }
        if (m._type == ImageStack.M_SELECTXYZ) {
            this.repaint();
        }
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj == this) {
            if (opt_name == OPT_LABELS_USE_IS) {
                this.repaint();
            }
            if (opt_name == OPT_USE_LOG) {
                this.update_image();
            }
            if (opt_name == OPT_SHOW_ALL) {
                this.init_min_max();
                this.update_image();
            }
        }
        if (obj == this._ir2d || obj == BGImageRenderer2d.class) {
            this.update_image();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.update_image();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        int border_width;
        if (this._draw_border) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 0 - 1, this.getHeight() - 15 - 1);
            border_width = 1;
        } else {
            border_width = 0;
        }
        g.drawImage(this._bimg, border_width, border_width, this._bimg.getWidth(), this._bimg.getHeight(), null);
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2) {
            int pixpos_w_width;
            int pixpos_w_center;
            int intercept = is.get_intercept();
            int slope = is.get_slope();
            if (this._ir2d == null) {
                pixpos_w_center = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER);
                pixpos_w_width = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH);
            } else {
                pixpos_w_center = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_CENTER);
                pixpos_w_width = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_WIDTH);
            }
            if (Settings.get_bool_option(this, OPT_SHOW_ALL).booleanValue()) {
                this._factor = (double)this._w / (double)this._vch._histo.length;
            } else {
                this._factor = (double)this._w / (double)(this._histo_max - this._histo_min);
                pixpos_w_center -= this._histo_min;
            }
            pixpos_w_center = (int)Math.round((double)((pixpos_w_center - intercept) / slope) * this._factor);
            pixpos_w_width = (int)Math.round((double)pixpos_w_width * this._factor);
            if (this._draw_roi) {
                g.setColor(new Color(0, 0, 255, 255));
                g.drawLine(pixpos_w_center + border_width, this._h - border_width, pixpos_w_center + border_width, border_width);
                g.setColor(new Color(128, 128, 255, 128));
                g.fillRect(pixpos_w_center - pixpos_w_width / 2 + border_width, border_width, pixpos_w_width, this._h - 2 * border_width);
            }
            int i = 0;
            while (i < this._area_col.length) {
                g.setColor(this._area_col[i]);
                int pix_pos_area1 = (int)((double)(this._area_i1[i] - this._histo_min) * this._factor);
                int pix_pos_area2 = (int)((double)(this._area_i2[i] - this._histo_min) * this._factor);
                g.fillRect(pix_pos_area1, border_width, pix_pos_area2 - pix_pos_area1, this._h - 2 * border_width);
                ++i;
            }
            LinkedList<Voxel> seeds = is.get_seeds();
            Iterator si = seeds.iterator();
            g.setColor(new Color(255, 0, 255, 128));
            while (si.hasNext()) {
                Voxel seed = (Voxel)si.next();
                int seed_value = is.get_voxel_cube().get(seed._x, seed._y, seed._z) - this._histo_min;
                int pixpos_seed = (int)Math.round((double)seed_value * this._factor);
                g.drawLine(pixpos_seed, 1, pixpos_seed, this._h - 2);
            }
            if (this._draw_border) {
                g.setColor(new Color(0, 0, 0, 255));
                int min = is.get_raw_value(this._histo_min);
                int max = is.get_raw_value(this._histo_max);
                if (Settings.get_bool_option(this, OPT_LABELS_USE_IS).booleanValue()) {
                    min = min * slope + intercept;
                    max = max * slope + intercept;
                }
                String str_min = new String("" + min);
                String str_max = new String("" + max);
                FontMetrics fm = g.getFontMetrics(g.getFont());
                g.drawString(str_min, 0, this._h + 15);
                g.drawString(str_max, this._w - fm.stringWidth(str_max), this._h + 15);
                g.drawLine(0, this._h, 0, this._h + 3);
                g.drawLine(this._w - 1, this._h, this._w - 1, this._h + 3);
            }
        }
        super.paintComponent(g);
    }
}

