/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JTFSlider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTFSliderDouble
extends JTFSlider {
    private static final int DEF_INT_DIGITS = 3;
    private static final int DEF_FRAC_DIGITS = 5;
    protected double _value;
    protected double _min;
    protected double _max;
    protected final int _multiplier;

    public JTFSliderDouble(int orientation, double min, double max, double def, int int_digits, int fract_digits) {
        super(orientation);
        this._min = min;
        this._max = max;
        this._value = def >= min && def <= max ? def : min + (max - min) / 2.0;
        this._multiplier = (int)Math.pow(10.0, fract_digits + int_digits);
        this._jslider.setMinimum((int)(min * (double)this._multiplier));
        this._jslider.setMaximum((int)(max * (double)this._multiplier));
        this._jslider.setValue((int)(this._value * (double)this._multiplier));
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(int_digits);
        nf.setMaximumFractionDigits(fract_digits);
        this._formatter.setFormat(nf);
        this._formatter.setMinimum(Double.valueOf(min));
        this._formatter.setMaximum(Double.valueOf(max));
        this._jftf.setColumns(fract_digits + int_digits);
        this._jftf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double new_value = (Double)JTFSliderDouble.this._jftf.getValue();
                double old_value = JTFSliderDouble.this._value;
                JTFSliderDouble.this._value = new_value;
                JTFSliderDouble.this._jslider.setValue((int)(new_value * (double)JTFSliderDouble.this._multiplier));
                JTFSliderDouble.this.firePropertyChange(JTF_CHANGE, new Double(old_value), new Double(new_value));
            }
        });
        this._jftf.setFocusLostBehavior(2);
        this._jftf.setVerifyInputWhenFocusTarget(true);
        this._jftf.setInputVerifier(new MyTextFieldVerifier());
        this.setValue(this._value);
        this._jslider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                double new_value = (double)source.getValue() / (double)JTFSliderDouble.this._multiplier;
                double old_value = JTFSliderDouble.this._value;
                JTFSliderDouble.this._value = new_value;
                JTFSliderDouble.this._jftf.setValue(JTFSliderDouble.this._value);
                JTFSliderDouble.this.firePropertyChange(JTF_CHANGE, new Double(old_value), new Double(new_value));
            }
        });
        this._jftf.setValue(new Double(this._value));
    }

    public JTFSliderDouble(double min, double max, double def, int int_digits, int fract_digits) {
        this(0, min, max, def, int_digits, fract_digits);
    }

    public JTFSliderDouble(double min, double max, double def) {
        this(min, max, def, 3, 5);
    }

    public double getValue() {
        return this._value;
    }

    public double getMinimum() {
        return this._min;
    }

    public double getMaximum() {
        return this._max;
    }

    public void setValue(double value) {
        if (value != this._value && this._min <= value && this._max >= value) {
            int int_value = (int)(value * (double)this._multiplier);
            this._value = value;
            this._jslider.setValue(int_value);
            this._jftf.setValue(new Double(value));
        }
    }

    public void setValueAndFireEvent(int value) {
        if ((double)value != this._value && this._min <= (double)value && this._max >= (double)value) {
            double old_value = this._value;
            int int_value = value * this._multiplier;
            this._value = value;
            this._jslider.setValue(int_value);
            this._jftf.setValue(new Double(value));
            this.firePropertyChange(JTF_CHANGE, new Double(old_value), new Double(value));
        }
    }

    public void setMinimum(double value) {
        this._min = value;
        int int_value = (int)(value * (double)this._multiplier);
        this._jslider.setMinimum(int_value);
        this._formatter.setMinimum(Double.valueOf(value));
    }

    public void setMaximum(double value) {
        this._max = value;
        int int_value = (int)(value * (double)this._multiplier);
        this._jslider.setMaximum(int_value);
        this._formatter.setMaximum(Double.valueOf(value * (double)this._multiplier));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._jslider.setEnabled(enabled);
        this._jftf.setEnabled(enabled);
    }

    private class MyTextFieldVerifier
    extends InputVerifier {
        private MyTextFieldVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result;
            String text = JTFSliderDouble.this._jftf.getText();
            try {
                Double new_value = (Double)JTFSliderDouble.this._formatter.stringToValue(text);
                JTFSliderDouble.this._value = new_value;
                result = true;
            }
            catch (Exception ex) {
                result = false;
            }
            return result;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            if (this.verify(input)) {
                JTFSliderDouble.this._jslider.setValue((int)(JTFSliderDouble.this._value * (double)JTFSliderDouble.this._multiplier));
            }
            return true;
        }
    }
}

