/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.vecmath.Point3i;
import main.Message;
import main.YaDiV;
import main.seggen.atlas.Atlas;
import main.seggen.atlas.VoxelCubeJointHistogram;
import main.seggen.atlas.similarity.EntropieComputer;
import main.seggen.atlas.similarity.HistogramPartComputer;
import misc.StopWatch;
import misc.messages.YObservable;
import misc.messages.YObserver;

public final class JointHistogramPanel
extends JPanel
implements ComponentListener,
MouseListener,
YObserver {
    public static final int DeltaX = 2;
    public static final int DeltaY = 2;
    private BufferedImage _img;
    private final VoxelCubeJointHistogram _hist;

    public JointHistogramPanel() {
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(200, 200));
        this._hist = VoxelCubeJointHistogram.get_instance();
        this._hist.addObserver(this, "JointHistogramPanel()");
        this.addComponentListener(this);
        this.addMouseListener(this);
        this._img = new BufferedImage(512, 512, 2);
    }

    public void update_image() {
        this._hist.render_image(this._img, this.getBackground());
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int min = Math.min(this.getWidth(), this.getHeight());
        if (min > this.getHeight() - 25) {
            min -= 25;
        }
        g.drawImage(this._img, 0, 0, min, min, null);
        g.drawString("Similarity: ", 2, min + 20);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.update_image();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == VoxelCubeJointHistogram.M_VCJH_UPDATE) {
            this._hist.render_image(this._img, this.getBackground());
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        Atlas atlas = Atlas.get_instance();
        if (atlas.get_voxel_cube() != null) {
            StopWatch sw = new StopWatch();
            EntropieComputer joint_entropy = new EntropieComputer();
            EntropieComputer atlas_entropy = new EntropieComputer();
            EntropieComputer image_entropy = new EntropieComputer();
            Point3i finish = new Point3i(atlas.get_voxel_cube().get_dim_x() - 1, atlas.get_voxel_cube().get_dim_y() - 1, atlas.get_voxel_cube().get_dim_z() - 1);
            HistogramPartComputer h = new HistogramPartComputer(atlas, joint_entropy, image_entropy, atlas_entropy, atlas.get_trans(), new Point3i(0, 0, 0), finish);
            try {
                h.call();
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "JointHistogramPanel:actionPerformed: SOMETHING WENT WRONG!!!");
                ex.printStackTrace();
            }
            float sim = (atlas_entropy.compute() + image_entropy.compute()) / joint_entropy.compute();
            this._hist.build_histogram(joint_entropy, "" + sim);
            this.update_image();
            sw.stop();
            YaDiV.report(YaDiV.ReportType.REPORT_TIME, "FINISHED after " + sw.toString());
        }
    }
}

