/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.JGridMaker;
import main.MainWindow;
import main.MasterControl;
import main.view3d.LightModel;
import main.view3d.LightSettings;
import misc.helper.Helper;

public class LightDialog
extends JDialog {
    private static LightDialog _instance;
    private final JTextField _jtf_name;
    private final LightModel _template;

    public LightDialog(LightModel m) {
        super((Frame)MasterControl.get_window(), true);
        MainWindow win = MasterControl.get_window();
        this._template = m;
        final LightSettings lights = MasterControl.get_lights();
        this.setTitle("Create new light");
        this._jtf_name = new JTextField(Helper.get_unique_key("light", lights.keySet()), 20);
        JButton jb_ok = new JButton("Ok");
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = LightDialog.this._jtf_name.getText();
                LightModel new_light = LightDialog.this._template == null ? new LightModel(name) : new LightModel(LightDialog.this._template, name);
                if (!lights.containsKey(name)) {
                    lights.add_light(new_light);
                    _instance.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(MasterControl.get_window(), "Light name must be unique.", "Inane error", 0);
                }
            }
        });
        JButton jb_cancel = new JButton("Cancel");
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                _instance.setVisible(false);
            }
        });
        HashMap<String, JComponent> obj_map = new HashMap<String, JComponent>();
        obj_map.put("jtf_name", this._jtf_name);
        obj_map.put("jb_ok", jb_ok);
        obj_map.put("jb_cancel", jb_cancel);
        JPanel button_panel = new JPanel();
        JGridMaker.make_grid((Container)button_panel, (String)"<table width='100%' cellpadding='2' border='0'>  <tr>    <td>::jb_ok::</td>    <td>::jb_cancel::</td>  </tr></table>", obj_map);
        obj_map.put("button_panel", button_panel);
        JGridMaker.make_grid((Container)this, (String)"<table width='100%' cellpadding='2' margin='10' border='0'>  <tr>    <td>Light Name:</td>    <td>::jtf_name::</td>  </tr><tr>    <td colspan='2'>::button_panel::</td>  </tr></table>", obj_map);
        this.pack();
        int pw = win.getWidth();
        int ph = win.getHeight();
        int px = win.getLocation().x;
        int py = win.getLocation().y;
        int w = this.getWidth();
        int h = this.getHeight();
        this.setLocation(px + pw / 2 - w / 2, py + ph / 2 - h / 2);
        _instance = this;
    }
}

