/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.HistoPanel;
import gui.JTFSliderInt;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.VoxelCubeHistogram;
import misc.Voxel;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.BGImageRenderer2d;
import settings.JBoolOptionCheckbox;
import settings.JIntegerOptionTFSlider;
import settings.Settings;

public final class ROIPanel
extends GMPanel
implements YObserverWantsAWTThread {
    private final JIntegerOptionTFSlider _jtf_wcenter;
    private final JIntegerOptionTFSlider _jtf_wwidth;
    private final JBoolOptionCheckbox _jbocb_show_all;
    private final JBoolOptionCheckbox _jbocb_use_log;
    private final BGImageRenderer2d _ir2d;
    private final HistoPanel _hp;
    private final JButton _jb_use_seed_range;
    private final JButton _jb_center_to_seed;
    private final JButton _jb_use_histo_range;

    public ROIPanel(BGImageRenderer2d ir2d, boolean border, String title_text) {
        this._ir2d = ir2d;
        int state = MasterControl.get_is().get_state();
        this._jb_center_to_seed = new JButton("Center to Seed");
        this._jb_center_to_seed.setToolTipText("Sets the Center of the ROI Window to the mean value of the selected seed(s)");
        this._jb_center_to_seed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                RegularGrid3i vc = is.get_voxel_cube();
                LinkedList<Voxel> seeds = is.get_seeds();
                Iterator si = seeds.iterator();
                Voxel v = (Voxel)si.next();
                int min = vc.get(v._x, v._y, v._z);
                int max = vc.get(v._x, v._y, v._z);
                while (si.hasNext()) {
                    v = (Voxel)si.next();
                    if (min > vc.get(v._x, v._y, v._z)) {
                        min = vc.get(v._x, v._y, v._z);
                    }
                    if (max >= vc.get(v._x, v._y, v._z)) continue;
                    max = vc.get(v._x, v._y, v._z);
                }
                int intercept = is.get_intercept();
                int slope = is.get_slope();
                int center = min + (max - min) / 2;
                center = center * slope + intercept;
                if (ROIPanel.this._ir2d == null) {
                    Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER, center);
                } else {
                    Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_CENTER, center);
                }
            }
        });
        this._jb_use_histo_range = new JButton("Use Histogram Range");
        this._jb_use_histo_range.setToolTipText("Use the minimum and maximum value of the histogram as minimum and maximum for the ROI window");
        this._jb_use_histo_range.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                VoxelCubeHistogram vch = is.get_vch();
                int min = vch._min_nonzero_index;
                int max = vch._max_nonzero_index;
                int intercept = is.get_intercept();
                int slope = is.get_slope();
                int center = min + (max - min) / 2;
                center = center * slope + intercept;
                if (ROIPanel.this._ir2d == null) {
                    Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER, center);
                    Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH, max - min);
                } else {
                    Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_CENTER, center);
                    Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_WIDTH, max - min);
                }
            }
        });
        this._jb_use_seed_range = new JButton("Use Seed Range");
        this._jb_use_seed_range.setToolTipText("Use the minum and maximum value of the selected seeds as minimum and maximum for the ROI window");
        this._jb_use_seed_range.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageStack is = MasterControl.get_is();
                RegularGrid3i vc = is.get_voxel_cube();
                LinkedList<Voxel> seeds = is.get_seeds();
                Iterator si = seeds.iterator();
                Voxel v = (Voxel)si.next();
                int min = vc.get(v._x, v._y, v._z);
                int max = vc.get(v._x, v._y, v._z);
                while (si.hasNext()) {
                    v = (Voxel)si.next();
                    if (min > vc.get(v._x, v._y, v._z)) {
                        min = vc.get(v._x, v._y, v._z);
                    }
                    if (max >= vc.get(v._x, v._y, v._z)) continue;
                    max = vc.get(v._x, v._y, v._z);
                }
                int intercept = is.get_intercept();
                int slope = is.get_slope();
                int center = min + (max - min) / 2;
                center = center * slope + intercept;
                if (ROIPanel.this._ir2d == null) {
                    Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER, center);
                    Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH, max - min);
                } else {
                    Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_CENTER, center);
                    Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_WIDTH, max - min);
                }
            }
        });
        this._jb_use_seed_range.setEnabled(false);
        int cmax = 10;
        int wmax = 10;
        if (this._ir2d == null) {
            if (state == 0) {
                cmax = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER) * 2;
                wmax = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH) * 2;
            }
            this._jtf_wcenter = new JIntegerOptionTFSlider(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER, 0, cmax);
            this._jtf_wwidth = new JIntegerOptionTFSlider(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH, 0, wmax);
        } else {
            if (state == 0) {
                cmax = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_CENTER) * 2;
                wmax = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_WIDTH) * 2;
            }
            this._jtf_wcenter = new JIntegerOptionTFSlider(this._ir2d, BGImageRenderer2d.OPT_W_CENTER, 0, cmax);
            this._jtf_wwidth = new JIntegerOptionTFSlider(this._ir2d, BGImageRenderer2d.OPT_W_WIDTH, 0, wmax);
        }
        String name = this._ir2d == null ? "IRGlobal" : "IR" + this._ir2d.get_name();
        this._hp = new HistoPanel(MasterControl.get_is().get_vch(), name);
        this._hp.setPreferredSize(new Dimension(400, 80));
        this._jbocb_show_all = new JBoolOptionCheckbox(this._hp, HistoPanel.OPT_SHOW_ALL);
        this._jbocb_use_log = new JBoolOptionCheckbox(this._hp, HistoPanel.OPT_USE_LOG);
        this._jtf_wwidth.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (JTFSliderInt.JTF_CHANGE.equals(property)) {
                    int window_width = (Integer)propertyChangeEvent.getNewValue();
                    if (ROIPanel.this._ir2d == null) {
                        Settings.set_class_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH, window_width);
                    } else {
                        Settings.set_int_option(ROIPanel.this._ir2d, BGImageRenderer2d.OPT_W_WIDTH, window_width);
                    }
                }
            }
        });
        GMPanel yp_buttons = new GMPanel();
        yp_buttons.add("_jb_use_seed_range", (JComponent)this._jb_use_seed_range);
        yp_buttons.add("_jb_center_to_seed", (JComponent)this._jb_center_to_seed);
        yp_buttons.add("_jb_use_histo_range", (JComponent)this._jb_use_histo_range);
        yp_buttons.set_layout("<table cellpadding='2' border='0' width='100%'>  <tr>    <td width='1%' fill='horizontal'>::_jb_use_histo_range::</td>    <td width='1%' fill='horizontal'>::_jb_center_to_seed::</td>    <td width='1%' fill='horizontal'>::_jb_use_seed_range::</td>    <td width='97%'> </td>  </tr></table>");
        this.add("_jtf_wcenter", this._jtf_wcenter);
        this.add("_jtf_wwidth", this._jtf_wwidth);
        this.add("yp_buttons", (JComponent)yp_buttons);
        this.add("_hp", this._hp);
        this.add("_jbocb_show_all", this._jbocb_show_all);
        this.add("_jbocb_use_log", this._jbocb_use_log);
        this.set_layout("<table width='100%' cellpadding='2' border='0'>  <tr>    <td colspan='2' fill='both'>::_hp::</td>  </tr><tr>    <td width='1%'>Window Center:</td>    <td width='99%' fill='horizontal'>::_jtf_wcenter::</td>  </tr><tr>    <td width='1%'>Window Width:</td>    <td width='99%' fill='horizontal'>::_jtf_wwidth::</td>  </tr><tr>    <td colspan='2' fill='horizontal'>::yp_buttons::</td>  </tr></table>");
        if (border) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title_text, 2, 2));
        }
        this._hp.set_renderer(ir2d);
        MasterControl.get_is().addObserver(this, "ROIPanel()");
        this.init_values();
    }

    private final void init_values() {
        int wwidth;
        int wcenter;
        ImageStack is = MasterControl.get_is();
        int max_pixel_value = is.get_state() == 2 ? is.get_voxel_value_range() : 0;
        int intercept = is.get_intercept();
        int slope = is.get_slope();
        int wcenter_min = 0 + intercept;
        int wcenter_max = max_pixel_value * slope;
        boolean wwidth_min = true;
        int wwidth_max = 2 * max_pixel_value * slope;
        this._jtf_wcenter.setMinimum(wcenter_min);
        this._jtf_wcenter.setMaximum(wcenter_max);
        this._jtf_wwidth.setMinimum(1);
        this._jtf_wwidth.setMaximum(wwidth_max);
        if (this._ir2d == null) {
            wcenter = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_CENTER);
            wwidth = Settings.get_int_option(BGImageRenderer2d.class, BGImageRenderer2d.OPT_W_WIDTH);
        } else {
            wcenter = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_CENTER);
            wwidth = Settings.get_int_option(this._ir2d, BGImageRenderer2d.OPT_W_WIDTH);
        }
        this._jtf_wcenter.setValue(wcenter);
        this._jtf_wwidth.setValue(wwidth);
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_LOADING_END) {
            this.init_values();
        } else if (m._type == ImageStack.M_SELECTXYZ) {
            if (MasterControl.get_is().get_seeds().size() >= 1) {
                this._jb_center_to_seed.setEnabled(true);
            } else {
                this._jb_center_to_seed.setEnabled(false);
            }
            if (MasterControl.get_is().get_seeds().size() > 1) {
                this._jb_use_seed_range.setEnabled(true);
            } else {
                this._jb_use_seed_range.setEnabled(false);
            }
        }
    }
}

