/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.JColorChooseButton;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jgridmaker.JGridMaker;
import main.ImageStack;
import main.MainWindow;
import main.MasterControl;
import main.Segment;
import misc.helper.Helper;

public class SegDialog
extends JDialog {
    private static SegDialog _instance;
    private JTextField _jtf_name;
    private JColorChooseButton _jccb_segcolor;
    private final Segment _seg;
    public static int MAX_SEG_NUM;
    public static int[] DEF_COLORS;

    static {
        MAX_SEG_NUM = 64;
        DEF_COLORS = SegDialog.fill_colors(MAX_SEG_NUM);
    }

    private static int[] fill_colors(int size) {
        int[] colors = new int[size];
        Random rnd = new Random(42L);
        int i = 0;
        while (i < size) {
            colors[i] = rnd.nextInt() & 0xFFFFFF;
            ++i;
        }
        colors[0] = 65280;
        colors[1] = 65535;
        colors[2] = 43588;
        colors[3] = 17578;
        colors[4] = 8789;
        colors[5] = 21794;
        colors[6] = 0x224422;
        return colors;
    }

    public SegDialog(Segment seg) {
        super((Frame)MasterControl.get_window(), true);
        MainWindow win = MasterControl.get_window();
        this._seg = seg;
        ImageStack is = MasterControl.get_is();
        if (this._seg == null) {
            this.setTitle("Create new segment");
            int seg_num = is.get_segment_number() - 1;
            int seg_color_as_int = DEF_COLORS[seg_num];
            this._jtf_name = new JTextField(Helper.get_unique_key("seg", is.get_seg_map().keySet()), 20);
            this._jccb_segcolor = new JColorChooseButton(new Color(seg_color_as_int));
        } else {
            this.setTitle("Edit segment");
            this._jtf_name = new JTextField(this._seg.get_name(), 20);
            this._jccb_segcolor = new JColorChooseButton(new Color(this._seg.get_color()));
        }
        JButton jb_ok = new JButton("Ok");
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = SegDialog.this._jtf_name.getText();
                Color col = SegDialog.this._jccb_segcolor.getSelectedColor();
                int col_int = col.getRGB();
                col_int &= 0xFFFFFF;
                ImageStack is = MasterControl.get_is();
                if (SegDialog.this._seg == null) {
                    if (is.get_segment(name) == null) {
                        is.create_segment(name, col_int);
                        _instance.setVisible(false);
                    } else {
                        JOptionPane.showMessageDialog(MasterControl.get_window(), "Segment name must be unique.", "Inane error", 0);
                    }
                } else {
                    Segment existing_seg = is.get_segment(name);
                    if (existing_seg == null || existing_seg == SegDialog.this._seg) {
                        SegDialog.this._seg.set_color(col_int);
                        SegDialog.this._seg.set_name(name);
                        _instance.setVisible(false);
                    } else {
                        JOptionPane.showMessageDialog(MasterControl.get_window(), "Segment name must be unique.", "Inane error", 0);
                    }
                }
            }
        });
        JButton jb_cancel = new JButton("Cancel");
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                _instance.setVisible(false);
            }
        });
        HashMap<String, JComponent> obj_map = new HashMap<String, JComponent>();
        obj_map.put("jtf_name", this._jtf_name);
        obj_map.put("jccb_segcolor", this._jccb_segcolor);
        obj_map.put("jb_ok", jb_ok);
        obj_map.put("jb_cancel", jb_cancel);
        String layout_str1 = new String("<table width='100%' cellpadding='2' border='0'>  <tr>    <td>::jb_ok::</td>    <td>::jb_cancel::</td>  </tr></table>");
        JPanel button_panel = new JPanel();
        JGridMaker.make_grid((Container)button_panel, (String)layout_str1, obj_map);
        obj_map.put("button_panel", button_panel);
        String color_choser_caption = "Segment Color:";
        JGridMaker.make_grid((Container)this, (String)"<table width='100%' cellpadding='2' margin='10' border='0'>  <tr>    <td>Seg Name:</td>    <td>::jtf_name::</td>  </tr><tr>    <td>Segment Color::</td>    <td>::jccb_segcolor::</td>  </tr><tr>    <td colspan='2'>::button_panel::</td>  </tr></table>", obj_map);
        this.pack();
        int pw = win.getWidth();
        int ph = win.getHeight();
        int px = win.getLocation().x;
        int py = win.getLocation().y;
        int w = this.getWidth();
        int h = this.getHeight();
        this.setLocation(px + pw / 2 - w / 2, py + ph / 2 - h / 2);
        _instance = this;
    }
}

