/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.tools.ToolSegGen;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public class SegSelector
extends JPanel
implements YObserverWantsAWTThread,
ListSelectionListener {
    public static String SEG_SELECTION_CHANGED = "__seg__selector__";
    protected final JList _jl_seg_list;
    protected final DefaultListModel _seg_list_model;
    protected final LinkedList<Segment> _selected_segs = new LinkedList();
    protected JLabel _label = null;

    public SegSelector() {
        this._seg_list_model = new DefaultListModel();
        this._jl_seg_list = new JList(this._seg_list_model);
        this._jl_seg_list.setCellRenderer(new MyCellRenderer());
        this._jl_seg_list.setSelectionMode(0);
        this._jl_seg_list.setPrototypeCellValue(new Segment("Fingerknochen", 10, 10, 10));
        this._jl_seg_list.addListSelectionListener(this);
        this.init();
        JScrollPane jsp_list_scroller = new JScrollPane(this._jl_seg_list);
        jsp_list_scroller.setHorizontalScrollBarPolicy(31);
        jsp_list_scroller.setVerticalScrollBarPolicy(22);
        this.setLayout(new BorderLayout());
        this.add((Component)jsp_list_scroller, "Center");
        MasterControl.get_is().addObserver(this, "SegSelector()");
    }

    public SegSelector(String label) {
        this();
        this._label = new JLabel(label, 0);
        this.add((Component)this._label, "North");
    }

    public LinkedList<Segment> get_selected_segments() {
        return this._selected_segs;
    }

    public Segment get_selected_segment() {
        return this._selected_segs.isEmpty() ? null : this._selected_segs.getFirst();
    }

    public void setSelectionMode(int mode) {
        this._jl_seg_list.setSelectionMode(mode);
    }

    public void setSelectedIndex(int index) {
        this._jl_seg_list.setSelectedIndex(index);
        this.check_for_changes();
    }

    public void setSelectedIndex(int[] indices) {
        this._jl_seg_list.setSelectedIndices(indices);
        this.check_for_changes();
    }

    public boolean check_for_changes() {
        boolean change = false;
        int i = 0;
        while (i < this._seg_list_model.getSize()) {
            Segment seg = (Segment)this._seg_list_model.getElementAt(i);
            if (this._jl_seg_list.isSelectedIndex(i)) {
                if (!this._selected_segs.contains(seg)) {
                    this._selected_segs.add(seg);
                    change = true;
                }
            } else if (this._selected_segs.contains(seg)) {
                this._selected_segs.remove(seg);
                change = true;
            }
            ++i;
        }
        return change;
    }

    private void init() {
        ImageStack is = MasterControl.get_is();
        for (Segment seg : is.get_segment_list()) {
            if (seg.get_name() == ToolSegGen.TMP_SEG_NAME) continue;
            this._seg_list_model.addElement(seg);
            seg.addObserver(this, "SegSelector::update new segment");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.check_for_changes()) {
            this.firePropertyChange(SEG_SELECTION_CHANGED, null, null);
        }
    }

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_CLEAR || m._type == ImageStack.M_LOADING_START) {
            this._seg_list_model.clear();
        } else if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            if (seg.get_name() != ToolSegGen.TMP_SEG_NAME) {
                this._seg_list_model.addElement(seg);
                seg.addObserver(this, "SegSelector::update new segment");
            }
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            seg.deleteObserver(this);
            this._selected_segs.remove(seg);
            this._seg_list_model.removeElement(seg);
            this.check_for_changes();
            this.firePropertyChange(SEG_SELECTION_CHANGED, null, null);
        } else if (m._type == Segment.M_SEG_NAME_CHANGED) {
            this.repaint();
        } else if (m._type == Segment.M_SEG_COL_CHANGED) {
            this.repaint();
        }
    }

    final class MyCellRenderer
    extends JPanel
    implements ListCellRenderer {
        final JLabel _jl_text;
        final JPanel _jp_color_box;

        public MyCellRenderer() {
            this.setOpaque(true);
            this._jl_text = new JLabel("---");
            Dimension box_size = new Dimension(12, 12);
            this._jp_color_box = new JPanel();
            this._jp_color_box.setPreferredSize(box_size);
            this._jp_color_box.setMaximumSize(box_size);
            this._jp_color_box.setMinimumSize(box_size);
            this._jp_color_box.setOpaque(true);
            this._jp_color_box.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
            JPanel jp_color_box_parent = new JPanel(new FlowLayout());
            jp_color_box_parent.setOpaque(false);
            jp_color_box_parent.add(this._jp_color_box);
            this.setLayout(new BorderLayout());
            this.add((Component)jp_color_box_parent, "West");
            this.add((Component)this._jl_text, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Segment) {
                Color def_fg;
                Color def_bg;
                Segment seg = (Segment)value;
                this._jl_text.setText(seg.get_name());
                this._jp_color_box.setBackground(new Color(seg.get_color()));
                if (isSelected) {
                    def_bg = list.getSelectionBackground();
                    def_fg = list.getSelectionForeground();
                } else {
                    def_bg = list.getBackground();
                    def_fg = list.getForeground();
                }
                Color bg = new Color(def_bg.getRed(), def_bg.getGreen(), def_bg.getBlue());
                Color fg = new Color(def_fg.getRed(), def_fg.getGreen(), def_fg.getBlue());
                this.setBackground(bg);
                this.setForeground(fg);
            }
            return this;
        }
    }
}

