/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser;

import gui.filechooser.FileTreeChooser;
import gui.filechooser.tools.FileSelectionModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import main.YaDiV;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;
import misc.dicom.DiFileInputStream;

public final class DICOMPreview
extends JPanel
implements PropertyChangeListener {
    private File _file;
    private final JEditorPane _jep_content = new JEditorPane();
    private final FileTreeChooser _chooser;
    private final Thumbnail _thumb_image;

    public DICOMPreview(FileTreeChooser chooser) {
        this._jep_content.setEditable(false);
        this._jep_content.setContentType("text/html");
        this._chooser = chooser;
        this._file = null;
        this._thumb_image = new Thumbnail(200, 200);
        this._chooser.addPropertyChangeListener(this);
        this.update_content();
        this.setLayout(new BorderLayout());
        this.add((Component)this._thumb_image, "North");
        this.add((Component)this._jep_content, "Center");
    }

    private void update_content() {
        String str = "";
        Dimension dim = new Dimension(200, 100);
        this._jep_content.setPreferredSize(dim);
        this._jep_content.setMinimumSize(dim);
        this._jep_content.setMaximumSize(dim);
        if (this._file != null) {
            DiFile df = new DiFile();
            try {
                df.load_from_file(this._file.getPath());
                HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
                DiDataElement de = data_elements.get(524320);
                if (de != null) {
                    String str_name = this._file.getName();
                    String str_study_date = de.get_value_as_string();
                    String str_study_uid = df.get_study_instance_uid();
                    String str_series_uid = df.get_series_instance_uid();
                    String str_dim_x = "" + df.get_image_width();
                    String str_dim_y = "" + df.get_image_height();
                    double[][] iop = df.get_image_orientation_patient();
                    String str_iop0 = "(" + iop[0][0] + ", " + iop[0][1] + ", " + iop[0][2] + ")";
                    String str_iop1 = "(" + iop[1][0] + ", " + iop[1][1] + ", " + iop[1][2] + ")";
                    str = "<html>" + str_name + " (" + str_study_date + ")<br>" + "<font size=2><br>Study UID: " + str_study_uid + "</font><br>" + "<font size=2>Series UID: " + str_series_uid + "</font><br>" + "<br>" + "<font size=2>Size: (" + str_dim_x + ", " + str_dim_y + ")</font><br>" + "<font size=2>IOP0 " + str_iop0 + "</font><br>" + "<font size=2>IOP1 " + str_iop1 + "</font><br>" + "</html>";
                } else {
                    str = "";
                }
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "DICOMPreview::propertyChange: could not open file " + this._file.getName() + " (" + ex + ")");
            }
            if (df != null) {
                this._thumb_image.update_image(df);
            }
        }
        this._jep_content.setText(str);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String prop = pce.getPropertyName();
        if (FileSelectionModel.DIRECTORY_CHANGED_PROPERTY.equals(prop)) {
            this._file = null;
        } else if (FileSelectionModel.SELECTED_FILE_CHANGED_PROPERTY.equals(prop)) {
            File f = (File)pce.getNewValue();
            boolean valid_dicom = false;
            if (!f.isDirectory()) {
                try {
                    DiFileInputStream dfs = new DiFileInputStream(f);
                    valid_dicom = dfs.skip_header();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this._file = valid_dicom ? f : null;
        }
        Dimension dim = new Dimension(this._chooser.getWidth() / 2, this._chooser.getHeight());
        this._jep_content.setPreferredSize(dim);
        this._jep_content.setMinimumSize(dim);
        this._jep_content.setMaximumSize(dim);
        this.update_content();
    }

    public final class Thumbnail
    extends JPanel {
        private BufferedImage _img = new BufferedImage(10, 10, 2);

        public Thumbnail(int dim_x, int dim_y) {
            Dimension dim = new Dimension(dim_x, dim_y);
            this.setMaximumSize(dim);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
        }

        public void update_image(DiFile df) {
            int pixel_padding_value;
            boolean signed;
            HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
            int bytespp = df.get_bits_allocated() / 8;
            int w = df.get_image_width();
            int h = df.get_image_height();
            DiDataElement de = data_elements.get(2145386512);
            byte[] tmp_pixels = de.get_values();
            de = data_elements.get(2621698);
            int high_bit = de.get_value_as_int();
            int shift = high_bit == df.get_bits_stored() - 1 ? 0 : df.get_bits_stored() - 1 - high_bit;
            int stored_mask = (1 << df.get_bits_stored()) - 1;
            int high_mask = 1 << high_bit;
            int slope = df.get_slope();
            int intercept = df.get_intercept();
            int window_width = df.get_window_width();
            int window_min = df.get_window_center() - window_width / 2;
            int window_max = df.get_window_center() + window_width / 2;
            int max_voxel_value = 1 << df.get_bits_stored();
            de = df.get_data_elements().get(2621699);
            if (de != null && de.get_value_as_int() == 1) {
                signed = true;
                window_min += max_voxel_value / 2;
                window_max += max_voxel_value / 2;
            } else {
                signed = false;
            }
            de = data_elements.get(2621728);
            int n = pixel_padding_value = de != null ? de.get_value_as_int() : Integer.MAX_VALUE;
            if (this._img == null || this._img.getWidth() != w || this._img.getHeight() != h) {
                this._img = new BufferedImage(w, h, 2);
            }
            int[] pixels = ((DataBufferInt)this._img.getRaster().getDataBuffer()).getData();
            int pixelcounter = 0;
            int y = 0;
            while (y < h) {
                int byte_pos = y * w * bytespp;
                int x = 0;
                while (x < w) {
                    int value = tmp_pixels[byte_pos] & 0xFF;
                    int i = 1;
                    while (i < bytespp) {
                        value |= (tmp_pixels[byte_pos + i] & 0xFF) << 8 * i;
                        ++i;
                    }
                    value >>= shift;
                    value &= stored_mask;
                    if (signed) {
                        if ((value & high_mask) != 0) {
                            value = (value & ~high_mask) - max_voxel_value / 2 + 1;
                        }
                        value = value == pixel_padding_value ? 0 : (value += max_voxel_value / 2);
                    }
                    if (value == pixel_padding_value) {
                        value = 0;
                    }
                    int grey = value = value * slope + intercept;
                    grey = value < window_min ? 0 : (value > window_max ? 255 : (value - window_min << 8) / window_width);
                    pixels[pixelcounter++] = 0xFF000000 | grey << 16 | grey << 8 | grey;
                    byte_pos += bytespp;
                    ++x;
                }
                ++y;
            }
            this.repaint();
        }

        @Override
        public final void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this._img, 0, 0, this.getWidth(), this.getHeight(), Color.black, null);
        }
    }
}

