/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser;

import gui.filechooser.tools.FileComparator;
import gui.filechooser.tools.FileSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import misc.StopWatch;

public class DirView
extends JPanel {
    private JList _jl_files;
    private JScrollPane _jsb;
    private DefaultListModel _dfm;
    private FileFilter _filter = null;
    private Comparator<File> _comperator = FileComparator.getFileComparator();
    private File _dir;
    private File _last_selected;
    int _last_selected_idx;
    private JProgressBar _jpb_scan_progress;
    private final JDialog _dlg;
    private SortingThread _sorting_thread;

    public DirView(File dir, FileFilter filter) {
        this.setPreferredSize(new Dimension(300, 400));
        this._filter = filter;
        this._dfm = new DefaultListModel();
        this._jl_files = new JList(this._dfm);
        this._jl_files.setCellRenderer(new ComplexCellRenderer());
        this._jl_files.setLayoutOrientation(1);
        this._jl_files.setVisibleRowCount(-1);
        final DirView dv = this;
        this._last_selected = null;
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = DirView.this._jl_files.locationToIndex(e.getPoint());
                Object[] row = (Object[])DirView.this._dfm.getElementAt(index);
                File f = (File)row[2];
                if (e.getClickCount() == 1) {
                    dv.firePropertyChange(FileSelectionModel.SELECTED_FILE_CHANGED_PROPERTY, DirView.this._last_selected, f);
                } else if (e.getClickCount() == 2) {
                    dv.firePropertyChange(FileSelectionModel.FILE_DOUBLE_CLICKED_PROPERTY, DirView.this._last_selected, f);
                }
                DirView.this._last_selected = f;
            }
        };
        ListSelectionListener sel_listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    int index = DirView.this._jl_files.getSelectedIndex();
                    if (index == DirView.this._last_selected_idx) {
                        int[] idxs = DirView.this._jl_files.getSelectedIndices();
                        index = idxs[idxs.length - 1];
                    }
                    if (index > 0) {
                        Object[] row = (Object[])DirView.this._dfm.getElementAt(index);
                        File f = (File)row[2];
                        dv.firePropertyChange(FileSelectionModel.SELECTED_FILE_CHANGED_PROPERTY, DirView.this._last_selected, f);
                        DirView.this._last_selected = f;
                        DirView.this._last_selected_idx = DirView.this._jl_files.getSelectedIndex();
                    }
                }
            }
        };
        this._jl_files.addMouseListener(mouseListener);
        this._jl_files.addListSelectionListener(sel_listener);
        this._jpb_scan_progress = new JProgressBar(0, 100);
        this._dlg = new JDialog(null, "Scanning Directory ...", false);
        this._dlg.add("Center", this._jpb_scan_progress);
        this._dlg.setDefaultCloseOperation(0);
        this.setDirectory(dir);
        this._jsb = new JScrollPane(this._jl_files);
        this.setLayout(new BorderLayout());
        this.add((Component)this._jsb, "Center");
    }

    public DirView(File dir) {
        this(dir, null);
    }

    public void setFileFilter(FileFilter filter) {
        this._filter = filter;
        this.setDirectory(this._dir);
    }

    public void setComparator(Comparator<File> comperator) {
        this._comperator = comperator;
    }

    private void set_progress_max(int max) {
        this._jpb_scan_progress.setMaximum(max);
    }

    private void set_progress_val(int val, StopWatch sw) {
        this._jpb_scan_progress.setValue(val);
        if (sw.get_ms() > 1000L && this.isShowing()) {
            int dirview_w = this.getWidth();
            int dirview_h = this.getHeight();
            this._dlg.setSize(4 * dirview_w / 5, 60);
            Point p = this.getLocationOnScreen();
            this._dlg.setLocation(p.x + dirview_w / 10, p.y + dirview_h / 2 - this._dlg.getHeight());
            this._dlg.setVisible(true);
        }
    }

    public void setDirectory(File dir) {
        if (dir != null) {
            if (this._sorting_thread == null || this._sorting_thread.getState() == Thread.State.TERMINATED) {
                this._sorting_thread = new SortingThread();
                this._sorting_thread._next_sorting_dir = dir;
                this._sorting_thread.start();
            } else {
                this._sorting_thread._next_sorting_dir = dir;
                this._sorting_thread._restart = true;
            }
        }
    }

    public File getDirectory() {
        return this._dir;
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        if (enabled) {
            this._jl_files.setSelectionMode(2);
        } else {
            this._jl_files.setSelectionMode(0);
        }
    }

    public File[] getSelectedFiles() {
        Object[] objs = this._jl_files.getSelectedValues();
        File[] files = new File[objs.length];
        int i = 0;
        while (i < objs.length) {
            Object[] obj = (Object[])objs[i];
            files[i] = (File)obj[2];
            ++i;
        }
        return files;
    }

    private class ComplexCellRenderer
    implements ListCellRenderer,
    MouseListener {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private ComplexCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon = null;
            String theText = null;
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                icon = (Icon)values[0];
                theText = (String)values[1];
            }
            renderer.setText(theText);
            renderer.setIcon(icon);
            return renderer;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }

    private class SortingThread
    extends Thread {
        public boolean _restart = false;
        public File _sorting_dir;
        public File _next_sorting_dir;

        private SortingThread() {
        }

        @Override
        public void run() {
            do {
                this._sorting_dir = this._next_sorting_dir;
                this._restart = false;
                ArrayList<File> accepted_files = new ArrayList<File>();
                StopWatch sw = new StopWatch(true);
                FileSystemView fsv = FileSystemView.getFileSystemView();
                File[] files = this._sorting_dir.listFiles();
                if (files == null) {
                    return;
                }
                DirView.this.set_progress_max(files.length);
                DirView.this.set_progress_val(0, sw);
                DirView.this._dfm.clear();
                int i = 0;
                while (i < files.length && !this._restart) {
                    DirView.this.set_progress_val(i, sw);
                    boolean accepted = DirView.this._filter.accept(files[i]);
                    if (DirView.this._filter == null || accepted) {
                        accepted_files.add(files[i]);
                    }
                    ++i;
                }
                if (this._restart) continue;
                Collections.sort(accepted_files, DirView.this._comperator);
                if (this._restart) continue;
                Iterator fi = accepted_files.iterator();
                while (fi.hasNext() && !this._restart) {
                    Object[] row = new Object[3];
                    File f = (File)fi.next();
                    row[0] = fsv.getSystemIcon(f);
                    row[1] = fsv.getSystemDisplayName(f);
                    row[2] = f;
                    if (this._restart) continue;
                    DirView.this._dfm.addElement(row);
                }
            } while (this._restart);
            DirView.this._dir = this._sorting_dir;
            DirView.this._dlg.setVisible(false);
        }
    }
}

