/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser;

import gui.filechooser.FileTreeRenderer;
import gui.filechooser.tools.DirectoryFilter;
import gui.filechooser.tools.FileComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileTree
extends JPanel
implements TreeWillExpandListener,
TreeSelectionListener {
    protected static final Comparator<File> FILE_COMPARATOR = FileComparator.getFileComparator();
    protected static FileSystemView _fsv = FileSystemView.getFileSystemView();
    protected DirectoryFilter _filter;
    protected DefaultMutableTreeNode _root = new DefaultMutableTreeNode(_fsv.getRoots()[0]);
    protected JTree _tree;
    protected JScrollPane _jsp;

    public FileTree(File path) {
        this._filter = new DirectoryFilter();
        this._filter.allowLinks(false);
        this._filter.allowHidden(false);
        this._filter.allowDirectories(true);
        DefaultTreeModel model = new DefaultTreeModel(this._root);
        this._tree = new JTree(model);
        this._jsp = new JScrollPane(this._tree);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new FileTreeRenderer());
        this.expandNode(this._root);
        this.showPath(path);
        this._tree.addTreeWillExpandListener(this);
        this._tree.addTreeSelectionListener(this);
        this._tree.getSelectionModel().setSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this._jsp, "Center");
        this.setPreferredSize(new Dimension(300, 400));
    }

    public FileTree() {
        this(_fsv.getHomeDirectory());
    }

    public void setPath(File path) {
        this.showPath(path);
    }

    private boolean containsSubdir(File file) {
        if (!_fsv.isFileSystem(file)) {
            return true;
        }
        File[] file_array = file.listFiles();
        int i = 0;
        while (i < file_array.length) {
            if (file_array[i].isDirectory()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void expandNode(DefaultMutableTreeNode d) {
        d.removeAllChildren();
        File[] file_array = ((File)d.getUserObject()).listFiles();
        if (file_array == null) {
            return;
        }
        List<File> file_list = Arrays.asList(file_array);
        Collections.sort(file_list, FILE_COMPARATOR);
        DefaultMutableTreeNode temp = null;
        for (File file : file_list) {
            if (this._filter != null && !this._filter.accept(file)) continue;
            temp = new DefaultMutableTreeNode(file);
            if (file.isDirectory()) {
                temp.add(new DefaultMutableTreeNode(null));
                temp.setAllowsChildren(this.containsSubdir(file));
            }
            d.add(temp);
        }
        ((DefaultTreeModel)this._tree.getModel()).reload(d);
    }

    public void showPath(File path) {
        Stack<File> dirs = new Stack<File>();
        File current_dir = path;
        do {
            dirs.add(current_dir);
        } while ((current_dir = _fsv.getParentDirectory(current_dir)) != null);
        DefaultMutableTreeNode node = this._root;
        dirs.pop();
        block1: while (!dirs.empty()) {
            File f = (File)dirs.pop();
            String sysname = _fsv.getSystemDisplayName(f);
            if (!f.canRead()) {
                DefaultMutableTreeNode dummy_node = new DefaultMutableTreeNode(f);
                DefaultMutableTreeNode temp = new DefaultMutableTreeNode(dirs.peek());
                temp.add(new DefaultMutableTreeNode(null));
                temp.setAllowsChildren(true);
                dummy_node.add(temp);
                dummy_node.setAllowsChildren(true);
                node.add(dummy_node);
                node = dummy_node;
                continue;
            }
            int i = 0;
            while (i < node.getChildCount()) {
                DefaultMutableTreeNode search_node = (DefaultMutableTreeNode)node.getChildAt(i);
                File dir_file = (File)search_node.getUserObject();
                if (_fsv.getSystemDisplayName(dir_file).equals(sysname)) {
                    this.expandNode(search_node);
                    node = search_node;
                    continue block1;
                }
                ++i;
            }
        }
        this.expandNode(node);
        TreePath tp = new TreePath(node.getPath());
        this._tree.expandPath(tp);
        this._tree.setSelectionPath(tp);
        this._tree.scrollPathToVisible(tp);
    }

    public File getSelectedFile() {
        TreePath selectionPath = this._tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        return (File)node.getUserObject();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
        ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).removeAllChildren();
        ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).add(new DefaultMutableTreeNode(null));
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        this.expandNode((DefaultMutableTreeNode)e.getPath().getLastPathComponent());
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
    }

    public JTree getTree() {
        return this._tree;
    }
}

