/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser;

import gui.filechooser.DirView;
import gui.filechooser.FileTree;
import gui.filechooser.tools.FileSelectionModel;
import gui.filechooser.tools.NoDirFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class FileTreeChooser
extends JPanel
implements TreeSelectionListener {
    private FileTree _dir_tree;
    private DirView _dir_view;
    private JComponent _accessory;

    public FileTreeChooser(File path, FileFilter filter) {
        this._dir_tree = path != null ? new FileTree(path) : new FileTree();
        this._dir_tree.getTree().addTreeSelectionListener(this);
        if (filter == null) {
            filter = new NoDirFilter();
        }
        this._dir_view = new DirView(this._dir_tree.getSelectedFile(), filter);
        this._dir_view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File f;
                String property = propertyChangeEvent.getPropertyName();
                if (!FileSelectionModel.SELECTED_FILE_CHANGED_PROPERTY.equals(property) && FileSelectionModel.FILE_DOUBLE_CLICKED_PROPERTY.equals(property) && (f = (File)propertyChangeEvent.getNewValue()).isDirectory()) {
                    FileTreeChooser.this._dir_tree.setPath(f);
                }
                FileTreeChooser.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._dir_tree, "West");
        this.add((Component)this._dir_view, "Center");
    }

    public FileTreeChooser(String path_name) {
        this(new File(path_name), null);
    }

    public FileTreeChooser(String path_name, FileFilter filter) {
        this(new File(path_name), filter);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this._dir_view.setDirectory(this._dir_tree.getSelectedFile());
    }

    public void setFileFilter(FileFilter filter) {
        this._dir_view.setFileFilter(filter);
    }

    public void setAccessory(JComponent accessory) {
        if (accessory == null && this._accessory != null) {
            this.remove(this._accessory);
        }
        this._accessory = accessory;
        if (this._accessory != null) {
            this.add((Component)this._accessory, "East");
        }
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this._dir_view.setMultiSelectionEnabled(enabled);
    }

    public DirView getDirView() {
        return this._dir_view;
    }

    public File[] getSelectedFiles() {
        return this._dir_view.getSelectedFiles();
    }
}

