/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser.tools;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import misc.dicom.DiFileInputStream;

public class DICOMComparator
implements Comparator<File> {
    private static DICOMComparator FC = new DICOMComparator();
    private HashMap<File, HashMap<File, DiFileInputStream.QuickInfo>> _all_dir_cache = new HashMap();

    private DICOMComparator() {
    }

    public static DICOMComparator getFileComparator() {
        return FC;
    }

    private DiFileInputStream.QuickInfo get_quick_info(File f) {
        DiFileInputStream.QuickInfo qi = null;
        HashMap<File, DiFileInputStream.QuickInfo> subdir_map = this._all_dir_cache.get(f.getParentFile());
        if (subdir_map == null) {
            subdir_map = new HashMap();
            this._all_dir_cache.put(f.getParentFile(), subdir_map);
        }
        if (subdir_map.containsKey(f)) {
            qi = subdir_map.get(f);
        } else {
            try {
                DiFileInputStream dfs = new DiFileInputStream(f);
                dfs.skip_header();
                qi = dfs.get_quick_info();
                subdir_map.put(f, qi);
                dfs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return qi;
    }

    @Override
    public int compare(File f1, File f2) {
        DiFileInputStream.QuickInfo q2;
        DiFileInputStream.QuickInfo q1;
        block6: {
            block7: {
                if (f1.isDirectory() ^ f2.isDirectory()) {
                    return f1.isDirectory() ? -1 : 1;
                }
                q1 = this.get_quick_info(f1);
                q2 = this.get_quick_info(f2);
                if (q1 == null || q2 == null) {
                    return 0;
                }
                if (!q1._series_uid.equals(q2._series_uid)) break block6;
                if (q1._image_number >= q2._image_number) break block7;
                return -1;
            }
            try {
                if (q1._image_number == q2._image_number) {
                    return 0;
                }
                return 1;
            }
            catch (NullPointerException ex) {
                System.err.println(f1.getAbsolutePath());
                System.err.println(q1);
                System.err.println(f2.getAbsolutePath());
                System.err.println(q2);
                ex.printStackTrace();
            }
        }
        return q1._series_uid.compareToIgnoreCase(q2._series_uid);
    }
}

