/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser.tools;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class DefaultFilter
extends FileFilter {
    private boolean _show_links = true;
    private boolean _show_hidden = false;
    private boolean _show_dir = false;

    public static boolean isLink(File f) {
        if (f instanceof ShellFolder) {
            ShellFolder sf = (ShellFolder)f;
            return sf.isLink();
        }
        return f.list() == null;
    }

    public static boolean isHidden(File f) {
        return FileSystemView.getFileSystemView().isHiddenFile(f);
    }

    public void allowLinks(boolean allow) {
        this._show_links = allow;
    }

    public boolean linksAllowed() {
        return this._show_links;
    }

    public void allowHidden(boolean allow) {
        this._show_hidden = allow;
    }

    public boolean hiddenAllowed() {
        return this._show_hidden;
    }

    public void allowDirectories(boolean allow) {
        this._show_dir = allow;
    }

    public boolean directoriesAllowed() {
        return this._show_dir;
    }

    @Override
    public boolean accept(File f) {
        return !(!this._show_links && DefaultFilter.isLink(f) || !this._show_hidden && (DefaultFilter.isHidden(f) || !this._show_dir && f.isDirectory()));
    }

    @Override
    public String getDescription() {
        return "normal file";
    }
}

