/*
 * Decompiled with CFR 0.152.
 */
package gui.filechooser.tools;

import gui.filechooser.tools.DefaultFilter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ReadableImageFilter
extends DefaultFilter {
    private static final String _DESCRIPTION = "Readable Images";

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return this.directoriesAllowed();
        }
        boolean readable_image = false;
        if (super.accept(f)) {
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(f);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                readable_image = readers != null && readers.hasNext();
                iis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return readable_image;
    }

    @Override
    public final String getDescription() {
        return _DESCRIPTION;
    }
}

