/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.util.prefs.Preferences;
import loader.DICOMType;
import loader.QuickLoadInfo;
import main.MenuBar;
import misc.helper.Helper;

public class DICOMLoadInfo
extends QuickLoadInfo {
    public static String PREF_FILE_NAME_NUMBER = "FileNameNumber";
    public static String PREF_FILE_NAME = "FileName";
    protected String[] _file_names;

    public DICOMLoadInfo() {
        this._type = new DICOMType();
        this._type_string = "DICOM";
    }

    public DICOMLoadInfo(String base_dir) {
        String[] file_names = null;
        this._type = new DICOMType();
        this.init(file_names);
    }

    public DICOMLoadInfo(String base_dir, String[] file_names, int dim_x, int dim_y, int dim_z) {
        super(base_dir, dim_x, dim_y, dim_z);
        this._type = new DICOMType();
        this.init(file_names);
    }

    private void init(String[] file_names) {
        this._type_string = "DICOM";
        this._file_names = new String[file_names.length];
        int i = 0;
        while (i < file_names.length) {
            this._file_names[i] = new String(file_names[i]);
            ++i;
        }
        this.calc_checksum();
        this._quick_load_str = Helper.truncate_file_name(this._file_names[0], MenuBar.MAX_MENU_FILE_NAME_LENGTH);
        this._quick_load_descr = "<html>Type: " + this._type_string + "<br/>" + "Base Dir: " + this._base_dir + "<br/>" + "Loaded at " + this._date + "<br/>" + "Dim: " + this._dim_x + " x " + this._dim_y + " x " + this._dim_z + "<br/>" + "</html>";
    }

    @Override
    public DICOMLoadInfo clone() {
        return new DICOMLoadInfo();
    }

    @Override
    public void load() {
        int length = this._prefs.getInt(PREF_FILE_NAME_NUMBER, 0);
        this._file_names = new String[length];
        int j = 0;
        while (j < length) {
            this._file_names[j] = this._prefs.get(String.valueOf(PREF_FILE_NAME) + j, "");
            ++j;
        }
    }

    @Override
    public void save(Preferences prefs) {
        super.save(prefs);
        prefs.putInt(PREF_FILE_NAME_NUMBER, this._file_names.length);
        int i = 0;
        while (i < this._file_names.length) {
            prefs.put(String.valueOf(PREF_FILE_NAME) + i, this._file_names[i]);
            ++i;
        }
    }

    private void calc_checksum() {
        long sum = 0L;
        int i = 0;
        while (i < this._file_names.length) {
            int len = this._file_names[i].length();
            sum += (long)this._file_names[i].charAt(len - 1);
            if (len > 2) {
                sum += (long)this._file_names[i].charAt(len - 2);
            }
            if (len > 3) {
                sum += (long)this._file_names[i].charAt(len - 3);
            }
            ++i;
        }
        this._check_sum = (int)(sum % 65521L);
    }
}

