/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import loader.DICOMLoadInfo;
import loader.SpatConverter;
import loader.VolumeDataLoader;
import main.ImageStack;
import main.MasterControl;
import main.YaDiV;
import main.tools.ToolSegGen;
import misc.StopWatch;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;
import misc.dicom.DiFileInputStream;
import misc.grid.MutableRegularGrid3i;
import threads.RSThread;

public class DICOMLoader
extends VolumeDataLoader {
    private double[][] _iop;
    private String[] _file_names;
    private String _candidate;

    public DICOMLoader(ImageStack is, DICOMLoadInfo dli) {
        super(is, dli);
        this._file_names = dli._file_names;
        this._candidate = null;
    }

    public DICOMLoader(ImageStack is, String base_dir, String[] file_names) {
        super(is, base_dir);
        this._file_names = file_names;
    }

    public DICOMLoader(ImageStack is, File[] files) {
        super(is, files[0].getParent());
        String[] file_names = new String[files.length];
        int i = 0;
        while (i < files.length) {
            file_names[i] = files[i].getName();
            ++i;
        }
        this._file_names = file_names;
    }

    public DICOMLoader(ImageStack is, File candidate) {
        super(is, candidate.getParent());
        this._file_names = null;
        this._candidate = candidate.getAbsolutePath();
    }

    @Override
    public void load(RSThread rst) {
        double[] pixel_spacing;
        Vector3d ipp_delta;
        Vector3d ipp1;
        Vector3d ipp0;
        ImageStack.DICOMInfo di_info = this._is.get_dicom_info();
        MutableRegularGrid3i vc = this._is.get_mutable_voxel_cube();
        if (this._file_names == null) {
            String series_uid;
            File selected_file = new File(this._candidate);
            String dir_name = selected_file.getParent();
            DiFile selected_df = new DiFile();
            try {
                selected_df.load_from_file(selected_file.getAbsolutePath());
                DiDataElement de_series_uid = selected_df.get_data_elements().get(0x20000E);
                series_uid = de_series_uid.get_value_as_string();
            }
            catch (Exception ex) {
                this.fatal_loading_error("Could not open selected file " + selected_file.getName(), "could not open selected file " + selected_file.getName() + " (" + ex + ")");
                return;
            }
            File dir = new File(dir_name);
            File[] files_unchecked = dir.listFiles();
            File[] checked_files = this.sort_and_check_dicom_files(files_unchecked, series_uid, rst);
            this._file_names = new String[checked_files.length];
            int i = 0;
            while (i < checked_files.length) {
                this._file_names[i] = checked_files[i].getName();
                ++i;
            }
        } else {
            File base_dir = new File(this._base_dir_name);
            if (!base_dir.exists()) {
                this.fatal_loading_error("The directory does not exist anymore. Aborting", "directory " + this._base_dir_name + " does not exist");
                return;
            }
        }
        if (rst != null) {
            rst.set_label("loading ...");
        }
        if (rst != null) {
            rst.init_progress_measure("loading files ...", 0, this._file_names.length, 0);
        }
        DiFile[] dicom_files = new DiFile[this._file_names.length];
        this._is.set_di_files(dicom_files);
        this._is.set_state(1);
        this._is.send_message(ImageStack.M_LOADING_START, null);
        boolean convert_to_regular_grid = false;
        int dim_x = 0;
        int dim_y = 0;
        int dim_z = 0;
        try {
            boolean regular;
            DiFile df0 = new DiFile();
            DiFile df1 = new DiFile();
            df0.load_from_file(String.valueOf(this._base_dir_name) + File.separatorChar + this._file_names[0]);
            df1.load_from_file(String.valueOf(this._base_dir_name) + File.separatorChar + this._file_names[1]);
            di_info._slope = df0.get_slope() != 0 ? df0.get_slope() : 1;
            di_info._intercept = df0.get_intercept();
            di_info._max_voxel_value = 1 << df0.get_bits_stored();
            DiDataElement de = df0.get_data_elements().get(2633728);
            if (de != null) {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Warning LUT (0028,3000) not supported yet");
            }
            di_info._sop_media_class = (de = df0.get_data_elements().get(131074)) != null ? de.get_value_as_string() : "(not given)";
            di_info._pixel_representation_signed = false;
            de = df0.get_data_elements().get(2621699);
            if (de != null && de.get_value_as_int() == 1) {
                di_info._pixel_representation_signed = true;
            }
            this._iop = df0.get_image_orientation_patient();
            double REGULARITY_EPSILON = 5.555555555555556E-4;
            ipp0 = new Vector3d(df0.get_image_pos_patient());
            ipp1 = new Vector3d(df1.get_image_pos_patient());
            ipp_delta = new Vector3d(ipp1);
            ipp_delta.sub((Tuple3d)ipp0);
            Vector3d iop0 = new Vector3d(this._iop[0][0], this._iop[0][1], this._iop[0][2]);
            Vector3d iop1 = new Vector3d(this._iop[1][0], this._iop[1][1], this._iop[1][2]);
            Vector3d iop2 = new Vector3d(ipp_delta);
            iop2.normalize();
            di_info._iop0.set(this._iop[0][0], this._iop[0][1], this._iop[0][2]);
            di_info._iop1.set(this._iop[1][0], this._iop[1][1], this._iop[1][2]);
            di_info._iop2.set((Tuple3d)iop2);
            double angle_iop0_iop1 = iop0.dot(iop1);
            double angle_iop0_iop_iop2 = iop0.dot(iop2);
            double angle_iop1_iop_iop2 = iop1.dot(iop2);
            if (Math.abs(angle_iop0_iop1) > REGULARITY_EPSILON) {
                this.fatal_loading_error("Error: Support of non-regular slice images not supported (yet)!", "angle_iop0_iop1 = " + angle_iop0_iop1);
                return;
            }
            boolean bl = regular = Math.abs(angle_iop0_iop_iop2) < REGULARITY_EPSILON && Math.abs(angle_iop1_iop_iop2) < REGULARITY_EPSILON;
            if (!regular) {
                Object[] options = new Object[]{"Yes", "No"};
                int answer = JOptionPane.showOptionDialog(MasterControl.get_window(), "The selected DICOM series is not regular. Should it be converted??", "Convert to Regular", 0, 3, null, options, options[1]);
                convert_to_regular_grid = answer == 0;
            }
            di_info._is_regular = regular | convert_to_regular_grid;
            if (convert_to_regular_grid) {
                di_info._iop_map[0] = 0;
                dim_x = df0.get_image_width();
                di_info._iop_inc[0] = 1;
                di_info._iop_start[0] = 0;
                di_info._iop_map[1] = 1;
                dim_y = df0.get_image_height();
                di_info._iop_inc[1] = 1;
                di_info._iop_start[1] = 0;
                di_info._iop_map[2] = 2;
                dim_z = this._file_names.length;
                di_info._iop_inc[2] = 1;
                di_info._iop_start[2] = 0;
            } else {
                int[] dim = new int[3];
                this.old_iop_init(di_info, df0, this._file_names.length, dim);
                dim_x = dim[0];
                dim_y = dim[1];
                dim_z = dim[2];
            }
            vc = ImageStack.create_voxel_cube_instance(dim_x, dim_y, dim_z);
            this._is.set_grid(vc);
            pixel_spacing = df0.get_pixel_spacing();
            di_info._pixel_spacing[di_info._iop_map[0]] = pixel_spacing[0];
            di_info._pixel_spacing[di_info._iop_map[1]] = pixel_spacing[1];
            di_info._pixel_spacing[di_info._iop_map[2]] = ipp_delta.length();
            this._is.send_message(ImageStack.M_VC_SPACING_CHANGED, null);
        }
        catch (Exception ex) {
            this.fatal_loading_error("Error: Could not load one of the first two files!", "Loading error: " + ex);
            return;
        }
        int i = 0;
        while (i < this._file_names.length) {
            String file_name = String.valueOf(this._base_dir_name) + File.separatorChar + this._file_names[i];
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "loading " + file_name);
            DiFile df = new DiFile();
            try {
                df.load_from_file(file_name);
            }
            catch (Exception ex) {
                this.fatal_loading_error("Error: Failed to open" + file_name, "load sorted files: failed to open " + file_name + "\n" + ex);
                return;
            }
            double[] df_pixel_spacing = df.get_pixel_spacing();
            if (df_pixel_spacing[0] != pixel_spacing[0] || df_pixel_spacing[1] != pixel_spacing[1]) {
                this.fatal_loading_error("Error: Pixel Spacing changed in series.", "Error: Pixel Spacing changed in " + file_name);
                return;
            }
            if (i == 0) {
                ipp1 = new Vector3d(df.get_image_pos_patient());
            } else {
                ipp0 = ipp1;
                ipp1 = new Vector3d(df.get_image_pos_patient());
                Vector3d tmp = new Vector3d(ipp1);
                tmp.sub((Tuple3d)ipp0);
                if (!ipp_delta.epsilonEquals((Tuple3d)tmp, 0.05)) {
                    System.out.println("Error: IPP Delta (\"spacing between slice images\") changed in " + file_name + ": " + ipp_delta + " vs. " + tmp);
                }
            }
            dicom_files[i] = df;
            this.convert_pixels(df, i, di_info, vc);
            di_info._w_width = (di_info._w_width * i + df.get_window_width()) / (i + 1);
            di_info._w_center = di_info._pixel_representation_signed ? (di_info._w_center * i + df.get_window_center() + di_info._max_voxel_value / 2) / (i + 1) : (di_info._w_center * i + df.get_window_center()) / (i + 1);
            if (i == 0) {
                this._is.send_message(ImageStack.M_LOADING_FIRST_IMAGE, null);
            }
            if (rst != null) {
                rst.set_progress_val(i + 1);
            }
            this._is.send_message(ImageStack.M_LOADING_NEW_IMAGE, null);
            ++i;
        }
        this._is.set_state(2);
        DICOMLoadInfo new_dli = new DICOMLoadInfo(this._base_dir_name, this._file_names, dim_x, dim_y, dim_z);
        this._is.send_message(ImageStack.M_LOADING_END, new_dli);
        System.gc();
        System.gc();
        System.gc();
        if (convert_to_regular_grid) {
            this.convert_to_regular_grid(vc, dicom_files, rst);
        }
        System.gc();
        System.gc();
        System.gc();
    }

    private void convert_to_regular_grid(MutableRegularGrid3i vc_nonreg, DiFile[] di_files, RSThread rst) {
        this._is.set_state(3);
        this._is.send_message(ImageStack.M_RESIZE_START, null);
        ImageStack.DICOMInfo di_info = this._is.get_dicom_info();
        SpatConverter cell = new SpatConverter(vc_nonreg, di_files, this._is.get_dicom_info());
        Vector3d dim = cell.get_dim();
        int[] reg_dim = new int[]{(int)dim.x, (int)dim.y, (int)dim.z};
        MutableRegularGrid3i vc_reg = ImageStack.create_voxel_cube_instance(reg_dim[0], reg_dim[1], reg_dim[2]);
        this._is.set_grid(vc_reg);
        di_info._pixel_spacing[0] = cell.get_reg_spacing(0);
        di_info._pixel_spacing[1] = cell.get_reg_spacing(1);
        di_info._pixel_spacing[2] = cell.get_reg_spacing(2);
        this._is.send_message(ImageStack.M_VC_SPACING_CHANGED, null);
        StopWatch sw = new StopWatch(true);
        if (rst != null) {
            rst.init_progress_measure("converting to regular grid ...", 0, reg_dim[2], 0);
        }
        NumberFormat _spacing_formatter = NumberFormat.getNumberInstance();
        _spacing_formatter.setMinimumFractionDigits(3);
        _spacing_formatter.setMaximumFractionDigits(3);
        int z = 0;
        while (z < reg_dim[2]) {
            int y = 0;
            while (y < reg_dim[1]) {
                int x = 0;
                while (x < reg_dim[0]) {
                    int value = cell.interpolate(x, y, z);
                    vc_reg.set(x, y, z, value);
                    ++x;
                }
                ++y;
            }
            MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME).new_data(true);
            if (rst != null) {
                rst.inc_progress_value(1);
            }
            this._is.send_message(ImageStack.M_RESIZE_STEP, null);
            ++z;
        }
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Conversion Time: " + sw);
        this._is.set_state(2);
        this._is.send_message(ImageStack.M_RESIZE_END, null);
    }

    private final void convert_pixels(DiFile df, int idx, ImageStack.DICOMInfo di_info, MutableRegularGrid3i vc) {
        HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
        int bytespp = df.get_bits_allocated() / 8;
        int w = df.get_image_width();
        int h = df.get_image_height();
        int[] pos = new int[3];
        boolean little_endian = true;
        DiDataElement de = data_elements.get(2145386512);
        byte[] tmp_pixels = de.get_values();
        de = data_elements.get(2621698);
        int high_bit = de.get_value_as_int();
        int shift = high_bit == df.get_bits_stored() - 1 ? 0 : df.get_bits_stored() - 1 - high_bit;
        int stored_mask = (1 << df.get_bits_stored()) - 1;
        int high_mask = 1 << high_bit;
        if (de.get_vr() == 20311 && df.get_endianess() == DiFile.ENDIAN_BIG) {
            little_endian = false;
        }
        int pixel_padding_value = (de = data_elements.get(2621728)) != null ? de.get_value_as_int() : Integer.MAX_VALUE;
        pos[di_info._iop_map[2]] = di_info._iop_start[2] + idx * di_info._iop_inc[2];
        int y = 0;
        while (y < h) {
            int byte_pos = y * w * bytespp;
            pos[di_info._iop_map[1]] = di_info._iop_start[1] + y * di_info._iop_inc[1];
            int x = 0;
            while (x < w) {
                int i;
                int intensity = 0;
                if (little_endian) {
                    i = 0;
                    while (i < bytespp) {
                        intensity |= (tmp_pixels[byte_pos + i] & 0xFF) << 8 * i;
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < bytespp) {
                        intensity |= (tmp_pixels[byte_pos + i] & 0xFF) << 8 * (bytespp - i - 1);
                        ++i;
                    }
                }
                intensity >>= shift;
                intensity &= stored_mask;
                if (di_info._pixel_representation_signed) {
                    if ((intensity & high_mask) != 0) {
                        intensity = (intensity & ~high_mask) - di_info._max_voxel_value / 2 + 1;
                    }
                    intensity = intensity == pixel_padding_value ? 0 : (intensity += di_info._max_voxel_value / 2);
                }
                if (intensity == pixel_padding_value) {
                    intensity = 0;
                }
                pos[di_info._iop_map[0]] = di_info._iop_start[0] + x * di_info._iop_inc[0];
                vc.set(pos[0], pos[1], pos[2], intensity);
                byte_pos += bytespp;
                ++x;
            }
            ++y;
        }
        data_elements.remove(2145386512);
    }

    private File[] sort_and_check_dicom_files(File[] files, String series_uid, RSThread rst) {
        if (rst != null) {
            rst.init_progress_measure("checking files ...", 0, files.length, 0);
        }
        Hashtable<Integer, String> file_map = new Hashtable<Integer, String>();
        int i = 0;
        while (i < files.length) {
            int num = this.check_dicom_file(files[i], series_uid);
            if (num >= 0) {
                file_map.put(new Integer(num), files[i].getAbsolutePath());
            }
            if (rst != null) {
                rst.set_progress_val(i + 1);
            }
            ++i;
        }
        Enumeration e = file_map.keys();
        ArrayList<Integer> key_list = new ArrayList<Integer>();
        while (e.hasMoreElements()) {
            key_list.add((Integer)e.nextElement());
        }
        Collections.sort(key_list);
        File[] checked_files = new File[key_list.size()];
        int i2 = 0;
        while (i2 < key_list.size()) {
            checked_files[i2] = new File((String)file_map.get(key_list.get(i2)));
            ++i2;
        }
        return checked_files;
    }

    private int check_dicom_file(File file, String series_uid) {
        int result = -1;
        if (!file.isDirectory()) {
            try {
                DiFileInputStream candidate = new DiFileInputStream(file);
                if (candidate.skip_header()) {
                    result = candidate.quick_check(series_uid);
                }
                candidate.close();
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "ImageStack::init_from_dir: could not open file " + file.getName() + " (" + ex + ")");
                result = -1;
            }
        }
        return result;
    }

    private void old_iop_init(ImageStack.DICOMInfo di_info, DiFile df, int number_of_images, int[] dim_array) {
        double HACK = 0.3;
        if (Math.abs(this._iop[0][0]) > 0.3) {
            di_info._iop_map[0] = 0;
            dim_array[0] = df.get_image_width();
        } else if (Math.abs(this._iop[0][1]) > 0.3) {
            di_info._iop_map[0] = 1;
            dim_array[1] = df.get_image_width();
        } else {
            di_info._iop_map[0] = 2;
            dim_array[2] = df.get_image_width();
        }
        if (this._iop[0][di_info._iop_map[0]] > 0.0) {
            di_info._iop_inc[0] = 1;
            di_info._iop_start[0] = 0;
        } else {
            di_info._iop_inc[0] = -1;
            di_info._iop_start[0] = df.get_image_width() - 1;
        }
        if (Math.abs(this._iop[1][0]) > 0.3) {
            di_info._iop_map[1] = 0;
            dim_array[0] = df.get_image_height();
        } else if (Math.abs(this._iop[1][1]) > 0.3) {
            di_info._iop_map[1] = 1;
            dim_array[1] = df.get_image_height();
        } else {
            di_info._iop_map[1] = 2;
            dim_array[2] = df.get_image_height();
        }
        if (this._iop[1][di_info._iop_map[1]] > 0.0) {
            di_info._iop_inc[1] = 1;
            di_info._iop_start[1] = 0;
        } else {
            di_info._iop_inc[1] = -1;
            di_info._iop_start[1] = df.get_image_height() - 1;
        }
        double[] da = new double[3];
        double[] db = new double[3];
        double[] dc = new double[3];
        da[di_info._iop_map[0]] = di_info._iop_inc[0];
        db[di_info._iop_map[1]] = di_info._iop_inc[1];
        Vector3d a = new Vector3d(da);
        Vector3d b = new Vector3d(db);
        Vector3d c = new Vector3d();
        c.cross(a, b);
        c.get(dc);
        if (c.x != 0.0) {
            di_info._iop_map[2] = 0;
            dim_array[0] = number_of_images;
        } else if (c.y != 0.0) {
            di_info._iop_map[2] = 1;
            dim_array[1] = number_of_images;
        } else {
            di_info._iop_map[2] = 2;
            dim_array[2] = number_of_images;
        }
        if (dc[di_info._iop_map[2]] > 0.0) {
            di_info._iop_inc[2] = 1;
            di_info._iop_start[2] = 0;
        } else {
            di_info._iop_inc[2] = -1;
            di_info._iop_start[2] = number_of_images - 1;
        }
        DiDataElement de = df.get_data_elements().get(1593600);
        String patient_pos = de != null ? de.get_value_as_string() : "HFS";
        if (patient_pos.startsWith("HFS") || patient_pos.startsWith("HFP")) {
            if (di_info._iop_map[0] == 2) {
                di_info._iop_start[0] = dim_array[2] - 1 - di_info._iop_start[0];
                di_info._iop_inc[0] = -1 * di_info._iop_inc[0];
            } else if (di_info._iop_map[1] == 2) {
                di_info._iop_start[1] = dim_array[2] - 1 - di_info._iop_start[1];
                di_info._iop_inc[1] = -1 * di_info._iop_inc[1];
            } else {
                di_info._iop_start[2] = dim_array[2] - 1 - di_info._iop_start[2];
                di_info._iop_inc[2] = -1 * di_info._iop_inc[2];
            }
        }
        if (patient_pos.startsWith("HFP") || patient_pos.startsWith("FFP")) {
            if (di_info._iop_map[0] == 1) {
                di_info._iop_start[0] = dim_array[1] - 1 - di_info._iop_start[0];
                di_info._iop_inc[0] = -1 * di_info._iop_inc[0];
            } else if (di_info._iop_map[1] == 1) {
                di_info._iop_start[1] = dim_array[1] - 1 - di_info._iop_start[1];
                di_info._iop_inc[1] = -1 * di_info._iop_inc[1];
            } else {
                di_info._iop_start[2] = dim_array[1] - 1 - di_info._iop_start[2];
                di_info._iop_inc[2] = -1 * di_info._iop_inc[2];
            }
        }
    }

    public class PreviewPanel
    extends JPanel {
        public BufferedImage _all_img;

        public PreviewPanel(int dim_x, int dim_y) {
            Dimension dim = new Dimension(dim_x, dim_y);
            this.setPreferredSize(dim);
            this._all_img = new BufferedImage(dim_x, dim_y, 2);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.clearRect(0, 0, this._all_img.getWidth(), this._all_img.getHeight());
            g2.drawImage((Image)this._all_img, 0, 0, null);
        }
    }
}

