/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.util.prefs.Preferences;
import loader.ImagesType;
import loader.QuickLoadInfo;
import main.MenuBar;
import misc.helper.Helper;

public class ImagesLoadInfo
extends QuickLoadInfo {
    public static String PREF_FILE_NAME_NUMBER = "FileNameNumber";
    public static String PREF_FILE_NAME = "FileName";
    public static String PREF_SPACING_X = "SpaxingX";
    public static String PREF_SPACING_Y = "SpaxingY";
    public static String PREF_SPACING_Z = "SpaxingZ";
    public static String PREF_CROP = "Crop";
    public static String PREF_CROP_BORDER = "CropBorder";
    protected String[] _file_names;
    protected double[] _spacing = new double[3];
    protected boolean _crop;
    protected int _crop_border;

    public ImagesLoadInfo() {
        this._type_string = "IMAGES";
        this._type = new ImagesType();
    }

    public ImagesLoadInfo(String base_dir, String[] file_names, int dim_x, int dim_y, double sp_x, double sp_y, double sp_z, boolean crop, int crop_border) {
        super(base_dir, dim_x, dim_y, file_names.length);
        this._type_string = "IMAGES";
        this._file_names = new String[file_names.length];
        this._spacing[0] = sp_x;
        this._spacing[1] = sp_y;
        this._spacing[2] = sp_z;
        this._crop = crop;
        this._crop_border = crop_border;
        int i = 0;
        while (i < file_names.length) {
            this._file_names[i] = new String(file_names[i]);
            ++i;
        }
        this.calc_checksum();
        this._quick_load_str = Helper.truncate_file_name(this._file_names[0], MenuBar.MAX_MENU_FILE_NAME_LENGTH);
        this._quick_load_descr = "<html>Type: " + this._type_string + "<br/>" + "Base Dir: " + this._base_dir + "<br/>" + "Loaded at " + this._date + "<br/>" + "Dim: " + this._dim_x + " x " + this._dim_y + " x " + this._dim_z + "<br/>" + "</html>";
        this._type = new ImagesType();
    }

    private void calc_checksum() {
        long sum = 0L;
        int i = 0;
        while (i < this._file_names.length) {
            int len = this._file_names[i].length();
            sum += (long)this._file_names[i].charAt(len - 1);
            if (len > 2) {
                sum += (long)this._file_names[i].charAt(len - 2);
            }
            if (len > 3) {
                sum += (long)this._file_names[i].charAt(len - 3);
            }
            ++i;
        }
        if (this._crop) {
            sum += 47L;
        }
        this._check_sum = (int)((sum += (long)this._crop_border) % 65521L);
    }

    @Override
    public QuickLoadInfo clone() {
        return new ImagesLoadInfo();
    }

    @Override
    public void load() {
        int length = this._prefs.getInt(PREF_FILE_NAME_NUMBER, 0);
        this._file_names = new String[length];
        int j = 0;
        while (j < length) {
            this._file_names[j] = this._prefs.get(String.valueOf(PREF_FILE_NAME) + j, "");
            ++j;
        }
        this._spacing[0] = this._prefs.getDouble(PREF_SPACING_X, 1.0);
        this._spacing[1] = this._prefs.getDouble(PREF_SPACING_Y, 1.0);
        this._spacing[2] = this._prefs.getDouble(PREF_SPACING_Z, 1.0);
        this._crop = this._prefs.getBoolean(PREF_CROP, false);
        this._crop_border = this._prefs.getInt(PREF_CROP_BORDER, 0);
    }

    @Override
    public void save(Preferences prefs) {
        super.save(prefs);
        prefs.putInt(PREF_FILE_NAME_NUMBER, this._file_names.length);
        int i = 0;
        while (i < this._file_names.length) {
            prefs.put(String.valueOf(PREF_FILE_NAME) + i, this._file_names[i]);
            ++i;
        }
        prefs.putDouble(PREF_SPACING_X, this._spacing[0]);
        prefs.putDouble(PREF_SPACING_Y, this._spacing[1]);
        prefs.putDouble(PREF_SPACING_Z, this._spacing[2]);
        prefs.putBoolean(PREF_CROP, this._crop);
        prefs.putInt(PREF_CROP_BORDER, this._crop_border);
    }
}

