/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import loader.ImagesLoadInfo;
import loader.VolumeDataLoader;
import main.ImageStack;
import main.YaDiV;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;
import misc.grid.MutableRegularGrid3i;
import threads.RSThread;

public class ImagesLoader
extends VolumeDataLoader {
    private String[] _file_names;
    private double[] _spacing = new double[3];
    private boolean _crop;
    private int _crop_border;

    public ImagesLoader(ImageStack is, ImagesLoadInfo ili) {
        super(is, ili);
        this._file_names = ili._file_names;
        this._spacing = ili._spacing;
        this._crop = ili._crop;
        this._crop_border = ili._crop_border;
    }

    public ImagesLoader(ImageStack is, String based_dir, String[] file_names, double[] spacing, boolean crop, int crop_border) {
        super(is, based_dir);
        this._file_names = file_names;
        this._spacing = spacing;
        this._crop = crop;
        this._crop_border = crop_border;
    }

    public ImagesLoader(ImageStack is, File[] files, double[] spacing, boolean crop, int crop_border) {
        super(is, files[0].getParent());
        String[] file_names = new String[files.length];
        int i = 0;
        while (i < files.length) {
            file_names[i] = files[i].getName();
            ++i;
        }
        this._file_names = file_names;
        this._spacing = spacing;
        this._crop = crop;
        this._crop_border = crop_border;
    }

    @Override
    public void load(RSThread rst) {
        ImageReader reader;
        ImageInputStream iis;
        int selected_h;
        int selected_w;
        ImageStack.DICOMInfo di_info = this._is.get_dicom_info();
        MutableRegularGrid3i vc = this._is.get_mutable_voxel_cube();
        String first_file_name = String.valueOf(this._base_dir_name) + File.separator + this._file_names[0];
        File first_file = new File(first_file_name);
        try {
            ImageInputStream iis2 = ImageIO.createImageInputStream(first_file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis2);
            if (!readers.hasNext()) {
                this.fatal_loading_error("Import failed to intrepret initial picture (wrong format)", "Import failed to intrepret initial picture (wrong format)");
                return;
            }
            ImageReader reader2 = readers.next();
            reader2.setInput(iis2, true);
            BufferedImage img = reader2.read(0);
            if (img == null) {
                this.fatal_loading_error("Import failed to intrepret initial picture (wrong format)", "Import failed to intrepret initial picture (wrong format)");
                return;
            }
            selected_w = img.getWidth();
            selected_h = img.getHeight();
        }
        catch (IOException ex) {
            this.fatal_loading_error("Import failed to load initial picture (file could not be read)", "failed to open initial pic" + ex.getMessage());
            return;
        }
        Arrays.sort(this._file_names);
        DiFile[] dicom_files = new DiFile[this._file_names.length];
        this._is.set_state(1);
        this._is.send_message(ImageStack.M_LOADING_START, null);
        this._is.set_di_files(dicom_files);
        di_info._slope = 1;
        di_info._intercept = 0;
        if (rst != null) {
            rst.init_progress_measure("importing images ...", 0, this._file_names.length, 0);
        }
        int voxel_counter = 0;
        try {
            iis = ImageIO.createImageInputStream(first_file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            reader = readers.next();
        }
        catch (IOException ex) {
            this.fatal_loading_error("ImageStackIO::import_images failed to load picture", "import_images failed to load picture " + ex.getMessage());
            return;
        }
        int i = 0;
        while (i < this._file_names.length) {
            block23: {
                String file_name = this._file_names[i];
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "importing " + file_name);
                DiFile df = new DiFile(DiFile.ENDIAN_LITTLE, DiFile.VR_EXPLICIT);
                HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
                DiDataElement de = new DiDataElement(32, 13, 21833, new String("100").getBytes());
                data_elements.put(de.get_tag(), de);
                de = new DiDataElement(32, 14, 21833, new String("101").getBytes());
                data_elements.put(de.get_tag(), de);
                dicom_files[i] = df;
                try {
                    File file = new File(String.valueOf(this._base_dir_name) + File.separator + file_name);
                    iis = ImageIO.createImageInputStream(file);
                    reader.setInput(iis, true);
                    BufferedImage img = reader.read(0);
                    if (img == null) {
                        YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "failed to open!");
                        break block23;
                    }
                    int w = img.getWidth();
                    int h = img.getHeight();
                    if (w != selected_w || h != selected_h) {
                        YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "wrong resolution - aborting!");
                        break block23;
                    }
                    if (i == 0) {
                        di_info._max_voxel_value = 256;
                        di_info._w_width = 256;
                        di_info._w_center = 128;
                        vc = ImageStack.create_voxel_cube_instance(w, h, this._file_names.length);
                        this._is.set_grid(vc);
                        di_info._pixel_spacing[0] = this._spacing[0];
                        di_info._pixel_spacing[1] = this._spacing[1];
                        di_info._pixel_spacing[2] = this._spacing[2];
                        this._is.send_message(ImageStack.M_VC_SPACING_CHANGED, null);
                    }
                    int[] pixels = new int[w * h];
                    if (this._crop) {
                        int half_h = h / 2;
                        int dist_sqr = (h - 2 * this._crop_border) / 2 * ((h - 2 * this._crop_border) / 2);
                        int y = 0;
                        int idx = 0;
                        while (y < h) {
                            int dist_y_sqr = (half_h - y) * (half_h - y);
                            int x = 0;
                            while (x < w) {
                                if (dist_y_sqr + (half_h - x) * (half_h - x) < dist_sqr) {
                                    pixels[idx] = img.getRGB(x, y) & 0xFF;
                                    vc.set(voxel_counter++, pixels[idx++]);
                                } else {
                                    pixels[idx] = 0;
                                    vc.set(voxel_counter++, pixels[idx++]);
                                }
                                ++x;
                            }
                            ++y;
                        }
                    } else {
                        int y = 0;
                        int idx = 0;
                        while (y < h) {
                            int x = 0;
                            while (x < w) {
                                pixels[idx] = img.getRGB(x, y) & 0xFF;
                                vc.set(voxel_counter++, pixels[idx++]);
                                ++x;
                            }
                            ++y;
                        }
                    }
                }
                catch (IOException ex) {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "ImageStack::import " + ex.getMessage());
                }
                if (i == 0) {
                    this._is.send_message(ImageStack.M_LOADING_FIRST_IMAGE, null);
                }
                if (rst != null) {
                    rst.set_progress_val(i + 1);
                }
                this._is.send_message(ImageStack.M_LOADING_NEW_IMAGE, null);
            }
            ++i;
        }
        this._is.set_state(2);
        System.gc();
        System.gc();
        System.gc();
        this._is.send_message(ImageStack.M_LOADING_END, new ImagesLoadInfo(this._base_dir_name, this._file_names, selected_w, selected_h, this._spacing[0], this._spacing[1], this._spacing[2], this._crop, this._crop_border));
    }
}

