/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JEditorPane;
import javax.swing.JPanel;

public final class ImportImageAccessor
extends JPanel
implements PropertyChangeListener {
    private static final int IMG_SIZE = 150;
    private final JEditorPane _jep_content;
    private final Thumbnail _thumb_image;
    private BufferedImage DEF_IMAGE = new BufferedImage(100, 100, 4);

    public ImportImageAccessor() {
        this.setPreferredSize(new Dimension(150, 250));
        this._jep_content = new JEditorPane();
        this._jep_content.setEditable(false);
        this._jep_content.setContentType("text/html");
        this.update_image_info(null);
        this._thumb_image = new Thumbnail(150, 150);
        this.setLayout(new BorderLayout());
        this.add((Component)this._thumb_image, "North");
        this.add((Component)this._jep_content, "Center");
    }

    public void update_image_info(ImageInfo info) {
        String str = info != null ? "<html><font size=3>" + info._filename + "<br/>" + "Dimension: " + info._width + " x " + info._height + "<br/>" + "Type: " + info._type + "<br/>" + "</font>" + "</html>" : "<html><font size=2></font></html>";
        this._jep_content.setText(str);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            String name;
            File selection = (File)e.getNewValue();
            BufferedImage img = this.DEF_IMAGE;
            BufferedImage orig_img = null;
            ImageInfo info = null;
            if (selection != null && (name = selection.getAbsolutePath()) != null) {
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(selection);
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
                    if (readers != null && readers.hasNext()) {
                        ImageReader reader = readers.next();
                        reader.setInput(iis, true);
                        info = new ImageInfo();
                        info._filename = new String(selection.getName());
                        info._width = reader.getWidth(0);
                        info._height = reader.getHeight(0);
                        info._type = reader.getFormatName();
                        orig_img = reader.read(0);
                        img = new BufferedImage(150, 150, 1);
                        img.getGraphics().drawImage(orig_img, 0, 0, 150, 150, null);
                    }
                    iis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._thumb_image.set_image(img);
            this.update_image_info(info);
            this.repaint();
        }
    }

    private final class ImageInfo {
        public int _width;
        public int _height;
        public String _filename;
        public String _type;

        private ImageInfo() {
        }
    }

    public final class Thumbnail
    extends JPanel {
        private BufferedImage _img = new BufferedImage(10, 10, 2);
        private int _img_w;
        private int _img_h;

        public Thumbnail(int dim_x, int dim_y) {
            Dimension dim = new Dimension(dim_x, dim_y);
            this.setMaximumSize(dim);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
        }

        public void set_image(Image img) {
            int panel_h;
            int img_w = img.getWidth(this);
            int img_h = img.getHeight(this);
            int panel_w = this.getWidth();
            if (img_w / panel_w <= img_h / (panel_h = this.getHeight())) {
                double ratio = (double)img_w / (double)panel_w;
                this._img_w = panel_w;
                this._img_h = (int)((double)panel_w * ratio);
            } else {
                double ratio = (double)img_h / (double)panel_h;
                this._img_h = panel_h;
                this._img_w = (int)((double)panel_h * ratio);
            }
            this._img = new BufferedImage(this._img_w, this._img_h, 2);
            this._img.getGraphics().drawImage(img, 0, 0, this._img_w, this._img_h, this);
        }

        @Override
        public final void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawImage(this._img, 0, 0, this.getWidth(), this.getHeight(), Color.black, null);
        }
    }
}

