/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.filechooser.DICOMPreview;
import gui.filechooser.FileTreeChooser;
import gui.filechooser.tools.DICOMComparator;
import gui.filechooser.tools.FileSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import jgridmaker.GMPanel;
import loader.DICOMLoader;
import loader.OpenDialog;
import main.Global;
import main.MasterControl;
import misc.dicom.DicomFileFilter;
import threads.RSThread;

public class OpenDICOMDialog
extends OpenDialog {
    private final FileTreeChooser _chooser;
    private final JButton _jb_load;
    private static String DEF_TITLE = "Open DICOM Files";

    public OpenDICOMDialog(String dir_str) {
        super(DEF_TITLE);
        this.setIconImage(Global.ICON_IMAGE);
        this.setDefaultCloseOperation(2);
        final OpenDICOMDialog diag = this;
        GMPanel gmp = new GMPanel();
        this._chooser = new FileTreeChooser(dir_str, (FileFilter)new DicomFileFilter());
        this._chooser.setAccessory(new DICOMPreview(this._chooser));
        this._chooser.getDirView().setComparator(DICOMComparator.getFileComparator());
        this._chooser.setMultiSelectionEnabled(true);
        this._chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String evt_name = evt.getPropertyName();
                if (!evt_name.equals(FileSelectionModel.DIRECTORY_CHANGED_PROPERTY)) {
                    if (evt_name.equals(FileSelectionModel.SELECTED_FILE_CHANGED_PROPERTY)) {
                        OpenDICOMDialog.this.setTitle(String.valueOf(DEF_TITLE) + " (" + OpenDICOMDialog.this._chooser.getSelectedFiles().length + " files selected)");
                        OpenDICOMDialog.this._jb_load.setEnabled(OpenDICOMDialog.this._chooser.getSelectedFiles().length != 0);
                    } else if (evt_name.equals(FileSelectionModel.FILE_DOUBLE_CLICKED_PROPERTY)) {
                        diag.setVisible(false);
                        File[] files = OpenDICOMDialog.this._chooser.getSelectedFiles();
                        OpenDICOMDialog.this.load(files);
                    }
                }
            }
        });
        this._jb_load = new JButton("Load DICOM Images");
        this._jb_load.setToolTipText("Select several images or a single image to load all files of the series (in this directory)");
        this._jb_load.setEnabled(false);
        this._jb_load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.setVisible(false);
                File[] files = OpenDICOMDialog.this._chooser.getSelectedFiles();
                OpenDICOMDialog.this.load(files);
            }
        });
        gmp.add("_chooser", (JComponent)this._chooser);
        gmp.add("_jp_load", (JComponent)this._jb_load);
        gmp.set_layout("<table width='100%' height='100%' cellpadding='2' margin='2' border='0'>  <tr height='99%'>    <td fill='both'>::_chooser::</td>  </tr><tr height='1%'>    <td>::_jp_load::</td>  </tr></table>");
        this.setLayout(new BorderLayout());
        this.add((Component)gmp, "Center");
        this.pack();
    }

    public void load(File[] files) {
        final DICOMLoader dl = files.length == 1 ? new DICOMLoader(MasterControl.get_is(), files[0]) : new DICOMLoader(MasterControl.get_is(), files);
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                dl.load(this);
            }
        };
        t.start();
    }
}

