/*
 * Decompiled with CFR 0.152.
 */
package loader;

import gui.filechooser.tools.ReadableImageFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import jgridmaker.GMPanel;
import loader.ImagesLoader;
import loader.ImportImageAccessor;
import loader.OpenDialog;
import main.Global;
import main.ImageStack;
import main.MasterControl;
import settings.JBoolOptionCheckbox;
import settings.JDoubleOptionTextfield;
import settings.JIntegerOptionTextfield;
import settings.Settings;

public final class OpenImagesDialog
extends OpenDialog {
    public static final String OPT_X_SPACING = Settings.register_double_opt(OpenImagesDialog.class, "x-spacing", "Spacing between two voxels in x direction", 0.1);
    public static final String OPT_Y_SPACING = Settings.register_double_opt(OpenImagesDialog.class, "y-spacing", "Spacing between two voxels in x direction", 0.1);
    public static final String OPT_Z_SPACING = Settings.register_double_opt(OpenImagesDialog.class, "z-spacing", "Spacing between two voxels in x direction", 0.1);
    public static final String OPT_CROP = Settings.register_bool_opt(OpenImagesDialog.class, "crop", "Enables or disables circular cropping per image", false);
    public static final String OPT_CROP_BORDER = Settings.register_int_opt(OpenImagesDialog.class, "crop border", "Crop border in pixels", 0);
    private final JDoubleOptionTextfield _jdotf_sp_x;
    private final JDoubleOptionTextfield _jdotf_sp_y;
    private final JDoubleOptionTextfield _jdotf_sp_z;
    private final JIntegerOptionTextfield _jiotf_crop_border;
    private final JBoolOptionCheckbox _jbocb_circular_crop;
    private final JButton _jp_import;
    private final JFileChooser _chooser;

    public OpenImagesDialog(String dir_str) {
        super("Import Set of Images");
        this.setIconImage(Global.ICON_IMAGE);
        final OpenImagesDialog diag = this;
        GMPanel gmp = new GMPanel();
        ImportImageAccessor preview = new ImportImageAccessor();
        ReadableImageFilter filter = new ReadableImageFilter();
        filter.allowDirectories(true);
        this._chooser = new JFileChooser(dir_str);
        this._chooser.setAccessory(preview);
        this._chooser.addPropertyChangeListener(preview);
        this._chooser.setFileFilter(filter);
        this._chooser.setControlButtonsAreShown(false);
        this._chooser.setMultiSelectionEnabled(true);
        this._chooser.setAcceptAllFileFilterUsed(false);
        this._chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String evt_name = evt.getPropertyName();
                if (!evt_name.equals("directoryChanged") && evt_name.equals("SelectedFilesChangedProperty")) {
                    OpenImagesDialog.this._jp_import.setEnabled(OpenImagesDialog.this._chooser.getSelectedFiles().length != 0);
                }
            }
        });
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(8);
        this._jdotf_sp_x = new JDoubleOptionTextfield(OpenImagesDialog.class, OPT_X_SPACING, 8, format);
        this._jdotf_sp_y = new JDoubleOptionTextfield(OpenImagesDialog.class, OPT_Y_SPACING, 8, format);
        this._jdotf_sp_z = new JDoubleOptionTextfield(OpenImagesDialog.class, OPT_Z_SPACING, 8, format);
        this._jbocb_circular_crop = new JBoolOptionCheckbox(OpenImagesDialog.class, OPT_CROP);
        this._jbocb_circular_crop.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OpenImagesDialog.this._jiotf_crop_border.setEnabled(OpenImagesDialog.this._jbocb_circular_crop.isSelected());
            }
        });
        this._jiotf_crop_border = new JIntegerOptionTextfield(OpenImagesDialog.class, OPT_CROP_BORDER, 8);
        this._jiotf_crop_border.setEnabled(this._jbocb_circular_crop.isSelected());
        this._jiotf_crop_border.setColumns(3);
        this._jp_import = new JButton("Import");
        this._jp_import.setEnabled(false);
        this._jp_import.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.setVisible(false);
                double[] spacing = new double[]{((Number)OpenImagesDialog.this._jdotf_sp_x.getValue()).doubleValue(), ((Number)OpenImagesDialog.this._jdotf_sp_y.getValue()).doubleValue(), ((Number)OpenImagesDialog.this._jdotf_sp_z.getValue()).doubleValue()};
                int crop_border = ((Number)OpenImagesDialog.this._jiotf_crop_border.getValue()).intValue();
                File[] files = OpenImagesDialog.this._chooser.getSelectedFiles();
                ImageStack is = MasterControl.get_is();
                ImagesLoader il = new ImagesLoader(is, files, spacing, OpenImagesDialog.this._jbocb_circular_crop.isSelected(), crop_border);
                is.load(il);
            }
        });
        gmp.add("_chooser", (JComponent)this._chooser);
        gmp.add("sp_x", (JComponent)this._jdotf_sp_x);
        gmp.add("sp_y", (JComponent)this._jdotf_sp_y);
        gmp.add("sp_z", (JComponent)this._jdotf_sp_z);
        gmp.add("circular_crop", (JComponent)this._jbocb_circular_crop);
        gmp.add("crop_border", (JComponent)this._jiotf_crop_border);
        gmp.add("_jp_import", (JComponent)this._jp_import);
        gmp.set_layout("<table width='100%' height='100%' cellpadding='2' margin='10' border='0'>  <tr>    <td colspan='9' fill='both'>::_chooser::</td>  </tr><tr>    <td width='30%' anchor='east'>x-spacing:</td>    <td width='1%'  anchor='west'>::sp_x::</td>    <td width='9%'  anchor='west'>mm</td>    <td width='9%'  anchor='east'>y-spacing:</td>    <td width='1%'  anchor='west'>::sp_y::</td>    <td width='9%'  anchor='west'>mm</td>    <td width='9%'  anchor='east'>z-spacing:</td>    <td width='1%'  anchor='west'>::sp_z::</td>    <td width='31%' anchor='west'>mm</td>  </tr><tr>    <td colspan='1' anchor='east'>Crop Border</td>    <td colspan='1' anchor='east'>::crop_border::</td>    <td colspan='7' anchor='west'>::circular_crop::</td>  </tr><tr>    <td colspan='9'>::_jp_import::</td>  </tr></table>");
        this.setLayout(new BorderLayout());
        this.add((Component)gmp, "Center");
        this.pack();
    }
}

