/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.prefs.Preferences;
import loader.VolumeDataType;

public abstract class QuickLoadInfo {
    public static String PREF_SEP = ":";
    public static String PREF_DIM_X = "DimX";
    public static String PREF_DIM_Y = "DimY";
    public static String PREF_DIM_Z = "DimZ";
    public static String PREF_TYPE = "Type";
    public static String PREF_DATE = "Date";
    public static String PREF_BASEDIR = "BaseDir";
    public static String PREF_CHECKSUM = "CheckSum";
    public static String PREF_QL_STR = "QLStr";
    public static String PREF_QL_DESCR = "QLDescr";
    public static int LAST_LOAD_MAX = 8;
    protected static DateFormat _date_format = new SimpleDateFormat();
    protected int _check_sum;
    protected Date _date;
    protected VolumeDataType _type;
    protected String _type_string;
    protected String _base_dir;
    protected String _quick_load_str;
    protected String _quick_load_descr;
    protected Preferences _prefs;
    protected int _dim_x;
    protected int _dim_y;
    protected int _dim_z;

    public abstract QuickLoadInfo clone();

    public QuickLoadInfo() {
    }

    public QuickLoadInfo(String base_dir, int dim_x, int dim_y, int dim_z) {
        this._base_dir = base_dir;
        this._date = Calendar.getInstance().getTime();
        this._dim_x = dim_x;
        this._dim_y = dim_y;
        this._dim_z = dim_z;
    }

    public Date get_date() {
        return this._date;
    }

    public VolumeDataType get_type() {
        return this._type;
    }

    public String get_base_dir() {
        return this._base_dir;
    }

    public String get_ql_str() {
        return this._quick_load_str;
    }

    public String get_ql_descr() {
        return this._quick_load_descr;
    }

    public int get_checksum() {
        return this._check_sum;
    }

    public int get_dim_x() {
        return this._dim_x;
    }

    public int get_dim_y() {
        return this._dim_y;
    }

    public int get_dim_z() {
        return this._dim_z;
    }

    public void quick_init(Preferences prefs) {
        this._prefs = prefs;
        String date_str = prefs.get(PREF_DATE, "");
        try {
            this._date = _date_format.parse(date_str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this._base_dir = prefs.get(PREF_BASEDIR, "");
        this._check_sum = prefs.getInt(PREF_CHECKSUM, 0);
        this._quick_load_str = prefs.get(PREF_QL_STR, "");
        this._quick_load_descr = prefs.get(PREF_QL_DESCR, "");
        this._dim_x = prefs.getInt(PREF_DIM_X, 0);
        this._dim_y = prefs.getInt(PREF_DIM_Y, 0);
        this._dim_z = prefs.getInt(PREF_DIM_Z, 0);
    }

    public abstract void load();

    public void save(Preferences prefs) {
        this._prefs = prefs;
        prefs.put(PREF_TYPE, this._type_string);
        prefs.put(PREF_DATE, _date_format.format(this._date));
        prefs.put(PREF_BASEDIR, this._base_dir);
        prefs.putInt(PREF_CHECKSUM, this._check_sum);
        prefs.put(PREF_QL_STR, this._quick_load_str);
        prefs.put(PREF_QL_DESCR, this._quick_load_descr);
        prefs.putInt(PREF_DIM_X, this._dim_x);
        prefs.putInt(PREF_DIM_Y, this._dim_y);
        prefs.putInt(PREF_DIM_Z, this._dim_z);
    }
}

