/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import loader.DICOMType;
import loader.ImagesType;
import loader.QuickLoadInfo;
import loader.REKType;
import loader.TypeRegistry;
import main.YaDiV;

public class QuickLoadStorage {
    public static String PREF_SEP = ":";
    public static String PREF_PREFIX = "LastLoaded" + PREF_SEP;
    public static String PREF_LATEST = "Latest";
    public static String PREF_VERSION = "Version";
    public static int VERSION = 2;
    public QuickLoadInfo[] _qli_container;
    public JMenuItem[] _menu_entries;
    public Preferences _prefs_root;
    public int _last_loaded;
    private int _num_of_entries;

    public QuickLoadStorage(JMenuItem[] entries) {
        this._menu_entries = entries;
        this._num_of_entries = entries.length;
        this._qli_container = new QuickLoadInfo[this._num_of_entries];
        this._prefs_root = Preferences.userRoot().node("YaDiV").node("OpenRecent");
        TypeRegistry.register_type(new DICOMType());
        TypeRegistry.register_type(new ImagesType());
        TypeRegistry.register_type(new REKType());
    }

    private int get_circular_idx(int i) {
        int tmp = this._last_loaded + i;
        while (tmp < 0) {
            tmp += this._num_of_entries;
        }
        return tmp % this._num_of_entries;
    }

    private Preferences get_node(int i) {
        return Preferences.userRoot().node("YaDiV").node("OpenRecent").node("" + i);
    }

    public void init() {
        try {
            int stored_version = this._prefs_root.getInt(String.valueOf(PREF_PREFIX) + PREF_VERSION, 0);
            if (stored_version != VERSION) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "deleting old recent storage ...");
                this._prefs_root.removeNode();
                this._prefs_root = Preferences.userRoot().node("YaDiV").node("OpenRecent");
                this._prefs_root.putInt(String.valueOf(PREF_PREFIX) + PREF_LATEST, 0);
                this._prefs_root.putInt(String.valueOf(PREF_PREFIX) + PREF_VERSION, VERSION);
            }
            this._prefs_root.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this._last_loaded = this._prefs_root.getInt(String.valueOf(PREF_PREFIX) + PREF_LATEST, this._num_of_entries - 1);
        int i = 0;
        while (i < this._menu_entries.length) {
            QuickLoadInfo qli;
            this._qli_container[i] = qli = TypeRegistry.get_qli_instance(this.get_node(i));
            ++i;
        }
        this.update_menu_entries();
    }

    private void update_menu_entries() {
        int i = 0;
        while (i < this._menu_entries.length) {
            int idx = this.get_circular_idx(-i);
            QuickLoadInfo qli = this._qli_container[idx];
            if (qli != null) {
                this._menu_entries[i].setText(String.valueOf(i + 1) + " " + qli.get_ql_str());
                this._menu_entries[i].setEnabled(true);
                this._menu_entries[i].setToolTipText(qli.get_ql_descr());
            } else {
                this._menu_entries[i].setText(" ---");
                this._menu_entries[i].setEnabled(false);
                this._menu_entries[i].setToolTipText("---");
            }
            ++i;
        }
    }

    private boolean entry_exists(QuickLoadInfo new_entry) {
        int i = 0;
        while (i < this._num_of_entries) {
            QuickLoadInfo old_entry = this._qli_container[i];
            if (old_entry != null && new_entry.get_base_dir().equals(old_entry.get_base_dir()) && new_entry.get_checksum() == old_entry.get_checksum()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void loaded(QuickLoadInfo new_entry) {
        if (new_entry == null) {
            return;
        }
        if (!this.entry_exists(new_entry)) {
            int oldest_idx = this._qli_container[this._last_loaded] != null ? this.get_circular_idx(1) : this._last_loaded;
            try {
                this.get_node(oldest_idx).removeNode();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
            new_entry.save(this.get_node(oldest_idx));
            this._qli_container[oldest_idx] = new_entry;
            this._last_loaded = oldest_idx;
            this._prefs_root.putInt(String.valueOf(PREF_PREFIX) + PREF_LATEST, this._last_loaded);
            this.update_menu_entries();
        }
    }

    public QuickLoadInfo get_qli(int i) {
        int idx = this.get_circular_idx(-i);
        return this._qli_container[idx];
    }
}

