/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import loader.REKLoadInfo;
import loader.VolumeDataLoader;
import main.ImageStack;
import main.YaDiV;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;
import misc.grid.MutableRegularGrid3i;
import threads.RSThread;

public class REKLoader
extends VolumeDataLoader {
    private File _rek_file;

    public REKLoader(ImageStack is, REKLoadInfo qi) {
        super(is, qi);
        this._rek_file = new File(qi._file_name);
    }

    public REKLoader(ImageStack is, File rek_file) {
        super(is, rek_file.getParent());
        this._rek_file = rek_file;
    }

    @Override
    public void load(RSThread rst) {
        byte[] buffer = new byte[2048];
        int dim_x = 0;
        int dim_y = 0;
        int dim_z = 0;
        float spacing_xy = 0.0f;
        float spacing_z = 0.0f;
        int bits_per_value = 0;
        int bytes_per_value = 0;
        MutableRegularGrid3i vc = null;
        ImageStack.DICOMInfo di_info = this._is.get_dicom_info();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this._rek_file);
            fis.read(buffer);
            dim_x = this.parse_uint16(buffer, 0);
            dim_y = this.parse_uint16(buffer, 2);
            dim_z = this.parse_uint16(buffer, 6);
            bits_per_value = this.parse_uint16(buffer, 4);
            bytes_per_value = bits_per_value / 8;
            spacing_xy = this.parse_float(buffer, 584);
            spacing_z = this.parse_float(buffer, 588);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DiFile[] dicom_files = new DiFile[dim_z];
        this._is.set_state(1);
        this._is.send_message(ImageStack.M_LOADING_START, null);
        this._is.set_di_files(dicom_files);
        di_info._slope = 1;
        di_info._intercept = 0;
        di_info._w_width = di_info._max_voxel_value = 1 << bits_per_value;
        di_info._w_center = di_info._max_voxel_value / 2;
        if (rst != null) {
            rst.init_progress_measure("importing Fraunhofer Raw Volume ...", 0, dim_z, 0);
        }
        int voxel_counter = 0;
        int i = 0;
        while (i < dim_z) {
            DiFile df = new DiFile(DiFile.ENDIAN_LITTLE, DiFile.VR_EXPLICIT);
            HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
            DiDataElement de = new DiDataElement(32, 13, 21833, new String("100").getBytes());
            data_elements.put(de.get_tag(), de);
            de = new DiDataElement(32, 14, 21833, new String("101").getBytes());
            data_elements.put(de.get_tag(), de);
            dicom_files[i] = df;
            if (i == 0) {
                vc = ImageStack.create_voxel_cube_instance(dim_x, dim_y, dim_z);
                this._is.set_grid(vc);
                di_info._pixel_spacing[0] = spacing_xy;
                di_info._pixel_spacing[1] = spacing_xy;
                di_info._pixel_spacing[2] = spacing_z;
                this._is.send_message(ImageStack.M_VC_SPACING_CHANGED, null);
                this._is.send_message(ImageStack.M_LOADING_FIRST_IMAGE, null);
            }
            try {
                byte[] img_buffer = new byte[dim_x * dim_y * bytes_per_value];
                fis.read(img_buffer);
                int byte_counter = 0;
                int y = 0;
                while (y < dim_y) {
                    int x = 0;
                    while (x < dim_x) {
                        vc.set(voxel_counter++, this.parse_uint16(img_buffer, byte_counter));
                        byte_counter += bytes_per_value;
                        ++x;
                    }
                    ++y;
                }
            }
            catch (IOException ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "ImageStack::import_rek " + ex.getMessage());
            }
            if (rst != null) {
                rst.inc_progress_value(1);
            }
            this._is.send_message(ImageStack.M_LOADING_NEW_IMAGE, null);
            ++i;
        }
        this._is.set_state(2);
        System.gc();
        System.gc();
        System.gc();
        this._is.send_message(ImageStack.M_LOADING_END, new REKLoadInfo(this._rek_file, dim_x, dim_y, dim_z));
    }

    private int parse_uint16(byte[] buffer, int pos) {
        return (buffer[pos + 1] & 0xFF) << 8 | buffer[pos] & 0xFF;
    }

    private float parse_float(byte[] buffer, int pos) {
        int spacingXYFP754Value = (buffer[pos + 3] & 0xFF) << 24 | (buffer[pos + 2] & 0xFF) << 16 | (buffer[pos + 1] & 0xFF) << 8 | buffer[pos] & 0xFF;
        return Float.intBitsToFloat(spacingXYFP754Value);
    }
}

