/*
 * Decompiled with CFR 0.152.
 */
package loader;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.ImageStack;
import misc.dicom.DiFile;
import misc.grid.MutableRegularGrid3i;

public class SpatConverter {
    private static final int OUT_OF_BOUNDS = 0;
    private Point3d _centroid;
    private MutableRegularGrid3i _vc_nonreg;
    private int _nonreg_dim_x;
    private int _nonreg_dim_y;
    private int _nonreg_dim_z;
    private Matrix4d _m_nonreg_to_wk;
    private Matrix4d _m_reg_to_nonreg;
    private Point3d _wk_bb_min;
    private Point3d _wk_bb_max;
    private Vector3d _reg_bb_dim;
    private double[] _reg_spacing = new double[3];

    public SpatConverter(MutableRegularGrid3i vc_nonreg, DiFile[] di_files, ImageStack.DICOMInfo di) {
        this._centroid = new Point3d();
        this._vc_nonreg = vc_nonreg;
        this._nonreg_dim_x = this._vc_nonreg.get_dim_x();
        this._nonreg_dim_y = this._vc_nonreg.get_dim_y();
        this._nonreg_dim_z = this._vc_nonreg.get_dim_z();
        this.init(di_files, di);
    }

    public double get_reg_spacing(int i) {
        return this._reg_spacing[i];
    }

    private void init(DiFile[] di_files, ImageStack.DICOMInfo di) {
        double[] nonreg_spacing = new double[3];
        double[][] iop = di_files[0].get_image_orientation_patient();
        System.arraycopy(di._pixel_spacing, 0, nonreg_spacing, 0, 3);
        int file_num = di_files.length;
        Vector3d t1 = new Vector3d(di_files[0].get_image_pos_patient());
        Vector3d tn = new Vector3d(di_files[file_num - 1].get_image_pos_patient());
        Vector3d k = new Vector3d(t1);
        k.sub((Tuple3d)tn);
        k.scale(1.0 / (double)(1 - file_num));
        this._m_nonreg_to_wk = new Matrix4d(nonreg_spacing[0] * iop[0][0], nonreg_spacing[1] * iop[1][0], k.x, t1.x, nonreg_spacing[0] * iop[0][1], nonreg_spacing[1] * iop[1][1], k.y, t1.y, nonreg_spacing[0] * iop[0][2], -nonreg_spacing[1] * iop[1][2], k.z, t1.z, 0.0, 0.0, 0.0, 1.0);
        Point3d p000 = new Point3d(0.0, 0.0, 0.0);
        this._m_nonreg_to_wk.transform(p000);
        Point3d p111 = new Point3d(1.0, 1.0, 1.0);
        this._m_nonreg_to_wk.transform(p111);
        this._reg_spacing[0] = Math.abs(p111.x - p000.x);
        this._reg_spacing[1] = Math.abs(p111.y - p000.y);
        this._reg_spacing[2] = Math.abs(p111.z - p000.z);
        int nonreg_dimx = this._vc_nonreg.get_dim_x();
        int nonreg_dimy = this._vc_nonreg.get_dim_y();
        int nonreg_dimz = this._vc_nonreg.get_dim_z();
        Point3d[] nonreg_corners = new Point3d[]{new Point3d(0.0, 0.0, 0.0), new Point3d((double)nonreg_dimx, 0.0, 0.0), new Point3d(0.0, (double)nonreg_dimy, 0.0), new Point3d(0.0, 0.0, (double)nonreg_dimz), new Point3d((double)nonreg_dimx, (double)nonreg_dimy, 0.0), new Point3d(0.0, (double)nonreg_dimy, (double)nonreg_dimz), new Point3d((double)nonreg_dimx, (double)nonreg_dimy, (double)nonreg_dimz), new Point3d((double)nonreg_dimx, 0.0, (double)nonreg_dimz)};
        this._wk_bb_min = new Point3d(2.147483647E9, 2.147483647E9, 2.147483647E9);
        this._wk_bb_max = new Point3d(-2.147483648E9, -2.147483648E9, -2.147483648E9);
        int i = 0;
        while (i < nonreg_corners.length) {
            this._m_nonreg_to_wk.transform(nonreg_corners[i]);
            this._wk_bb_min.x = Math.min(this._wk_bb_min.x, nonreg_corners[i].x);
            this._wk_bb_min.y = Math.min(this._wk_bb_min.y, nonreg_corners[i].y);
            this._wk_bb_min.z = Math.min(this._wk_bb_min.z, nonreg_corners[i].z);
            this._wk_bb_max.x = Math.max(this._wk_bb_max.x, nonreg_corners[i].x);
            this._wk_bb_max.y = Math.max(this._wk_bb_max.y, nonreg_corners[i].y);
            this._wk_bb_max.z = Math.max(this._wk_bb_max.z, nonreg_corners[i].z);
            ++i;
        }
        this._reg_bb_dim = new Vector3d((Tuple3d)this._wk_bb_max);
        this._reg_bb_dim.sub((Tuple3d)this._wk_bb_min);
        this._reg_bb_dim.x = this._reg_bb_dim.x / this._reg_spacing[0] + 1.0;
        this._reg_bb_dim.y = this._reg_bb_dim.y / this._reg_spacing[1] + 1.0;
        this._reg_bb_dim.z = this._reg_bb_dim.z / this._reg_spacing[2] + 1.0;
        Matrix4d m_trans = new Matrix4d(1.0, 0.0, 0.0, this._wk_bb_min.x, 0.0, 1.0, 0.0, this._wk_bb_min.y, 0.0, 0.0, 1.0, this._wk_bb_min.z, 0.0, 0.0, 0.0, 1.0);
        Matrix4d m_scale = new Matrix4d(this._reg_spacing[0], 0.0, 0.0, 0.0, 0.0, this._reg_spacing[1], 0.0, 0.0, 0.0, 0.0, this._reg_spacing[2], 0.0, 0.0, 0.0, 0.0, 1.0);
        this._m_reg_to_nonreg = new Matrix4d(this._m_nonreg_to_wk);
        this._m_reg_to_nonreg.invert();
        this._m_reg_to_nonreg.mul(m_trans);
        this._m_reg_to_nonreg.mul(m_scale);
    }

    public Vector3d get_dim() {
        return this._reg_bb_dim;
    }

    public double lerp(double x, double q00, double q01) {
        return (1.0 - x) * q00 + x * q01;
    }

    public double tri_lerp(double x, double y, double z, double q000, double q001, double q010, double q011, double q100, double q101, double q110, double q111) {
        double z00 = this.lerp(z, q000, q001);
        double z01 = this.lerp(z, q010, q011);
        double z10 = this.lerp(z, q100, q101);
        double z11 = this.lerp(z, q110, q111);
        double r0 = this.lerp(y, z00, z01);
        double r1 = this.lerp(y, z10, z11);
        return this.lerp(x, r0, r1);
    }

    public int interpolate(int x, int y, int z) {
        int value = 0;
        this._centroid.set((double)x, (double)y, (double)z);
        this._m_reg_to_nonreg.transform(this._centroid);
        if (this._centroid.x > 0.0 && this._centroid.y > 0.0 && this._centroid.z > 0.0 && this._centroid.x < (double)(this._nonreg_dim_x - 2) && this._centroid.y < (double)(this._nonreg_dim_y - 2) && this._centroid.z < (double)(this._nonreg_dim_z - 2)) {
            int xmin = (int)this._centroid.x;
            int ymin = (int)this._centroid.y;
            int zmin = (int)this._centroid.z;
            double weight_x = this._centroid.x - (double)((int)this._centroid.x);
            double weight_y = this._centroid.y - (double)((int)this._centroid.y);
            double weight_z = this._centroid.z - (double)((int)this._centroid.z);
            int q000 = this._vc_nonreg.get(xmin + 0, ymin + 0, zmin + 0);
            int q001 = this._vc_nonreg.get(xmin + 0, ymin + 0, zmin + 1);
            int q010 = this._vc_nonreg.get(xmin + 0, ymin + 1, zmin + 0);
            int q011 = this._vc_nonreg.get(xmin + 0, ymin + 1, zmin + 1);
            int q100 = this._vc_nonreg.get(xmin + 1, ymin + 0, zmin + 0);
            int q101 = this._vc_nonreg.get(xmin + 1, ymin + 0, zmin + 1);
            int q110 = this._vc_nonreg.get(xmin + 1, ymin + 1, zmin + 0);
            int q111 = this._vc_nonreg.get(xmin + 1, ymin + 1, zmin + 1);
            value = (int)(this.tri_lerp(weight_x, weight_y, weight_z, q000, q001, q010, q011, q100, q101, q110, q111) + 0.5);
        }
        return value;
    }
}

