/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.util.HashMap;
import java.util.prefs.Preferences;
import loader.QuickLoadInfo;
import loader.VolumeDataType;

public final class TypeRegistry {
    private static final HashMap<String, VolumeDataType> _type_map = new HashMap();

    public static boolean register_type(VolumeDataType type) {
        if (_type_map.containsKey(type.get_name())) {
            return false;
        }
        _type_map.put(type.get_name(), type);
        return true;
    }

    public static VolumeDataType get_type(String type_name) {
        return _type_map.get(type_name);
    }

    private TypeRegistry() {
    }

    public static QuickLoadInfo get_qli_instance(Preferences prefs) {
        VolumeDataType type;
        QuickLoadInfo qli = null;
        String type_str = prefs.get(QuickLoadInfo.PREF_TYPE, "");
        if (type_str != null && (type = TypeRegistry.get_type(type_str)) != null) {
            qli = type.get_info().clone();
            qli.quick_init(prefs);
        }
        return qli;
    }
}

