/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashMap;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import main.ImageStack;
import misc.Voxel;

public class CoordinateConverter {
    private ImageStack.DICOMInfo _di_info;
    private static HashMap<ImageStack, CoordinateConverter> _cc_map = new HashMap();

    private CoordinateConverter() {
    }

    private CoordinateConverter(ImageStack is) {
        this._di_info = is.get_dicom_info();
    }

    public static CoordinateConverter get_converter(ImageStack is) {
        CoordinateConverter cc_conv = _cc_map.get(is);
        if (cc_conv == null) {
            cc_conv = new CoordinateConverter(is);
            _cc_map.put(is, cc_conv);
        }
        return cc_conv;
    }

    public Point3f grid_to_world_p3f(int x, int y, int z) {
        return new Point3f((float)((double)x * this._di_info._pixel_spacing[0]), (float)((double)y * this._di_info._pixel_spacing[1]), (float)((double)z * this._di_info._pixel_spacing[2]));
    }

    public Point3f grid_to_world_p3f(float x, float y, float z) {
        return new Point3f((float)((double)x * this._di_info._pixel_spacing[0]), (float)((double)y * this._di_info._pixel_spacing[1]), (float)((double)z * this._di_info._pixel_spacing[2]));
    }

    public Point3f grid_to_world_p3f(double x, double y, double z) {
        return new Point3f((float)(x * this._di_info._pixel_spacing[0]), (float)(y * this._di_info._pixel_spacing[1]), (float)(z * this._di_info._pixel_spacing[2]));
    }

    public Vector3f grid_to_world_v3f(int x, int y, int z) {
        return new Vector3f((float)((double)x * this._di_info._pixel_spacing[0]), (float)((double)y * this._di_info._pixel_spacing[1]), (float)((double)z * this._di_info._pixel_spacing[2]));
    }

    public Vector3f grid_to_world_v3f(float x, float y, float z) {
        return new Vector3f((float)((double)x * this._di_info._pixel_spacing[0]), (float)((double)y * this._di_info._pixel_spacing[1]), (float)((double)z * this._di_info._pixel_spacing[2]));
    }

    public Vector3f grid_to_world_v3f(double x, double y, double z) {
        return new Vector3f((float)(x * this._di_info._pixel_spacing[0]), (float)(y * this._di_info._pixel_spacing[1]), (float)(z * this._di_info._pixel_spacing[2]));
    }

    public Point3d grid_to_world_p3d(int x, int y, int z) {
        return new Point3d((double)x * this._di_info._pixel_spacing[0], (double)y * this._di_info._pixel_spacing[1], (double)z * this._di_info._pixel_spacing[2]);
    }

    public Point3d grid_to_world_p3d(double x, double y, double z) {
        return new Point3d(x * this._di_info._pixel_spacing[0], y * this._di_info._pixel_spacing[1], z * this._di_info._pixel_spacing[2]);
    }

    public Vector3d grid_to_world_v3d(int x, int y, int z) {
        return new Vector3d((double)x * this._di_info._pixel_spacing[0], (double)y * this._di_info._pixel_spacing[1], (double)z * this._di_info._pixel_spacing[2]);
    }

    public Vector3d grid_to_world_v3d(double x, double y, double z) {
        return new Vector3d(x * this._di_info._pixel_spacing[0], y * this._di_info._pixel_spacing[1], z * this._di_info._pixel_spacing[2]);
    }

    public Point3f grid_to_world_p3f(Voxel vox) {
        return this.grid_to_world_p3f(vox._x, vox._y, vox._z);
    }

    public Point3f grid_to_world_p3f(Point3f p3f) {
        return this.grid_to_world_p3f(p3f.x, p3f.y, p3f.z);
    }

    public Point3f grid_to_world_v3f(Point3d p3d) {
        return this.grid_to_world_p3f(p3d.x, p3d.y, p3d.z);
    }

    public Vector3f grid_to_world_v3f(Voxel vox) {
        return this.grid_to_world_v3f(vox._x, vox._y, vox._z);
    }

    public Vector3f grid_to_world_v3f(Vector3f v3f) {
        return this.grid_to_world_v3f(v3f.x, v3f.y, v3f.z);
    }

    public Vector3f grid_to_world_v3f(Vector3d v3d) {
        return this.grid_to_world_v3f(v3d.x, v3d.y, v3d.z);
    }

    public Point3d grid_to_world_p3d(Voxel vox) {
        return this.grid_to_world_p3d(vox._x, vox._y, vox._z);
    }

    public Point3d grid_to_world_p3d(Point3d p3d) {
        return this.grid_to_world_p3d(p3d.x, p3d.y, p3d.z);
    }

    public Vector3d grid_to_world_v3d(Voxel vox) {
        return this.grid_to_world_v3d(vox._x, vox._y, vox._z);
    }

    public Vector3d grid_to_world_v3d(Vector3d v3d) {
        return this.grid_to_world_v3d(v3d.x, v3d.y, v3d.z);
    }

    public Point3f world_to_grid_p3f(int x, int y, int z) {
        return new Point3f((float)((double)x / this._di_info._pixel_spacing[0]), (float)((double)y / this._di_info._pixel_spacing[1]), (float)((double)z / this._di_info._pixel_spacing[2]));
    }

    public Point3f world_to_grid_p3f(float x, float y, float z) {
        return new Point3f((float)((double)x / this._di_info._pixel_spacing[0]), (float)((double)y / this._di_info._pixel_spacing[1]), (float)((double)z / this._di_info._pixel_spacing[2]));
    }

    public Point3f world_to_grid_p3f(double x, double y, double z) {
        return new Point3f((float)(x / this._di_info._pixel_spacing[0]), (float)(y / this._di_info._pixel_spacing[1]), (float)(z / this._di_info._pixel_spacing[2]));
    }

    public Vector3f world_to_grid_v3f(int x, int y, int z) {
        return new Vector3f((float)((double)x / this._di_info._pixel_spacing[0]), (float)((double)y / this._di_info._pixel_spacing[1]), (float)((double)z / this._di_info._pixel_spacing[2]));
    }

    public Vector3f world_to_grid_v3f(float x, float y, float z) {
        return new Vector3f((float)((double)x / this._di_info._pixel_spacing[0]), (float)((double)y / this._di_info._pixel_spacing[1]), (float)((double)z / this._di_info._pixel_spacing[2]));
    }

    public Vector3f world_to_grid_v3f(double x, double y, double z) {
        return new Vector3f((float)(x / this._di_info._pixel_spacing[0]), (float)(y / this._di_info._pixel_spacing[1]), (float)(z / this._di_info._pixel_spacing[2]));
    }

    public Point3d world_to_grid_p3d(int x, int y, int z) {
        return new Point3d((double)x / this._di_info._pixel_spacing[0], (double)y / this._di_info._pixel_spacing[1], (double)z / this._di_info._pixel_spacing[2]);
    }

    public Point3d world_to_grid_p3d(double x, double y, double z) {
        return new Point3d(x / this._di_info._pixel_spacing[0], y / this._di_info._pixel_spacing[1], z / this._di_info._pixel_spacing[2]);
    }

    public Vector3d world_to_grid_v3d(int x, int y, int z) {
        return new Vector3d((double)x / this._di_info._pixel_spacing[0], (double)y / this._di_info._pixel_spacing[1], (double)z / this._di_info._pixel_spacing[2]);
    }

    public Vector3d world_to_grid_v3d(double x, double y, double z) {
        return new Vector3d(x / this._di_info._pixel_spacing[0], y / this._di_info._pixel_spacing[1], z / this._di_info._pixel_spacing[2]);
    }

    public Point3f world_to_grid_p3f(Voxel vox) {
        return this.world_to_grid_p3f(vox._x, vox._y, vox._z);
    }

    public Point3f world_to_grid_p3f(Point3f p3f) {
        return this.world_to_grid_p3f(p3f.x, p3f.y, p3f.z);
    }

    public Point3f world_to_grid_p3f(Point3d p3d) {
        return this.world_to_grid_p3f(p3d.x, p3d.y, p3d.z);
    }

    public Vector3f world_to_grid_v3f(Voxel vox) {
        return this.world_to_grid_v3f(vox._x, vox._y, vox._z);
    }

    public Vector3f world_to_grid_v3f(Vector3f v3f) {
        return this.world_to_grid_v3f(v3f.x, v3f.y, v3f.z);
    }

    public Vector3f world_to_grid_v3f(Vector3d v3d) {
        return this.world_to_grid_v3f(v3d.x, v3d.y, v3d.z);
    }

    public Point3d world_to_grid_p3d(Voxel vox) {
        return this.world_to_grid_p3d(vox._x, vox._y, vox._z);
    }

    public Point3d world_to_grid_p3d(Point3d p3d) {
        return this.world_to_grid_p3d(p3d.x, p3d.y, p3d.z);
    }

    public Vector3d world_to_grid_v3d(Voxel vox) {
        return this.world_to_grid_v3d(vox._x, vox._y, vox._z);
    }

    public Vector3d world_to_grid_v3d(Vector3d v3d) {
        return this.world_to_grid_v3d(v3d.x, v3d.y, v3d.z);
    }
}

