/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import main.Global;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.dicom.DiDataElement;
import misc.dicom.DiDi;
import misc.dicom.DiFile;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import settings.Settings;
import settings.SettingsComponentFactory;
import settings.SettingsOwner;

public final class DicomInfoWindow
extends JFrame
implements YObserverWantsAWTThread,
SettingsOwner,
ComponentListener {
    public static final String DF_INDEX = Settings.register_int_opt(DicomInfoWindow.class, "DiFile Index", "Sets the index of the DiFile whose info should be shown", 0);
    public static final String SYNC_V2D = Settings.register_bool_opt(DicomInfoWindow.class, "Synchronise V2D", "If set to true, the DicomInfoWindow synchronizes itself with the DiFile shown in the 2D viewport", false);
    private static int COLUMN_NUMBER = 5;
    private static DicomInfoWindow _instance;
    private final JTable _jt_table;
    private final JScrollPane _sp_dicom_tags;
    private final DefaultTableModel _tm;
    private final JList _jl_di_files;
    private final JScrollPane _sp_di_files;
    private final DefaultListModel _slice_names = new DefaultListModel();
    private final ArrayList<Boolean> _group_borders = new ArrayList();
    private final String[] _column_names = new String[]{"Tag", "Description", "VR", "VL", "Value"};
    private final int[] _column_width = new int[COLUMN_NUMBER];
    private String[][] _table_data;

    public DicomInfoWindow() {
        _instance = this;
        this.setIconImage(Global.ICON_IMAGE);
        Settings.register_owner(this);
        this.setSize(new Dimension(800, 800));
        this._tm = new DefaultTableModel();
        this._jt_table = new JTable(this._tm);
        this._jt_table.setDefaultRenderer(Object.class, new BorderCellRenderer());
        this._jt_table.setAutoResizeMode(2);
        this._sp_dicom_tags = new JScrollPane(this._jt_table);
        Object[][] table_data = new String[1][COLUMN_NUMBER];
        int i = 0;
        while (i < COLUMN_NUMBER) {
            table_data[0][i] = new String("...");
            ++i;
        }
        this._tm.setDataVector(table_data, this._column_names);
        JPanel left_panel = new JPanel();
        left_panel.setLayout(new BorderLayout());
        JCheckBox jcb = (JCheckBox)SettingsComponentFactory.create_component(DicomInfoWindow.class, SYNC_V2D);
        jcb.setText("Sync V2D");
        this._jl_di_files = new JList(this._slice_names);
        this._sp_di_files = new JScrollPane(this._jl_di_files);
        this.init_lists();
        left_panel.add((Component)this._sp_di_files, "Center");
        left_panel.add((Component)jcb, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)left_panel, "West");
        this.add((Component)this._sp_dicom_tags, "Center");
        this.setResizable(true);
        this.setVisible(true);
        if (Settings.get_bool_option(this, SYNC_V2D).booleanValue()) {
            MasterControl.get_is().addObserver(this, "DicomInfoWindow()");
        }
        MasterControl.get_is().addObserver(this, "DICOMInfoWindow");
        this._jt_table.addComponentListener(this);
    }

    void init_lists() {
        ImageStack is = MasterControl.get_is();
        int max_digits = 0;
        int i = 0;
        while (i < is.get_dicom_file_number()) {
            String str_idx = "" + is.get_dicom_file(i).get_image_number();
            if (max_digits < str_idx.length()) {
                max_digits = str_idx.length();
            }
            ++i;
        }
        this._slice_names.clear();
        String spaces = "                 ";
        int i2 = 0;
        while (i2 < is.get_dicom_file_number()) {
            int idx = is.get_dicom_file(i2).get_image_number();
            String name = new String();
            name = "" + idx;
            name = String.valueOf("                 ".substring(0, max_digits - name.length())) + name;
            this._slice_names.addElement(name);
            ++i2;
        }
        String prototype = "1234567890";
        this._jl_di_files.setPrototypeCellValue(" " + "1234567890".substring(0, max_digits) + " ");
        this._jl_di_files.setSelectedIndex(0);
        this._jl_di_files.setSelectionMode(0);
        this._jl_di_files.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int df_index = DicomInfoWindow.this._jl_di_files.getSelectedIndex();
                if (df_index >= 0 && df_index != Settings.get_int_option(_instance, DF_INDEX)) {
                    Settings.set_int_option(_instance, DF_INDEX, df_index);
                }
            }
        });
        this.update_info();
    }

    public void update_info() {
        int df_number = Settings.get_int_option(this, DF_INDEX);
        if (df_number < 0) {
            this.setTitle("Wrong viewmode: Can not display Tag-Info");
            this._jt_table.setVisible(false);
            return;
        }
        int selected_row = this._jt_table.getSelectedRow();
        String selected_tag = selected_row != -1 ? new String(this._table_data[selected_row][0]) : null;
        selected_row = -1;
        DiFile df = MasterControl.get_is().get_dicom_file(df_number);
        this.setTitle("DICOM File Info: " + df.get_file_name());
        HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
        ArrayList<Integer> de_tags = new ArrayList<Integer>(df.get_data_elements().keySet());
        Collections.sort(de_tags);
        this._table_data = new String[de_tags.size()][COLUMN_NUMBER];
        int i = 0;
        Iterator<Integer> de_tags_it = de_tags.iterator();
        int old_group = data_elements.get(de_tags.get(0)).get_group_id();
        this._group_borders.clear();
        while (de_tags_it.hasNext()) {
            int tag = de_tags_it.next();
            DiDataElement de = data_elements.get(tag);
            int group = de.get_group_id();
            this._table_data[i][0] = " " + de.get_tag_string() + " ";
            this._table_data[i][1] = DiDi.get_tag_descr(de.get_tag());
            this._table_data[i][2] = " " + de.get_vr_string() + " ";
            this._table_data[i][3] = " " + de.get_vl() + " ";
            this._table_data[i][4] = de.get_value_as_string();
            if (old_group == group) {
                this._group_borders.add(false);
            } else {
                this._group_borders.add(true);
                old_group = group;
            }
            if (selected_tag != null && this._table_data[i][0].equals(selected_tag)) {
                selected_row = i;
            }
            ++i;
        }
        this._tm.setDataVector(this._table_data, this._column_names);
        this.calc_best_fit();
        this.my_resize();
        if (selected_row != -1) {
            this._jt_table.setRowSelectionInterval(selected_row, selected_row);
        }
        this._jl_di_files.setSelectedIndex(df_number);
        this._jl_di_files.ensureIndexIsVisible(df_number);
        this._jt_table.setVisible(true);
    }

    private final void calc_best_fit() {
        int col = 0;
        while (col < 4) {
            JLabel jtc = new JLabel(this._column_names[col]);
            String text = jtc.getText();
            Font font = jtc.getFont();
            FontMetrics font_metrics = jtc.getFontMetrics(font);
            int max_cell_width = SwingUtilities.computeStringWidth(font_metrics, text);
            int row = 0;
            while (row < this._tm.getRowCount()) {
                BorderCellRenderer tableCellRenderer = (BorderCellRenderer)this._jt_table.getCellRenderer(row, col);
                jtc = tableCellRenderer.get_label(this._jt_table, this._jt_table.getValueAt(row, col), false, false, row, col);
                text = jtc.getText();
                font = jtc.getFont();
                font_metrics = jtc.getFontMetrics(font);
                int textWidth = SwingUtilities.computeStringWidth(font_metrics, text);
                max_cell_width = Math.max(max_cell_width, textWidth);
                ++row;
            }
            this._column_width[col] = max_cell_width + 10;
            ++col;
        }
        this._column_width[1] = 200;
    }

    private void my_resize() {
        int first = 0;
        int col = 0;
        while (col < 4) {
            this._jt_table.getColumnModel().getColumn(col).setPreferredWidth(this._column_width[col]);
            first += this._column_width[col];
            ++col;
        }
        int rest = this._jt_table.getWidth() - first;
        this._jt_table.getColumnModel().getColumn(4).setPreferredWidth(rest);
    }

    @Override
    public void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_CLEAR) {
            this._slice_names.clear();
        } else if (m._type == ImageStack.M_LOADING_END) {
            this.init_lists();
        }
    }

    @Override
    public String get_name() {
        return "DicomInfoWindow";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == DF_INDEX) {
            this.update_info();
        }
        if (opt_name == SYNC_V2D) {
            if (Settings.get_bool_option(this, SYNC_V2D).booleanValue()) {
                this._jl_di_files.setEnabled(false);
            } else {
                this._jl_di_files.setEnabled(true);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.my_resize();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    private class BorderCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private BorderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            JLabel cell_label = (JLabel)cell;
            if (((Boolean)DicomInfoWindow.this._group_borders.get(row)).booleanValue()) {
                cell_label.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                cell_label.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.gray));
            }
            return cell;
        }

        public JLabel get_label(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JLabel)super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
        }
    }
}

