/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.uce.userlab.haptics.DeviceException;
import com.uce.userlab.haptics.PhantomDevice;
import com.uce.userlab.haptics.event.HapticEvent;
import com.uce.userlab.haptics.event.HapticListener;
import java.awt.EventQueue;
import main.MasterControl;
import main.Segment;
import main.tools.ToolSegGen;
import misc.Voxel;
import misc.grid.BitCube;

public class HapticHandler
implements HapticListener {
    private PhantomDevice _pd = null;
    private double[] _use_dims;
    private double[] _start_pos;
    private double[] _pos;
    private double _fact_x;
    private double _fact_y;
    private double _fact_z;
    private double _dim_x;
    private double _dim_y;
    private double _dim_z;
    private int _last_seed_x;
    private int _last_seed_y;
    private int _last_seed_z;
    private boolean _update_started;
    private static double MAGIC_FORCE = 0.3;
    private static boolean FORCE_FEEDBACK = true;

    public boolean set_enabled(boolean enabled) {
        if (enabled) {
            if (this._pd == null) {
                try {
                    this._pd = new PhantomDevice("Default PHANToM");
                }
                catch (DeviceException ex) {
                    System.err.println((Object)ex);
                    System.err.println("Could not initialize HAPTIC device");
                    return false;
                }
            }
            this._use_dims = this._pd.getUsableWorkspaceDimensions();
            int i = 0;
            while (i < 3) {
                int n = i++;
                this._use_dims[n] = this._use_dims[n] * 0.8;
            }
            this._dim_x = MasterControl.get_is().get_dim_x();
            this._dim_y = MasterControl.get_is().get_dim_y();
            this._dim_z = MasterControl.get_is().get_dim_z();
            this._fact_x = this._dim_x / (2.0 * this._use_dims[0]);
            this._fact_y = this._dim_y / (2.0 * this._use_dims[1]);
            this._fact_z = this._dim_z / (2.0 * this._use_dims[2]);
            this._start_pos = null;
            this._last_seed_x = Integer.MAX_VALUE;
            this._last_seed_y = Integer.MAX_VALUE;
            this._last_seed_z = Integer.MAX_VALUE;
            this._update_started = false;
            this._pd.addHapticListener((HapticListener)this);
        } else {
            this._pd.removeHapticListener((HapticListener)this);
        }
        return true;
    }

    public void deviceCallback(final HapticEvent he) {
        if (!EventQueue.isDispatchThread()) {
            if (!this._update_started) {
                this._update_started = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HapticHandler.this.deviceCallback(he);
                    }
                });
            }
        } else {
            int but = this._pd.getCurrentButtons();
            this._pos = this._pd.getCurrentPosition();
            if (this._start_pos == null) {
                this._start_pos = new double[3];
                this._start_pos[0] = this._pos[0];
                this._start_pos[1] = this._pos[1];
                this._start_pos[2] = this._pos[2];
            }
            this._pos[0] = this._start_pos[0] - this._pos[0];
            this._pos[1] = this._start_pos[1] - this._pos[1];
            this._pos[2] = this._start_pos[2] - this._pos[2];
            int seed_x = (int)((this._use_dims[0] + this._pos[0]) * this._fact_x);
            int seed_y = (int)((this._use_dims[1] - this._pos[1]) * this._fact_y);
            int seed_z = (int)((this._use_dims[2] - this._pos[2]) * this._fact_z);
            if (FORCE_FEEDBACK) {
                double[] force = this._pd.getForce();
                if (seed_x < 0) {
                    force[0] = MAGIC_FORCE;
                }
                force[0] = (double)seed_x > this._dim_x - 1.0 ? -MAGIC_FORCE : 0.0;
                if (seed_y < 0) {
                    force[1] = -MAGIC_FORCE;
                }
                force[1] = (double)seed_y > this._dim_y - 1.0 ? MAGIC_FORCE : 0.0;
                if (seed_z < 0) {
                    force[2] = -MAGIC_FORCE;
                }
                force[2] = (double)seed_z > this._dim_z - 1.0 ? MAGIC_FORCE : 0.0;
                this._pd.sendForce(force);
            }
            if ((this._last_seed_x != seed_x || this._last_seed_y != seed_y || this._last_seed_z != seed_z) && (double)seed_x < this._dim_x && (double)seed_y < this._dim_y && (double)seed_z < this._dim_z && seed_x > 0 && seed_y > 0 && seed_z > 0) {
                if (but == 56) {
                    Segment seg = MasterControl.get_is().get_segment(ToolSegGen.TMP_SEG_NAME);
                    BitCube bc = seg.get_bc();
                    int trans_x = seed_x - this._last_seed_x;
                    int trans_y = seed_y - this._last_seed_y;
                    int trans_z = seed_z - this._last_seed_z;
                    if (FORCE_FEEDBACK) {
                        double[] force = this._pd.getForce();
                        if (bc._bb_min[0] + trans_x < 0) {
                            force[0] = MAGIC_FORCE;
                        }
                        force[0] = (double)(bc._bb_max[0] + trans_x) > this._dim_x - 1.0 ? -MAGIC_FORCE : 0.0;
                        if (bc._bb_min[1] + trans_y < 0) {
                            force[1] = -MAGIC_FORCE;
                        }
                        force[1] = (double)(bc._bb_max[1] + trans_y) > this._dim_y - 1.0 ? MAGIC_FORCE : 0.0;
                        if (bc._bb_min[2] + trans_z < 0) {
                            force[2] = -MAGIC_FORCE;
                        }
                        force[2] = (double)(bc._bb_max[2] + trans_z) > this._dim_z - 1.0 ? MAGIC_FORCE : 0.0;
                        this._pd.sendForce(force);
                    }
                    seg.translate(trans_x, trans_y, trans_z);
                }
                MasterControl.get_is().set_seed(new Voxel(seed_x, seed_y, seed_z));
            }
            this._last_seed_x = seed_x;
            this._last_seed_y = seed_y;
            this._last_seed_z = seed_z;
            this._update_started = false;
        }
    }

    public void deviceInput(HapticEvent he) {
    }

    public void deviceManagementError(HapticEvent he, DeviceException de) {
        System.err.println("deviceManagementError: " + he.getMessage());
    }

    public void deviceUpdate(HapticEvent he) {
        System.out.println("deviceUpdate: " + he.getMessage());
    }
}

