/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.vecmath.Vector3d;
import loader.VolumeDataLoader;
import main.Message;
import main.Segment;
import main.VoxelCubeHistogram;
import main.tools.ToolSegGen;
import misc.AxisAlignedBoundingBox;
import misc.Voxel;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;
import misc.geomarker.GeoMarker;
import misc.grid.AbstractMutableRegularGrid3i;
import misc.grid.BitCube;
import misc.grid.MutableRegularGrid3i;
import misc.grid.RegularGrid3i;
import misc.grid.VoxelCube;
import misc.grid.VoxelCube32Pack16;
import misc.grid.VoxelCube32Pack8;
import misc.messages.YObservable;
import misc.messages.YObserver;
import threads.RSThread;

public final class ImageStack
extends YObservable
implements YObserver {
    public static final int STATE_PRE_LOAD = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public static final int STATE_RESIZING = 3;
    public static final int STATE_FILTERING = 4;
    public static final int STATE_SEGMENTING = 5;
    public static final int M_CLEAR = Message.register_message("ImageStack Clear");
    public static final int M_LOADING_START = Message.register_message("ImageStack Loading Started");
    public static final int M_LOADING_FIRST_IMAGE = Message.register_message("ImageStack FirstImageLoaded");
    public static final int M_LOADING_NEW_IMAGE = Message.register_message("ImageStack NewImageLoaded");
    public static final int M_LOADING_END = Message.register_message("ImageStack Loading Ended");
    public static final int M_NEW_SEGMENT = Message.register_message("ImageStack NewSegemt");
    public static final int M_DEL_SEGMENT = Message.register_message("ImageStack DeleteSegemt");
    public static final int M_NEW_MARKER = Message.register_message("ImageStack NewMarker");
    public static final int M_DEL_MARKER = Message.register_message("ImageStack DeleteMarker");
    public static final int M_RESIZE_START = Message.register_message("ImageStack ResizeStart");
    public static final int M_RESIZE_STEP = Message.register_message("ImageStack ResizeStep");
    public static final int M_RESIZE_END = Message.register_message("ImageStack ResizeEnd");
    public static final int M_FILTER3D_START = Message.register_message("ImageStack FilterStart");
    public static final int M_FILTER3D_STEP = Message.register_message("ImageStack FilterStep");
    public static final int M_FILTER3D_END = Message.register_message("ImageStack FilterEnd");
    public static final int M_VC_SET = Message.register_message("ImageStack VC has been set");
    public static final int M_VC_SPACING_CHANGED = Message.register_message("ImageStack Spacing Changed");
    public static final int M_VC_CHANGED = Message.register_message("ImageStack VC Changed");
    public static final int M_SEG_START = Message.register_message("ImageStack SegStart");
    public static final int M_SEG_END = Message.register_message("ImageStack SegEnd");
    public static final int M_SELECTXYZ = Message.register_message("ImageStack SelectXYZ");
    private MutableRegularGrid3i _vc;
    private final VoxelCubeHistogram _vch;
    private int _state;
    private DiFile[] _dicom_files = null;
    private final Segment _tmp_seg;
    private String _dirname;
    private LinkedList<Voxel> _seeds;
    private final HashMap<String, Segment> _seg_map = new HashMap();
    private final LinkedList<Segment> _seg_list = new LinkedList();
    private final HashMap<String, GeoMarker> _marker_map = new HashMap();
    private final LinkedList<GeoMarker> _marker_list = new LinkedList();
    private final AxisAlignedBoundingBox _bounding_box;
    private final DICOMInfo _di_info;

    public ImageStack() {
        this._seeds = new LinkedList();
        this._vc = new VoxelCube(0, 0, 0, 0);
        this._dirname = new String();
        this._tmp_seg = this.create_segment(ToolSegGen.TMP_SEG_NAME, 0xFF0000);
        this._bounding_box = new AxisAlignedBoundingBox();
        this._di_info = new DICOMInfo();
        this.init();
        this._vch = new VoxelCubeHistogram(this);
    }

    public AxisAlignedBoundingBox get_bb() {
        return this._bounding_box;
    }

    private final void init() {
        this._seg_map.clear();
        this._seg_map.put(ToolSegGen.TMP_SEG_NAME, this._tmp_seg);
        this._dicom_files = null;
        this._vc = new VoxelCube(0, 0, 0, 0);
        this._seeds = new LinkedList();
        this._dirname = new String();
        this._di_info._pixel_spacing[2] = 1.0;
        this._di_info._pixel_spacing[1] = 1.0;
        this._di_info._pixel_spacing[0] = 1.0;
        this._di_info._max_voxel_value = 10;
    }

    public final void clear() {
        this._di_info._intercept = 0;
        this._di_info._slope = 1;
        this._di_info._pixel_spacing[0] = 1.0;
        this._di_info._pixel_spacing[1] = 1.0;
        this._di_info._pixel_spacing[2] = 1.0;
        this._di_info._iop_map[0] = 0;
        this._di_info._iop_map[1] = 1;
        this._di_info._iop_map[2] = 2;
        this._di_info._w_width = 256;
        this._di_info._w_center = 128;
        this._di_info._pixel_spacing[2] = 1.0;
        this._di_info._pixel_spacing[1] = 1.0;
        this._di_info._pixel_spacing[0] = 1.0;
        this._di_info._max_voxel_value = 255;
        LinkedList<Segment> segs = new LinkedList<Segment>(this._seg_map.values());
        for (Segment s : segs) {
            if (s == this._tmp_seg) continue;
            this.delete_segment(s);
        }
        this._dicom_files = null;
        this._state = 0;
        this.setChanged();
        this.notifyObservers(new Message(M_CLEAR, null));
    }

    private DiFile create_fake_dicom() {
        DiFile df = new DiFile(DiFile.ENDIAN_LITTLE, DiFile.VR_EXPLICIT);
        HashMap<Integer, DiDataElement> data_elements = df.get_data_elements();
        DiDataElement de = new DiDataElement(32, 13, 21833, new String("100").getBytes());
        data_elements.put(de.get_tag(), de);
        de = new DiDataElement(32, 14, 21833, new String("101").getBytes());
        data_elements.put(de.get_tag(), de);
        return df;
    }

    public void create_empty(int dim_x, int dim_y, int dim_z, double sp_x, double sp_y, double sp_z, int bits) {
        DiFile df;
        this.clear();
        this._di_info._max_voxel_value = 1 << bits;
        this.set_state(1);
        this.send_message(M_LOADING_START, null);
        this.set_grid(new VoxelCube(dim_x, dim_y, dim_z));
        this._di_info._pixel_spacing[0] = sp_x;
        this._di_info._pixel_spacing[1] = sp_y;
        this._di_info._pixel_spacing[2] = sp_z;
        this.send_message(M_VC_SPACING_CHANGED, null);
        this._dicom_files = new DiFile[dim_z];
        this._dicom_files[0] = df = this.create_fake_dicom();
        this.send_message(M_LOADING_FIRST_IMAGE, null);
        int i = 0;
        while (i < this._dicom_files.length) {
            this._dicom_files[i] = df = this.create_fake_dicom();
            this.send_message(M_LOADING_NEW_IMAGE, null);
            ++i;
        }
        this.set_state(2);
        this.send_message(M_LOADING_END, null);
    }

    public Segment create_segment(String name, int color) {
        Segment seg;
        if (this._seg_map.containsKey(name)) {
            seg = null;
        } else {
            seg = new Segment(name, this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z());
            seg.set_color(color);
            this._seg_map.put(name, seg);
            this._seg_list.add(seg);
            this.setChanged();
            this.notifyObservers(new Message(M_NEW_SEGMENT, seg));
            seg.addObserver(this, "ImageStack::create_segment");
        }
        return seg;
    }

    public void delete_segment(Segment seg) {
        seg.deleteObserver(this);
        this._seg_map.remove(seg.get_name());
        this._seg_list.remove(seg);
        this.setChanged();
        this.notifyObservers(new Message(M_DEL_SEGMENT, seg));
    }

    public LinkedList<Segment> get_segment_list() {
        return this._seg_list;
    }

    public boolean add_marker(GeoMarker gm) {
        boolean success;
        if (this._marker_map.containsKey(gm.get_label())) {
            success = false;
        } else {
            this._marker_map.put(gm.get_label(), gm);
            this._marker_list.add(gm);
            this.setChanged();
            this.notifyObservers(new Message(M_NEW_MARKER, gm));
            success = true;
        }
        return success;
    }

    public void del_marker(GeoMarker gm) {
        this.notifyObservers(new Message(M_DEL_MARKER, gm));
        this._marker_map.remove(gm.get_label());
        this._marker_list.remove(gm);
    }

    public GeoMarker get_marker(String label) {
        return this._marker_map.get(label);
    }

    public Set<String> get_marker_names() {
        return this._marker_map.keySet();
    }

    public LinkedList<GeoMarker> get_marker_list() {
        return this._marker_list;
    }

    public void resize(final double dxfac, final double dyfac, final double dzfac) {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                ImageStack.this._state = 3;
                int new_x_size = (int)Math.round(dxfac * (double)ImageStack.this._vc.get_dim_x());
                int new_y_size = (int)Math.round(dyfac * (double)ImageStack.this._vc.get_dim_y());
                int new_z_size = (int)Math.round(dzfac * (double)ImageStack.this._vc.get_dim_z());
                ImageStack.this.setChanged();
                ImageStack.this.notifyObservers(new Message(M_RESIZE_START, null));
                double mc_x_size = (double)ImageStack.this._vc.get_dim_x() / (double)new_x_size;
                double mc_y_size = (double)ImageStack.this._vc.get_dim_y() / (double)new_y_size;
                double mc_z_size = (double)ImageStack.this._vc.get_dim_z() / (double)new_z_size;
                this.init_progress_measure("resizing ...", 0, new_x_size - 1, 0);
                VoxelCube scale = new VoxelCube(new_x_size, new_y_size, new_z_size);
                int x = 0;
                while (x < new_x_size) {
                    int y = 0;
                    while (y < new_y_size) {
                        int z = 0;
                        while (z < new_z_size) {
                            int new_value = 0;
                            int start_x = (int)Math.floor((double)x * mc_x_size);
                            int start_y = (int)Math.floor((double)y * mc_y_size);
                            int start_z = (int)Math.floor((double)z * mc_z_size);
                            int end_x = (int)Math.ceil((double)(x + 1) * mc_x_size);
                            int end_y = (int)Math.ceil((double)(y + 1) * mc_y_size);
                            int end_z = (int)Math.ceil((double)(z + 1) * mc_z_size);
                            int cube_size = (end_x - start_x) * (end_y - start_y) * (end_z - start_z);
                            int mcx = start_x;
                            while (mcx < end_x) {
                                int mcy = start_y;
                                while (mcy < end_y) {
                                    int mcz = start_z;
                                    while (mcz < end_z) {
                                        new_value += ImageStack.this._vc.get(mcx, mcy, mcz);
                                        ++mcz;
                                    }
                                    ++mcy;
                                }
                                ++mcx;
                            }
                            scale.set(x, y, z, new_value /= cube_size);
                            ++z;
                        }
                        ++y;
                    }
                    this.set_progress_val(x + 1);
                    ++x;
                }
                BitCube old_tmp_bc = ImageStack.this._tmp_seg.get_bc();
                ImageStack.this.set_grid(scale);
                for (Segment seg : ImageStack.this._seg_list) {
                    this.set_progress_val(0);
                    BitCube bc_scale = new BitCube(new_x_size, new_y_size, new_z_size);
                    BitCube bc_old = seg == ImageStack.this._tmp_seg ? old_tmp_bc : seg.get_bc();
                    int x2 = 0;
                    while (x2 < new_x_size) {
                        int y = 0;
                        while (y < new_y_size) {
                            int z = 0;
                            while (z < new_z_size) {
                                int new_value = 0;
                                int start_x = (int)Math.floor((double)x2 * mc_x_size);
                                int start_y = (int)Math.floor((double)y * mc_y_size);
                                int start_z = (int)Math.floor((double)z * mc_z_size);
                                int end_x = (int)Math.ceil((double)(x2 + 1) * mc_x_size);
                                int end_y = (int)Math.ceil((double)(y + 1) * mc_y_size);
                                int end_z = (int)Math.ceil((double)(z + 1) * mc_z_size);
                                int cube_size = (end_x - start_x) * (end_y - start_y) * (end_z - start_z);
                                int mcx = start_x;
                                while (mcx < end_x) {
                                    int mcy = start_y;
                                    while (mcy < end_y) {
                                        int mcz = start_z;
                                        while (mcz < end_z) {
                                            if (bc_old.getXYZ(mcx, mcy, mcz)) {
                                                ++new_value;
                                            }
                                            ++mcz;
                                        }
                                        ++mcy;
                                    }
                                    ++mcx;
                                }
                                bc_scale.setXYZ(x2, y, z, new_value >= cube_size / 2);
                                ++z;
                            }
                            ++y;
                        }
                        this.set_progress_val(x2);
                        ++x2;
                    }
                    seg.set_bc(bc_scale);
                }
                ((ImageStack)ImageStack.this)._di_info._pixel_spacing[0] = ((ImageStack)ImageStack.this)._di_info._pixel_spacing[0] / dxfac;
                ((ImageStack)ImageStack.this)._di_info._pixel_spacing[1] = ((ImageStack)ImageStack.this)._di_info._pixel_spacing[1] / dyfac;
                ((ImageStack)ImageStack.this)._di_info._pixel_spacing[2] = ((ImageStack)ImageStack.this)._di_info._pixel_spacing[2] / dzfac;
                ImageStack.this._bounding_box.set_box(0, 0, 0, ImageStack.this._vc.get_dim_x(), ImageStack.this._vc.get_dim_y(), ImageStack.this._vc.get_dim_z());
                ImageStack.this._state = 2;
                ImageStack.this.setChanged();
                ImageStack.this.notifyObservers(new Message(M_RESIZE_END, null));
            }
        };
        t.start();
    }

    public void load(final VolumeDataLoader vdl) {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                vdl.load(this);
            }
        };
        t.start();
    }

    public String get_dir_name() {
        return this._dirname;
    }

    public void set_dir_name(String dir_name) {
        this._dirname = new String(dir_name);
    }

    public DiFile get_dicom_file(int i) {
        if (i < this._dicom_files.length) {
            return this._dicom_files[i];
        }
        return null;
    }

    public int get_dicom_file_number() {
        return this._dicom_files.length;
    }

    public Segment get_segment(String name) {
        return this._seg_map.get(name);
    }

    public int get_segment_number() {
        return this._seg_map.size();
    }

    public int get_dim_x() {
        return this._vc.get_dim_x();
    }

    public int get_dim_y() {
        return this._vc.get_dim_y();
    }

    public int get_dim_z() {
        return this._vc.get_dim_z();
    }

    public int get_slope() {
        return this._di_info._slope;
    }

    public int get_intercept() {
        return this._di_info._intercept;
    }

    public int get_grey_window_width() {
        return this._di_info._w_width;
    }

    public int get_grey_window_center() {
        return this._di_info._w_center;
    }

    public int get_voxel_value_range() {
        return this._di_info._max_voxel_value;
    }

    public int get_state() {
        return this._state;
    }

    public int[] get_iop_inc() {
        return this._di_info._iop_inc;
    }

    public int[] get_iop_start() {
        return this._di_info._iop_start;
    }

    public int[] get_iop_map() {
        return this._di_info._iop_map;
    }

    public double get_x_spacing() {
        return this._di_info._pixel_spacing[0];
    }

    public double get_y_spacing() {
        return this._di_info._pixel_spacing[1];
    }

    public double get_z_spacing() {
        return this._di_info._pixel_spacing[2];
    }

    public double get_max_spacing() {
        return Math.max(this._di_info._pixel_spacing[0], Math.max(this._di_info._pixel_spacing[1], this._di_info._pixel_spacing[2]));
    }

    public double get_min_spacing() {
        return Math.min(this._di_info._pixel_spacing[0], Math.min(this._di_info._pixel_spacing[1], this._di_info._pixel_spacing[2]));
    }

    public String get_sop_media_class() {
        return this._di_info._sop_media_class;
    }

    public void add_or_remove_seed(Voxel v) {
        boolean gotcha = false;
        ListIterator vi = this._seeds.listIterator();
        while (vi.hasNext()) {
            Voxel seed = (Voxel)vi.next();
            if (!seed.equals(v)) continue;
            vi.remove();
            gotcha = true;
            break;
        }
        if (!gotcha) {
            this._seeds.add(v);
        }
        this.setChanged();
        this.notifyObservers(new Message(M_SELECTXYZ, v));
    }

    public HashMap<String, Segment> get_seg_map() {
        return this._seg_map;
    }

    public void set_seed(Voxel v) {
        this._seeds.clear();
        this._seeds.add(v);
        this.setChanged();
        this.notifyObservers(new Message(M_SELECTXYZ, v));
    }

    public LinkedList<Voxel> get_seeds() {
        return this._seeds;
    }

    public RegularGrid3i get_voxel_cube() {
        return this._vc;
    }

    public MutableRegularGrid3i get_mutable_voxel_cube() {
        return this._vc;
    }

    public void send_message(Message m) {
        this.setChanged();
        this.notifyObservers(m);
    }

    public String get_study_instance_uid() {
        return this._dicom_files[0].get_study_instance_uid();
    }

    public String get_series_instance_uid() {
        return this._dicom_files[0].get_series_instance_uid();
    }

    @Override
    public void update(YObservable o, Message arg) {
        Message m = arg;
        if (arg instanceof Message && m._type == Segment.M_SEG_NAME_CHANGED) {
            Segment seg = (Segment)o;
            String old_name = (String)m._obj;
            String new_name = seg.get_name();
            this._seg_map.remove(old_name);
            this._seg_map.put(new_name, seg);
        }
    }

    public static MutableRegularGrid3i create_voxel_cube_instance(int dim_x, int dim_y, int dim_z) {
        long voxel_number = (long)dim_x * (long)dim_y * (long)dim_z;
        AbstractMutableRegularGrid3i vc = (double)(voxel_number * 4L) > 0.75 * (double)Runtime.getRuntime().maxMemory() ? new VoxelCube32Pack16(dim_x, dim_y, dim_z) : (voxel_number >= 0x7FFFFFF5L ? new VoxelCube32Pack8(dim_x, dim_y, dim_z) : new VoxelCube(dim_x, dim_y, dim_z));
        return vc;
    }

    public VoxelCubeHistogram get_vch() {
        return this._vch;
    }

    public int get_raw_value(int voxel_val) {
        return this._di_info._pixel_representation_signed ? voxel_val - this._di_info._max_voxel_value / 2 : voxel_val;
    }

    public int get_voxel_value(int raw_val) {
        return this._di_info._pixel_representation_signed ? raw_val + this._di_info._max_voxel_value / 2 : raw_val;
    }

    public double get_raw_value(double voxel_val) {
        return this._di_info._pixel_representation_signed ? voxel_val - (double)(this._di_info._max_voxel_value / 2) : voxel_val;
    }

    public int get_scaled_value(int voxel_val) {
        return this.get_raw_value(voxel_val) * this._di_info._slope + this._di_info._intercept;
    }

    public double get_scaled_value(double voxel_val) {
        return this.get_raw_value(voxel_val) * (double)this._di_info._slope + (double)this._di_info._intercept;
    }

    public int calc_undo_dicom_rescale(int val) {
        return (val - this._di_info._intercept) / this._di_info._slope;
    }

    public void set_di_files(DiFile[] files) {
        this._dicom_files = files;
    }

    public void set_state(int state) {
        this._state = state;
    }

    public void send_message(int type, Object arg) {
        this.setChanged();
        this.notifyObservers(new Message(type, arg));
    }

    public DICOMInfo get_dicom_info() {
        return this._di_info;
    }

    public void set_grid(MutableRegularGrid3i grid) {
        MessageDimChangedInfo info = new MessageDimChangedInfo(this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z(), grid.get_dim_x(), grid.get_dim_y(), grid.get_dim_z());
        this._vc = grid;
        this._tmp_seg.set_bc(new BitCube(this._vc.get_dim_x(), this._vc.get_dim_y(), this._vc.get_dim_z()));
        this._bounding_box.set_box(0, 0, 0, this._vc.get_dim_x() - 1, this._vc.get_dim_y() - 1, this._vc.get_dim_z() - 1);
        this.send_message(M_VC_SET, info);
    }

    public Vector3d get_iop0() {
        return this._di_info._iop0;
    }

    public Vector3d get_iop1() {
        return this._di_info._iop1;
    }

    public Vector3d get_iop2() {
        return this._di_info._iop2;
    }

    public boolean is_regular() {
        return this._di_info._is_regular;
    }

    public static class DICOMInfo {
        public int _intercept;
        public int _slope;
        public int _w_width;
        public int _w_center;
        public int _max_voxel_value;
        public final double[] _pixel_spacing = new double[3];
        public String _sop_media_class;
        public boolean _pixel_representation_signed;
        public final int[] _iop_map = new int[3];
        public final int[] _iop_inc = new int[3];
        public final int[] _iop_start = new int[3];
        public final Vector3d _iop0 = new Vector3d(1.0, 0.0, 0.0);
        public final Vector3d _iop1 = new Vector3d(0.0, 1.0, 0.0);
        public final Vector3d _iop2 = new Vector3d(0.0, 0.0, 1.0);
        public boolean _is_regular = true;
    }

    public static class MessageDimChangedInfo {
        public int _dim_x_old;
        public int _dim_y_old;
        public int _dim_z_old;
        public int _dim_x_new;
        public int _dim_y_new;
        public int _dim_z_new;

        public MessageDimChangedInfo(int dim_x_old, int dim_y_old, int dim_z_old, int dim_x_new, int dim_y_new, int dim_z_new) {
            this._dim_x_old = dim_x_old;
            this._dim_y_old = dim_y_old;
            this._dim_z_old = dim_z_old;
            this._dim_x_new = dim_x_new;
            this._dim_y_new = dim_y_new;
            this._dim_z_new = dim_z_new;
        }

        public String toString() {
            return "(" + this._dim_x_old + "," + this._dim_y_old + "," + this._dim_z_old + ") -> (" + this._dim_x_new + "," + this._dim_y_new + "," + this._dim_z_new + ")";
        }
    }
}

