/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import main.ImageStack;
import main.MasterControl;
import settings.Settings;
import settings.SettingsOwner;

public class Magnifier
extends JPanel
implements SettingsOwner {
    public static final String OPT_SHOW_ALL = Settings.register_bool_opt(Magnifier.class, "show all", "When set to false, only the original (background) data is magnified", true);
    public static final String OPT_ZOOM = Settings.register_int_opt(Magnifier.class, "zoom", "Zoom level, the lower the value the higher the zoom (2*x+1 pixels are shown in x and y)", 3);
    private static String EMPTY_STRING = "\n";
    private static Magnifier _instance;
    private static Image _img;
    private static Image _img_bg;
    private static Image _img_all;
    private static int _x;
    private static int _y;
    private static int _pixel_dim;
    private static PicturePanel _pp;
    private static JTextArea _jta_info;

    public Magnifier() {
        _pp = new PicturePanel();
        _jta_info = new JTextArea(EMPTY_STRING);
        _jta_info.setEditable(false);
        _jta_info.setOpaque(false);
        _jta_info.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        _img_all = null;
        _img_bg = null;
        _img = null;
        _pixel_dim = Settings.get_int_option(Magnifier.class, OPT_ZOOM);
        _instance = this;
        this.setLayout(new BorderLayout());
        this.add((Component)_pp, "North");
        this.add((Component)_jta_info, "Center");
        Settings.register_owner(this);
    }

    public static void magnify(int x, int y, int vc_x, int vc_y, int vc_z) {
        ImageStack is = MasterControl.get_is();
        if (vc_x >= 0 && vc_y >= 0 && vc_z >= 0 && vc_x < is.get_dim_x() && vc_y < is.get_dim_y() && vc_z < is.get_dim_z()) {
            int vc_value = is.get_voxel_cube().get(vc_x, vc_y, vc_z);
            int ov = is.get_raw_value(vc_value);
            int sv = is.get_scaled_value(vc_value);
            _jta_info.setText(" (" + vc_x + ", " + vc_y + ", " + vc_z + ")\n" + " ov = " + ov + "\n" + " sv = " + sv);
            _x = x;
            _y = y;
            _pp.repaint();
        } else {
            _jta_info.setText(EMPTY_STRING);
        }
    }

    private static void update_image() {
        _img = Settings.get_bool_option(Magnifier.class, OPT_SHOW_ALL) != false ? _img_all : _img_bg;
    }

    public static void set_image(Image img_bg, Image img_all) {
        _img_bg = img_bg;
        _img_all = img_all;
        Magnifier.update_image();
        if (img_bg == null) {
            _jta_info.setText(EMPTY_STRING);
        }
        _pp.repaint();
    }

    @Override
    public final String get_name() {
        return "Magnifier";
    }

    @Override
    public final void settings_changed(Object obj, String opt_name, Object opt) {
        if (opt_name == OPT_SHOW_ALL) {
            Magnifier.update_image();
        }
        if (opt_name == OPT_ZOOM) {
            _pixel_dim = Settings.get_int_option(Magnifier.class, OPT_ZOOM);
        }
    }

    private class PicturePanel
    extends JPanel {
        public static final int WINDOWDIM = 100;

        public PicturePanel() {
            Dimension dim = new Dimension(100, 100);
            this.setPreferredSize(dim);
            this.setMinimumSize(dim);
            this.setMaximumSize(dim);
        }

        @Override
        public final void paint(Graphics g) {
            g.setColor(Color.black);
            g.fillRect(0, 0, 100, 100);
            if (_img != null) {
                g.drawImage(_img, 0, 0, 100, 100, _x - _pixel_dim, _y - _pixel_dim, _x + _pixel_dim + 1, _y + _pixel_dim + 1, Color.red, _instance);
                g.setColor(Color.white);
                g.drawRect(50 - _pixel_dim / 2, 50 - _pixel_dim / 2, _pixel_dim, _pixel_dim);
            }
        }
    }
}

