/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import jgridmaker.GMPanel;
import main.Global;
import main.Magnifier;
import main.StatusBar;
import main.ThreadStatusWindow;
import main.ToolPane;
import main.view2d.Viewport2d;
import main.view3d.Viewport3d;

public final class MainWindow
extends JFrame {
    private final JPanel _tool_panel;
    private final JSplitPane _v_split_pane;
    private final JSplitPane _h_split_pane;
    private final Viewport3d _v3d;
    JFrame _screen_window;

    public MainWindow(String title, Viewport2d v2d, Viewport3d v3d, ToolPane tools, JMenuBar menu_bar, StatusBar status_bar) {
        super(title);
        this.setIconImage(Global.ICON_IMAGE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this._tool_panel = new JPanel();
        this._tool_panel.setMinimumSize(new Dimension(5, 5));
        this._tool_panel.setMaximumSize(new Dimension(0, 300));
        this._tool_panel.setPreferredSize(new Dimension(0, 300));
        this._tool_panel.setLayout(new BorderLayout());
        this._tool_panel.add((Component)tools, "Center");
        GMPanel right_panel = new GMPanel();
        right_panel.add("magnifier", (JComponent)new Magnifier());
        right_panel.add("thread_status", (JComponent)ThreadStatusWindow.get_instance());
        right_panel.set_layout("<table width='100%' height='100%'>  <tr height='1%'>    <td>::magnifier::</td>  </tr><tr anchor='north'>    <td fill='horizontal'>::thread_status::</td>  </tr></table>");
        right_panel.setPreferredSize(new Dimension(125, 0));
        this._tool_panel.add((Component)right_panel, "East");
        this._h_split_pane = new JSplitPane(1, v2d, v3d);
        this._v_split_pane = new JSplitPane(0, this._h_split_pane, this._tool_panel);
        this._h_split_pane.setContinuousLayout(true);
        this._v_split_pane.setContinuousLayout(true);
        this._h_split_pane.setResizeWeight(0.0);
        this._v_split_pane.setResizeWeight(1.0);
        this._v_split_pane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this._v_split_pane, "Center");
        this.add((Component)((Object)status_bar), "South");
        this.setJMenuBar(menu_bar);
        this.pack();
        this._v3d = v3d;
        this._screen_window = null;
    }

    public void build_layout(boolean fullscreen) {
        if (fullscreen) {
            this._h_split_pane.remove(this._v3d);
            if (this._screen_window == null) {
                this._screen_window = new JFrame();
                this._screen_window.setUndecorated(true);
                Dimension screen_dim = Toolkit.getDefaultToolkit().getScreenSize();
                this._screen_window.setPreferredSize(screen_dim);
                this._screen_window.setMinimumSize(screen_dim);
                this._screen_window.setLayout(new BorderLayout());
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

                    @Override
                    protected void dispatchEvent(AWTEvent event) {
                        KeyEvent keyEvent;
                        if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getKeyCode() == 27) {
                            MainWindow.this.build_layout(false);
                            MainWindow.this._v3d.set_full_screen(false);
                        }
                        super.dispatchEvent(event);
                    }
                });
            }
            this._screen_window.add((Component)this._v3d, "Center");
            this._screen_window.setVisible(true);
        } else {
            this._screen_window.remove(this._v3d);
            this._screen_window.setVisible(false);
            this._h_split_pane.setRightComponent(this._v3d);
        }
    }
}

