/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashMap;
import java.util.LinkedList;
import main.ImageStack;
import main.MainWindow;
import main.MenuBar;
import main.StatusBar;
import main.ToolPane;
import main.YDialogs;
import main.YaDiV;
import main.view2d.Viewport2d;
import main.view3d.LightSettings;
import main.view3d.Viewport3d;
import misc.StopWatch;
import yplugins.YModule;
import yplugins.YModuleType;

public final class MasterControl {
    public static String _name = "YaDiV - Yet Another Dicom Viewer";
    public static String _version = "1.0 - beta 5.0";
    public static String _timestamp = "28. August 2012";
    private static MainWindow _win;
    private static Viewport2d _v2d;
    private static Viewport3d _v3d;
    private static ToolPane _toolpane;
    private static MenuBar _menubar;
    private static StatusBar _status_bar;
    private static ImageStack _is;
    private static LightSettings _lights;
    private static final HashMap<YModuleType, LinkedList<YModule>> _modules;

    static {
        _modules = new HashMap();
        _is = new ImageStack();
        YModuleType[] yModuleTypeArray = YModuleType.values();
        int n = yModuleTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            YModuleType t = yModuleTypeArray[n2];
            _modules.put(t, new LinkedList());
            ++n2;
        }
    }

    private MasterControl() {
    }

    public static final void create_interface() {
        StopWatch sw = new StopWatch(true);
        _lights = new LightSettings();
        _v2d = new Viewport2d();
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "View2D creation    : " + sw);
        sw.reset();
        _v3d = new Viewport3d();
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "View3D creation    : " + sw);
        sw.reset();
        _toolpane = new ToolPane();
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "ToolPane creation  : " + sw);
        sw.reset();
        _menubar = new MenuBar();
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "MenuBar creation   : " + sw);
        sw.reset();
        _status_bar = StatusBar.get_instance();
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "StatusBar creation : " + sw);
        sw.reset();
        YDialogs._win = _win = new MainWindow(String.valueOf(_name) + " - " + _version + " (" + _timestamp + ")", _v2d, _v3d, _toolpane, _menubar, _status_bar);
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "MainWindow creation: " + sw);
        _win.setVisible(true);
    }

    public static final ImageStack get_is() {
        return _is;
    }

    public static final StatusBar get_status_bar() {
        return _status_bar;
    }

    public static final Viewport2d get_v2d() {
        return _v2d;
    }

    public static final Viewport3d get_v3d() {
        return _v3d;
    }

    public static final MainWindow get_window() {
        return _win;
    }

    public static LightSettings get_lights() {
        return _lights;
    }

    public static void register_module(YModule module, YModuleType type) {
        LinkedList<YModule> list = _modules.get((Object)type);
        list.add(module);
        YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, String.valueOf(module.get_module_name()) + " registered at MasterControl");
    }

    public static LinkedList<YModule> get_modules(YModuleType type) {
        return _modules.get((Object)type);
    }
}

