/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui.CreateEmptyVolumeDialog;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import loader.OpenDICOMDialog;
import loader.OpenImagesDialog;
import loader.OpenREKDialog;
import loader.QuickLoadInfo;
import loader.QuickLoadStorage;
import loader.VolumeDataLoader;
import main.AboutWindow;
import main.DicomInfoWindow;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.SysInfoWindow;
import main.YDialogs;
import main.YaDiV;
import main.view2d.Viewport2dModel;
import main.view3d.Viewport3d;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import renderer.BBoxRenderer3d;
import renderer.BGImageRenderer2d;
import renderer.SegRenderer2d;
import renderer.SegRenderer3d;
import renderer.Tex2Renderer3d;
import settings.JBoolOptionMenuItem;
import settings.Settings;
import settings.SettingsListener;
import threads.RSThread;

public final class MenuBar
extends JMenuBar
implements YObserverWantsAWTThread,
SettingsListener {
    public static int MAX_MENU_FILE_NAME_LENGTH = 30;
    public static int OPEN_RECENT_STORAGE_NUMBER = 8;
    private DicomInfoWindow _dicom_info_window;
    private SysInfoWindow _gfx_info_window;
    private AboutWindow _about_window;
    private final JMenu _menu_file;
    private final JMenu _menu2d;
    private final JMenu _menu3d;
    private final JMenu _menu_misc;
    private final JMenuItem _no_entries2d;
    private final JMenuItem _no_entries3d;
    private final ArrayList<JCheckBoxMenuItem> _seg_items2d;
    private final ArrayList<JCheckBoxMenuItem> _seg_items3d;
    private final ArrayList<JMenuItem> _show_after_load_items;
    private final ArrayList<JMenuItem> _hide_during_load_items;
    private final QuickLoadStorage _ors;
    private final JRadioButtonMenuItem _jrbmi_transversal;
    private final JRadioButtonMenuItem _jrbmi_sagittal;
    private final JRadioButtonMenuItem _jrbmi_frontal;
    private OpenDICOMDialog _odd = null;
    private final ActionListener openDICOMListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MenuBar.this._odd == null) {
                MenuBar.this._odd = new OpenDICOMDialog(Settings.get_str_option(YaDiV.class, YaDiV.OPT_DEF_DIR));
            }
            MenuBar.this._odd.setVisible(true);
        }
    };
    private final ActionListener createEmptyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CreateEmptyVolumeDialog win = new CreateEmptyVolumeDialog();
            win.setVisible(true);
        }
    };
    private final ActionListener createFromSegment = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            YDialogs._seg_file_chooser.setMultiSelectionEnabled(false);
            if (YDialogs._seg_file_chooser.showOpenDialog(null) == 0) {
                final File seg_file = YDialogs._seg_file_chooser.getSelectedFile();
                final Segment load_seg = new Segment("loading", 10, 10, 10);
                RSThread rst_loading = new RSThread(null, true, false){

                    @Override
                    public void my_run() {
                        this.init_progress_measure("creating volume from segment ...", 0, 100, 0);
                        if (seg_file.exists() && !seg_file.canRead()) {
                            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "could not read file " + seg_file.getAbsolutePath());
                        } else {
                            ImageStack is = MasterControl.get_is();
                            RegularGrid3i vc = is.get_voxel_cube();
                            load_seg.addObserver(this, "observing load status");
                            load_seg.load_seg(seg_file);
                            load_seg.deleteObserver(this);
                            BitCube bc = load_seg.get_bc();
                            if (bc.get_dim_x() == vc.get_dim_x() && bc.get_dim_y() == vc.get_dim_y() && bc.get_dim_z() == vc.get_dim_z()) {
                                Segment seg = is.create_segment(load_seg.get_name(), load_seg.get_color());
                                seg.set_bc(load_seg.get_bc());
                            }
                        }
                    }

                    @Override
                    public void update(YObservable yo, Message m) {
                        if (m._type == Segment.M_SEG_HEADER_LOADED) {
                            Segment seg = (Segment)yo;
                            this.set_progress_max(seg.get_bc().get_dim_z());
                        } else if (m._type == Segment.M_SEG_SLICE_LOADED) {
                            this.inc_progress_value(1);
                        } else if (m._type == Segment.M_SEG_LOADING_END) {
                            MasterControl.get_is().create_empty(load_seg.get_bc().get_dim_x(), load_seg.get_bc().get_dim_y(), load_seg.get_bc().get_dim_z(), 1.0, 1.0, 1.0, 8);
                            Segment seg = MasterControl.get_is().create_segment(load_seg.get_name(), load_seg.get_color());
                            seg.set_bc(load_seg.get_bc());
                        }
                    }
                };
                rst_loading.start();
            }
        }
    };
    private final ActionListener importImagesListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            OpenImagesDialog dialog = new OpenImagesDialog(Settings.get_str_option(YaDiV.class, YaDiV.OPT_DEF_IMPORT_DIR));
            dialog.setVisible(true);
        }
    };
    private final ActionListener importREKListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            OpenREKDialog dialog = new OpenREKDialog(Settings.get_str_option(YaDiV.class, YaDiV.OPT_DEF_IMPORT_DIR));
            dialog.setVisible(true);
        }
    };
    private final ActionListener quickLoadListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int num = Integer.parseInt(event.getActionCommand().substring(0, 1));
            QuickLoadInfo qli = MenuBar.this._ors.get_qli(num - 1);
            ImageStack is = MasterControl.get_is();
            qli.load();
            VolumeDataLoader vdl = qli.get_type().get_loader(is, qli);
            is.load(vdl);
        }
    };
    private final ActionListener saveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    };
    private final ActionListener saveAsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Not implemented yet ...");
        }
    };
    private final ActionListener showDicomInfoListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MenuBar.this._dicom_info_window == null) {
                MenuBar.this._dicom_info_window = new DicomInfoWindow();
            }
            if (!MenuBar.this._dicom_info_window.isVisible()) {
                MenuBar.this._dicom_info_window.setVisible(true);
            }
        }
    };
    private final ActionListener fullScreen = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            MasterControl.get_window().build_layout(true);
        }
    };
    private final ActionListener showSysInfoListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MenuBar.this._gfx_info_window == null) {
                MenuBar.this._gfx_info_window = new SysInfoWindow();
            }
            if (!MenuBar.this._gfx_info_window.isVisible()) {
                MenuBar.this._gfx_info_window.setVisible(true);
            }
        }
    };
    private final ActionListener showFirstStepsListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                File fi = new File("docu/YaDiV_first_steps.html");
                Desktop.getDesktop().browse(fi.toURI());
            }
            catch (Exception ex) {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, ex.toString());
            }
        }
    };
    private final ActionListener showAboutListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MenuBar.this._about_window == null) {
                MenuBar.this._about_window = new AboutWindow();
            }
            if (!MenuBar.this._about_window.isVisible()) {
                MenuBar.this._about_window.setVisible(true);
            }
        }
    };
    private final ActionListener setViewModeListener = new ActionListener(){
        Viewport2dModel v2d_model = MasterControl.get_v2d().get_model();

        @Override
        public void actionPerformed(ActionEvent event) {
            String name = event.getActionCommand();
            if (name.equals("Transversal")) {
                this.v2d_model.set_view_mode(0);
            } else if (name.equals("Sagittal")) {
                this.v2d_model.set_view_mode(1);
            } else if (name.equals("Frontal")) {
                this.v2d_model.set_view_mode(2);
            }
        }
    };
    private final ActionListener resetViewListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            MasterControl.get_v3d().reset_view();
        }
    };
    private final ActionListener sbListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            YDialogs.show_settings_browser();
        }
    };

    public MenuBar() {
        Settings.register_class_listener(SegRenderer3d.class, this);
        Settings.register_class_listener(Tex2Renderer3d.class, this);
        Settings.register_all_objs_of_class_listener(SegRenderer3d.class, this);
        this._menu_file = new JMenu("File");
        this._menu2d = new JMenu("2D View");
        this._menu3d = new JMenu("3D View");
        this._menu_misc = new JMenu("Misc");
        this._seg_items2d = new ArrayList();
        this._seg_items3d = new ArrayList();
        this._show_after_load_items = new ArrayList();
        this._hide_during_load_items = new ArrayList();
        JMenuItem item = new JMenuItem(new String("Open DICOM"), 79);
        item.setToolTipText("Open DICOM Series");
        item.addActionListener(this.openDICOMListener);
        this.my_add(this._menu_file, item, true, true);
        item = new JMenuItem(new String("Import Images"));
        item.addActionListener(this.importImagesListener);
        item.setToolTipText("Import Set of Images (.JPG, .PNG, .BMP, ...)");
        this.my_add(this._menu_file, item, true, true);
        item = new JMenuItem(new String("Import REK"));
        item.setToolTipText("Import Fraunhofer Raw Volume Format (.REK)");
        item.addActionListener(this.importREKListener);
        this.my_add(this._menu_file, item, true, true);
        item = new JMenuItem(new String("Create Empty Volume"));
        item.setToolTipText("Creates an empty voxel volume");
        item.addActionListener(this.createEmptyListener);
        this.my_add(this._menu_file, item, true, true);
        item = new JMenuItem(new String("Create Volume From Segment"));
        item.setToolTipText("Creates an empty volume that matches the size of a segment");
        item.addActionListener(this.createFromSegment);
        this.my_add(this._menu_file, item, true, true);
        item = new JMenuItem(new String("Save"));
        item.addActionListener(this.saveListener);
        item.setEnabled(false);
        this.my_add(this._menu_file, item, false, true);
        item = new JMenuItem(new String("Save as ..."));
        item.addActionListener(this.saveAsListener);
        this.my_add(this._menu_file, item, false, true);
        item = new JMenuItem(new String("Quit"), 81);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        this.my_add(this._menu_file, item, true, true);
        this._menu_file.addSeparator();
        JMenuItem[] quick_load_entries = new JMenuItem[OPEN_RECENT_STORAGE_NUMBER];
        int i = 0;
        while (i < quick_load_entries.length) {
            quick_load_entries[i] = new JMenuItem();
            quick_load_entries[i].addActionListener(this.quickLoadListener);
            this.my_add(this._menu_file, quick_load_entries[i], true, true);
            ++i;
        }
        this._ors = new QuickLoadStorage(quick_load_entries);
        this._ors.init();
        item = new JBoolOptionMenuItem(MasterControl.get_v2d().get_bg_image_renderer(), BGImageRenderer2d.OPT_VISIBLE);
        item.setText("Show original data");
        this.my_add(this._menu2d, item, false, false);
        ButtonGroup group = new ButtonGroup();
        this._jrbmi_transversal = new JRadioButtonMenuItem("Transversal");
        this._jrbmi_transversal.addActionListener(this.setViewModeListener);
        group.add(this._jrbmi_transversal);
        this._jrbmi_transversal.setSelected(true);
        this.my_add(this._menu2d, this._jrbmi_transversal, false, false);
        this._jrbmi_sagittal = new JRadioButtonMenuItem("Sagittal");
        this._jrbmi_sagittal.addActionListener(this.setViewModeListener);
        group.add(this._jrbmi_sagittal);
        this.my_add(this._menu2d, this._jrbmi_sagittal, false, false);
        this._jrbmi_frontal = new JRadioButtonMenuItem("Frontal");
        this._jrbmi_frontal.addActionListener(this.setViewModeListener);
        group.add(this._jrbmi_frontal);
        this.my_add(this._menu2d, this._jrbmi_frontal, false, false);
        this._menu2d.addSeparator();
        this._no_entries2d = new JMenuItem(new String("no segmentations yet"));
        this._no_entries2d.setEnabled(false);
        this.my_add(this._menu2d, this._no_entries2d, true, false);
        item = new JBoolOptionMenuItem(MasterControl.get_v3d(), Viewport3d.OPT_SHOW_FPS);
        item.setText("Show FPS");
        this.my_add(this._menu3d, item, true, false);
        item = new JBoolOptionMenuItem(BBoxRenderer3d.class, BBoxRenderer3d.OPT_VISIBLE);
        item.setText("Show Bounding Box");
        this.my_add(this._menu3d, item, false, false);
        item = new JMenuItem("Fullscreen mode");
        item.addActionListener(this.fullScreen);
        this.my_add(this._menu3d, item, false, false);
        item = new JMenuItem(new String("Reset View"));
        item.addActionListener(this.resetViewListener);
        item.setEnabled(false);
        this.my_add(this._menu3d, item, false, false);
        this._menu3d.addSeparator();
        item = new JBoolOptionMenuItem(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_BG);
        item.setText("Show Original Data");
        this.my_add(this._menu3d, item, false, true);
        item = new JBoolOptionMenuItem(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_PLANE);
        item.setText("Show Slice Plane");
        this.my_add(this._menu3d, item, false, true);
        item = new JBoolOptionMenuItem(Tex2Renderer3d.class, Tex2Renderer3d.OPT_RENDER_ORTHO);
        item.setText("Show Ortho Slices");
        this.my_add(this._menu3d, item, false, true);
        this._menu3d.addSeparator();
        this._no_entries3d = new JMenuItem(new String("no segmentations yet"));
        this._no_entries3d.setEnabled(false);
        this.my_add(this._menu3d, this._no_entries3d, true, false);
        item = new JMenuItem(new String("DICOM Info"));
        item.addActionListener(this.showDicomInfoListener);
        this.my_add(this._menu_misc, item, false, true);
        this._menu_misc.addSeparator();
        item = new JMenuItem(new String("Settings Browser"));
        item.addActionListener(this.sbListener);
        this.my_add(this._menu_misc, item, true, false);
        item = new JMenuItem(new String("Show System Info"));
        item.addActionListener(this.showSysInfoListener);
        this.my_add(this._menu_misc, item, true, false);
        this._menu_misc.addSeparator();
        item = new JMenuItem(new String("Help"));
        item.addActionListener(this.showFirstStepsListener);
        this.my_add(this._menu_misc, item, true, false);
        item = new JMenuItem(new String("About"));
        item.addActionListener(this.showAboutListener);
        this.my_add(this._menu_misc, item, true, false);
        this.add(this._menu_file);
        this.add(this._menu2d);
        this.add(this._menu3d);
        this.add(this._menu_misc);
        this.init();
        MasterControl.get_is().addObserver(this, "MenuBar()");
        MasterControl.get_v2d().get_model().addObserver(this, "MenuBar()");
    }

    private void my_add(JMenu sub_menu, JMenuItem item, boolean show_before_load, boolean hide_during_load) {
        sub_menu.add(item);
        if (!show_before_load) {
            this._show_after_load_items.add(item);
        }
        if (hide_during_load) {
            this._hide_during_load_items.add(item);
        }
    }

    private void init() {
        int i = 0;
        while (i < this._seg_items2d.size()) {
            this._menu2d.remove(this._seg_items2d.get(i));
            this._menu3d.remove(this._seg_items3d.get(i));
            this._no_entries2d.setVisible(true);
            this._no_entries3d.setVisible(true);
            ++i;
        }
        i = 0;
        while (i < this._show_after_load_items.size()) {
            this._show_after_load_items.get(i).setEnabled(false);
            ++i;
        }
        this._seg_items2d.clear();
        this._seg_items3d.clear();
    }

    @Override
    public void update(final YObservable o, final Message m) {
        if (m._type == ImageStack.M_NEW_SEGMENT) {
            Segment seg = (Segment)m._obj;
            SegRenderer2d sr2d = MasterControl.get_v2d().get_seg_renderer(seg);
            SegRenderer3d sr3d = MasterControl.get_v3d().get_seg_renderer(seg);
            if (sr2d == null || sr3d == null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuBar.this.update(o, m);
                    }
                });
                return;
            }
            this._no_entries2d.setVisible(false);
            this._no_entries3d.setVisible(false);
            JBoolOptionMenuItem item = new JBoolOptionMenuItem(sr2d, SegRenderer2d.OPT_VISIBLE);
            item.setText(seg.get_name());
            this._seg_items2d.add(item);
            this._menu2d.add(item);
            item = new JBoolOptionMenuItem(sr3d, SegRenderer3d.OPT_VISIBLE);
            item.setText(seg.get_name());
            this._menu3d.add(item);
            this._seg_items3d.add(item);
            seg.addObserver(this, "MenuBar::update (new segment)");
        } else if (m._type == ImageStack.M_DEL_SEGMENT) {
            Segment seg = (Segment)m._obj;
            String name = seg.get_name();
            JMenuItem item = null;
            int i = 0;
            while (i < this._menu2d.getItemCount()) {
                item = this._menu2d.getItem(i);
                if (item != null && item.getText() == name) break;
                ++i;
            }
            this._menu2d.remove(item);
            this._seg_items2d.remove(item);
            i = 0;
            while (i < this._menu3d.getItemCount()) {
                item = this._menu3d.getItem(i);
                if (item != null && item.getText() == name) break;
                ++i;
            }
            this._menu3d.remove(item);
            this._seg_items3d.remove(item);
            seg.deleteObserver(this);
        } else if (m._type == Segment.M_SEG_NAME_CHANGED) {
            Segment seg = (Segment)o;
            String old_name = (String)m._obj;
            JMenuItem item = null;
            int i = 0;
            while (i < this._menu2d.getItemCount()) {
                item = this._menu2d.getItem(i);
                if (item != null && item.getText() == old_name) {
                    item.setText(seg.get_name());
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this._menu3d.getItemCount()) {
                item = this._menu3d.getItem(i);
                if (item != null && item.getText() == old_name) {
                    item.setText(seg.get_name());
                    break;
                }
                ++i;
            }
        } else if (m._type == ImageStack.M_CLEAR) {
            this.init();
        } else if (m._type == ImageStack.M_LOADING_START) {
            int i = 0;
            while (i < this._hide_during_load_items.size()) {
                this._hide_during_load_items.get(i).setEnabled(false);
                ++i;
            }
        } else if (m._type == ImageStack.M_LOADING_END) {
            this._ors.loaded((QuickLoadInfo)m._obj);
            int i = 0;
            while (i < this._show_after_load_items.size()) {
                this._show_after_load_items.get(i).setEnabled(true);
                ++i;
            }
            i = 0;
            while (i < this._hide_during_load_items.size()) {
                this._hide_during_load_items.get(i).setEnabled(true);
                ++i;
            }
        } else if (m._type == Viewport2dModel.M_NEW_VIEW_MODE) {
            int view_mode = MasterControl.get_v2d().get_model().get_view_mode();
            if (view_mode == 0) {
                this._jrbmi_transversal.setSelected(true);
            } else if (view_mode == 1) {
                this._jrbmi_sagittal.setSelected(true);
            } else {
                assert (view_mode == 2);
                this._jrbmi_frontal.setSelected(true);
            }
        }
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
        if (obj.getClass() == SegRenderer3d.class && opt_name.equals(SegRenderer3d.OPT_VISIBLE)) {
            SegRenderer3d sr3d = (SegRenderer3d)obj;
            String seg_name = sr3d.get_seg().get_name();
            for (JMenuItem jMenuItem : this._seg_items3d) {
                String name = jMenuItem.getActionCommand();
                if (!name.equals(seg_name)) continue;
                jMenuItem.setSelected((Boolean)opt);
                break;
            }
        }
    }
}

