/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import main.Message;
import main.SegChangeInfo;
import main.YaDiV;
import misc.grid.BitCube;
import misc.messages.YObservable;

public final class Segment
extends YObservable {
    public static int M_SEG_NAME_CHANGED = Message.register_message("Segment NameChanged");
    public static int M_SEG_COL_CHANGED = Message.register_message("Segment ColorChanged");
    public static int M_SEG_CHANGED = Message.register_message("Segment Changed");
    public static int M_SEG_SIZE_CHANGED = Message.register_message("Segment SizeChanged");
    public static int M_SEG_LOADING_START = Message.register_message("Segment Loading Start");
    public static int M_SEG_HEADER_LOADED = Message.register_message("Segment Header Loaded");
    public static int M_SEG_SLICE_LOADED = Message.register_message("Segment Slice Loaded");
    public static int M_SEG_LOADING_END = Message.register_message("Segment Loading End");
    public static int M_SEG_LOADING_ABORTED = Message.register_message("Segment Loading Aborted");
    public static int M_SEG_SAVING_START = Message.register_message("Segment Saving Start");
    public static int M_SEG_SAVING_SLICE = Message.register_message("Segment Slice Saved");
    public static int M_SEG_SAVING_END = Message.register_message("Segment Saving End");
    private String _name;
    private int _color;
    private BitCube _bc;

    public Segment(String name, int dim_x, int dim_y, int dim_z) {
        this._name = name;
        this._color = 0xFF00FF;
        this._bc = new BitCube(dim_x, dim_y, dim_z);
    }

    public BitCube get_bc() {
        return this._bc;
    }

    public void set_bc(BitCube bc) {
        if (this._bc.get_dim_x() != bc.get_dim_x() || this._bc.get_dim_y() != bc.get_dim_y() || this._bc.get_dim_z() != bc.get_dim_z()) {
            this._bc = bc;
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_SIZE_CHANGED, null));
        } else {
            this._bc = bc;
        }
        this.new_data(true);
    }

    public String get_name() {
        return this._name;
    }

    public void set_name(String name) {
        if (!this._name.equals(name)) {
            String old_name = this._name;
            this._name = name;
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_NAME_CHANGED, old_name));
        }
    }

    public int get_color() {
        return this._color;
    }

    public void set_color(int color) {
        if (this._color != color) {
            this._color = color;
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_COL_CHANGED, null));
        }
    }

    public void add_seg(Segment seg) {
        if (this._bc.get_dim_x() == seg._bc.get_dim_x() && this._bc.get_dim_y() == seg._bc.get_dim_y() && this._bc.get_dim_z() == seg._bc.get_dim_z()) {
            this._bc.add(seg._bc);
            this.new_data(true);
        }
    }

    public void copy_data_from(Segment seg) {
        if (this._bc.get_dim_x() == seg._bc.get_dim_x() && this._bc.get_dim_y() == seg._bc.get_dim_y() && this._bc.get_dim_z() == seg._bc.get_dim_z()) {
            this._bc.copy_data_from(seg._bc);
            this.new_data(false);
        }
    }

    public void rem_seg(Segment seg) {
        if (this._bc.get_dim_x() == seg._bc.get_dim_x() && this._bc.get_dim_y() == seg._bc.get_dim_y() && this._bc.get_dim_z() == seg._bc.get_dim_z()) {
            this._bc.del(seg._bc);
            this.new_data(new SegChangeInfo(SegChangeInfo.SOME_CHANGE, null), true);
        }
    }

    public void translate(int tx, int ty, int tz) {
        if (tx > 0) {
            if (this._bc._bb_max[0] + tx > this._bc.get_dim_x() - 1) {
                tx = this._bc.get_dim_x() - 1 - this._bc._bb_max[0];
            }
        } else if (this._bc._bb_min[0] + tx < 0) {
            tx = -this._bc._bb_min[0];
        }
        if (ty > 0) {
            if (this._bc._bb_max[1] + ty > this._bc.get_dim_y() - 1) {
                ty = this._bc.get_dim_y() - 1 - this._bc._bb_max[1];
            }
        } else if (this._bc._bb_min[1] + ty < 0) {
            ty = -this._bc._bb_min[1];
        }
        if (tz > 0) {
            if (this._bc._bb_max[2] + tz > this._bc.get_dim_z() - 1) {
                tz = this._bc.get_dim_z() - 1 - this._bc._bb_max[2];
            }
        } else if (this._bc._bb_min[2] + tz < 0) {
            tz = -this._bc._bb_min[2];
        }
        this._bc.translate(tx, ty, tz);
        int[] trans = new int[]{tx, ty, tz};
        this.new_data(new SegChangeInfo(SegChangeInfo.TRANSLATION, trans), false);
    }

    public void new_data(SegChangeInfo sc_info, boolean bb_update_needed) {
        if (bb_update_needed) {
            if (sc_info._change_type == SegChangeInfo.BOUNDED_CHANGE) {
                int[] bb = (int[])sc_info._data;
                this._bc.calc_bb(bb[0], bb[1], bb[2], bb[3], bb[4], bb[5]);
            } else {
                this._bc.calc_bb();
            }
        }
        this.setChanged();
        this.notifyObservers(new Message(M_SEG_CHANGED, sc_info));
    }

    public void new_data(boolean bb_update_needed) {
        this.new_data(new SegChangeInfo(SegChangeInfo.SOME_CHANGE, null), bb_update_needed);
    }

    public boolean load_seg(File file) {
        String version;
        String[] first_line_parts;
        BufferedReader bfr;
        InputStreamReader isr;
        GZIPInputStream gzip_fis;
        block23: {
            gzip_fis = null;
            try {
                gzip_fis = new GZIPInputStream(new FileInputStream(file));
                isr = new InputStreamReader((InputStream)gzip_fis, "UTF-8");
            }
            catch (IOException ex) {
                isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            }
            bfr = new BufferedReader(isr);
            String first_line = bfr.readLine();
            first_line_parts = first_line.split(";");
            if (first_line_parts.length == 5) {
                version = "V0.x";
                break block23;
            }
            if (first_line_parts.length > 5) {
                version = first_line_parts[5];
                break block23;
            }
            String version2 = "V.0";
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Wrong segment file format, aborting!");
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_LOADING_ABORTED, null));
            return false;
        }
        try {
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_LOADING_START, null));
            YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "Loading Segment, version: " + version);
            this.set_name(first_line_parts[0]);
            this.set_color((int)Long.parseLong(first_line_parts[1], 16));
            int dim_x = Integer.parseInt(first_line_parts[2]);
            int dim_y = Integer.parseInt(first_line_parts[3]);
            int dim_z = Integer.parseInt(first_line_parts[4]);
            this._bc = new BitCube(dim_x, dim_y, dim_z);
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_HEADER_LOADED, null));
            String[] values = new String[]{};
            if (version.equals("V0.x")) {
                YaDiV.report(YaDiV.ReportType.REPORT_DEBUG, "converting old data format ... ");
                int ints_per_row = dim_x % 32 == 0 ? dim_x / 32 : dim_x / 32 + 1;
                int[] data = new int[ints_per_row * dim_y * dim_z];
                int i = 0;
                while (i < data.length) {
                    String line = bfr.readLine();
                    if (line != null) {
                        values = line.split(";");
                        int j = 0;
                        while (j < values.length) {
                            data[i + j] = Integer.parseInt(values[j]);
                            ++j;
                        }
                    } else {
                        values = new String[]{};
                    }
                    i += values.length;
                }
                int z = 0;
                while (z < dim_z) {
                    int y = 0;
                    while (y < dim_y) {
                        int x = 0;
                        while (x < dim_x) {
                            int pos = z * dim_x * dim_y + y * dim_x + x;
                            int intnum = pos >>> 5;
                            int bitnum = pos % 32;
                            if ((data[intnum] & 1 << bitnum) != 0) {
                                this._bc.setXYZ(x, y, z, true);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
            } else if (version.equals("V1.0") || version.equals("V1.1")) {
                int intcount = 0;
                int[] bit_cube_data = this._bc.get_data();
                int i = 0;
                while (i < bit_cube_data.length) {
                    String line = bfr.readLine();
                    values = line.split(";");
                    int j = 0;
                    while (j < values.length) {
                        bit_cube_data[i + j] = Integer.parseInt(values[j]);
                        if (++intcount > this._bc.get_ints_per_img()) {
                            intcount = 0;
                            this.setChanged();
                            this.notifyObservers(new Message(M_SEG_SLICE_LOADED, null));
                        }
                        ++j;
                    }
                    i += values.length;
                }
            } else {
                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Error: Unsupported Segment FileFormat Version!");
            }
            isr.close();
            if (gzip_fis != null) {
                gzip_fis.close();
            }
            bfr.close();
        }
        catch (IOException ex) {
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Error while loading a segment. Unhandled exception: load_seg" + ex);
        }
        this.setChanged();
        this.notifyObservers(new Message(M_SEG_LOADING_END, null));
        return true;
    }

    public void save_seg(File file) {
        try {
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_SAVING_START, null));
            FileOutputStream fos = new FileOutputStream(file);
            GZIPOutputStream gzip_fos = new GZIPOutputStream(fos);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)gzip_fos, "UTF-8");
            String first_line = new String(String.valueOf(this._name) + ";" + Integer.toHexString(this._color) + ";" + this._bc.get_dim_x() + ";" + this._bc.get_dim_y() + ";" + this._bc.get_dim_z() + ";" + "V1.1;" + "\n");
            osw.write(first_line);
            int intcount = 0;
            int[] bit_cube_data = this._bc.get_data();
            int i = 0;
            while (i < bit_cube_data.length) {
                osw.write(new String(String.valueOf(bit_cube_data[i]) + ";"));
                if (i > 0 && i % 10 == 0) {
                    osw.write("\n");
                }
                if (++intcount > this._bc.get_ints_per_img()) {
                    intcount = 0;
                    this.setChanged();
                    this.notifyObservers(new Message(M_SEG_SAVING_SLICE, null));
                }
                ++i;
            }
            osw.close();
            this.setChanged();
            this.notifyObservers(new Message(M_SEG_SAVING_END, null));
        }
        catch (Exception ex) {
            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "Error while saving a segment. Unhandled exception: load_seg" + ex);
        }
    }
}

