/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.text.NumberFormatter;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import misc.Voxel;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;
import threads.RSThread;

public final class StatusBar
extends GMPanel
implements YObserverWantsAWTThread {
    private static int MEMORY_FIRST_UPDATE = 100;
    private static int MEMORY_UPDATE_INTERVAL = 1000;
    private final NumberFormatter _xformatter;
    private final NumberFormatter _yformatter;
    private final NumberFormatter _zformatter;
    private final JFormattedTextField _jftf_x;
    private final JFormattedTextField _jftf_y;
    private final JFormattedTextField _jftf_z;
    private final JProgressBar _progress_bar;
    private final JLabel _progress_label;
    private Voxel _seed = new Voxel(0, 0, 0);
    private final JLabel _jl_content_mem_usage = new JLabel();
    private RSThread _stoppable_thread = null;
    private final AbstractAction _act_stop;
    private static StatusBar _instance = null;

    public JLabel get_progress_label() {
        return this._progress_label;
    }

    public JProgressBar get_progress_bar() {
        return this._progress_bar;
    }

    public static StatusBar get_instance() {
        if (_instance == null) {
            _instance = new StatusBar();
        }
        return _instance;
    }

    private StatusBar() {
        this._jl_content_mem_usage.setText("----");
        this._jl_content_mem_usage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.gc();
                System.gc();
                System.gc();
            }
        });
        Timer mem_usage_update_timer = new Timer();
        mem_usage_update_timer.schedule((TimerTask)new MemUsageUpdateTask(), MEMORY_FIRST_UPDATE, (long)MEMORY_UPDATE_INTERVAL);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        this._xformatter = new NumberFormatter(intFormat);
        this._xformatter.setMinimum(new Integer(0));
        this._xformatter.setMaximum(new Integer(0));
        this._yformatter = new NumberFormatter(intFormat);
        this._yformatter.setMinimum(new Integer(0));
        this._yformatter.setMaximum(new Integer(0));
        this._zformatter = new NumberFormatter(intFormat);
        this._zformatter.setMinimum(new Integer(0));
        this._zformatter.setMaximum(new Integer(0));
        this._jftf_x = new JFormattedTextField(this._xformatter);
        this._jftf_x.setHorizontalAlignment(0);
        this._jftf_x.setColumns(4);
        this._jftf_x.setValue(new Integer(0));
        this._jftf_x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((StatusBar)StatusBar.this)._seed._x = (Integer)StatusBar.this._jftf_x.getValue();
                MasterControl.get_is().set_seed(StatusBar.this._seed);
            }
        });
        this._jftf_y = new JFormattedTextField(this._yformatter);
        this._jftf_y.setHorizontalAlignment(0);
        this._jftf_y.setColumns(4);
        this._jftf_y.setValue(new Integer(0));
        this._jftf_y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((StatusBar)StatusBar.this)._seed._y = (Integer)StatusBar.this._jftf_y.getValue();
                MasterControl.get_is().set_seed(StatusBar.this._seed);
            }
        });
        this._jftf_z = new JFormattedTextField(this._zformatter);
        this._jftf_z.setHorizontalAlignment(0);
        this._jftf_z.setColumns(4);
        this._jftf_z.setValue(new Integer(0));
        this._jftf_z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((StatusBar)StatusBar.this)._seed._z = (Integer)StatusBar.this._jftf_z.getValue();
                MasterControl.get_is().set_seed(StatusBar.this._seed);
            }
        });
        JToolBar jtb_stop = new JToolBar("JToolBar");
        jtb_stop.setFloatable(false);
        jtb_stop.setOrientation(0);
        jtb_stop.setBorder(null);
        this._act_stop = new AbstractAction("Stop", new ImageIcon("resources/gfx/stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StatusBar.this._stoppable_thread != null) {
                    StatusBar.this._stoppable_thread.stop_soon();
                }
                StatusBar.this._act_stop.setEnabled(false);
            }
        };
        this._act_stop.putValue("ShortDescription", "Stop whatever currently is in progress");
        this._act_stop.setEnabled(false);
        jtb_stop.add(this._act_stop);
        this._progress_label = new JLabel("---");
        this._progress_bar = new JProgressBar();
        this._progress_bar.setValue(0);
        this._progress_bar.setStringPainted(true);
        this.add("_jl_content_mem_usage", this._jl_content_mem_usage);
        this.add("_jftf_x", this._jftf_x);
        this.add("_jftf_y", this._jftf_y);
        this.add("_jftf_z", this._jftf_z);
        this.add("_progress_label", this._progress_label);
        this.add("_progress_bar", this._progress_bar);
        this.add("_jb_stop", jtb_stop);
        this.set_layout("<table cellpadding='2' border='0' width='100%' margin='0'>  <tr>    <td width='1%'>Memory Usage:</td>    <td width='1%'>::_jl_content_mem_usage::</td>    <td> </td>    <td width='1%'>Seed: (</td>    <td width='1%'>::_jftf_x::</td>    <td width='1%'>,</td>    <td width='1%'>::_jftf_y::</td>    <td width='1%'>,</td>    <td width='1%'>::_jftf_z::</td>    <td width='1%'>)</td>    <td> </td>    <td width='1%'>::_progress_label::</td>    <td width='1%'>::_progress_bar::</td>    <td width='1%'>::_jb_stop::</td>  </tr></table>");
        MasterControl.get_is().addObserver(this, "StatusBar()");
    }

    private final void update_content() {
        this._jl_content_mem_usage.setText((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + " / " + Runtime.getRuntime().totalMemory() / 0x100000L + " / " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB   ");
    }

    public void set_stopable(RSThread stoppable) {
        if (stoppable == null) {
            this._act_stop.setEnabled(false);
            this._progress_label.setText("---");
        } else {
            this._stoppable_thread = stoppable;
            this._act_stop.setEnabled(true);
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_LOADING_END) {
            ImageStack is = MasterControl.get_is();
            this._xformatter.setMaximum(new Integer(is.get_dim_x()));
            this._yformatter.setMaximum(new Integer(is.get_dim_y()));
            this._zformatter.setMaximum(new Integer(is.get_dim_z()));
            is.set_seed(new Voxel(0, 0, 0));
        }
        if (m._type == ImageStack.M_SELECTXYZ) {
            this._seed = (Voxel)m._obj;
            this._jftf_x.setValue(this._seed._x);
            this._jftf_y.setValue(this._seed._y);
            this._jftf_z.setValue(this._seed._z);
        }
    }

    private final class MemUsageUpdateTask
    extends TimerTask {
        private MemUsageUpdateTask() {
        }

        @Override
        public void run() {
            StatusBar.this.update_content();
        }
    }
}

