/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ThreadStatusWindow
extends JPanel {
    private static ThreadStatusWindow _instance = null;
    private final Hashtable<Integer, BarAndWin> _thread_table;
    private final AtomicInteger _total_threads_counter = new AtomicInteger(0);
    private final AtomicInteger _id_counter = new AtomicInteger(0);

    private ThreadStatusWindow() {
        this._thread_table = new Hashtable();
        this.setLayout(new BoxLayout(this, 1));
    }

    public static ThreadStatusWindow get_instance() {
        if (_instance == null) {
            _instance = new ThreadStatusWindow();
        }
        return _instance;
    }

    public int register_thread(String name, int min, int max, int value) {
        int id = this._id_counter.getAndIncrement();
        this._total_threads_counter.getAndIncrement();
        JProgressBar progress_bar = new JProgressBar(min, max);
        progress_bar.setValue(value);
        JPanel win = new JPanel();
        win.setLayout(new BoxLayout(win, 1));
        win.add(new JLabel("<html><font size=\"2\">" + name + "</font></html>"));
        win.add(progress_bar);
        this.add(win);
        this.revalidate();
        this.repaint();
        this._thread_table.put(id, new BarAndWin(win, progress_bar));
        return id;
    }

    public void unregister_thread(int id) {
        BarAndWin wbn = this._thread_table.get(id);
        this.remove(wbn._win);
        this.revalidate();
        this.repaint();
        this._total_threads_counter.getAndDecrement();
        this._thread_table.remove(id);
    }

    public void set_thread_min(int id, int min) {
        this._thread_table.get((Object)Integer.valueOf((int)id))._bar.setMinimum(min);
    }

    public void set_thread_max(int id, int max) {
        this._thread_table.get((Object)Integer.valueOf((int)id))._bar.setMaximum(max);
    }

    public void set_thread_value(int id, int value) {
        this._thread_table.get((Object)Integer.valueOf((int)id))._bar.setValue(value);
    }

    private class BarAndWin {
        JPanel _win;
        public JProgressBar _bar;

        public BarAndWin(JPanel win, JProgressBar bar) {
            this._win = win;
            this._bar = bar;
        }
    }
}

