/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui.LazyTabbedPane;
import java.awt.Component;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.tools.ToolInfo;
import main.tools.ToolMisc;
import main.tools.ToolRayCasting;
import main.tools.ToolSegGen;
import main.tools.ToolView2d;
import main.tools.ToolView3d;
import main.tools.ToolVolumeOps;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public final class ToolPane
extends LazyTabbedPane
implements YObserverWantsAWTThread {
    public ToolPane() {
        this.setTabPlacement(2);
        this.addTab("Info", null, (Component)((Object)new ToolInfo()), "Shows information about the currently opened DICOM series");
        this.addTab("Segs", null, (Component)((Object)new ToolSegGen()), "Create, edit and modify Segmentations");
        this.addTab("View 2d", null, (Component)((Object)new ToolView2d()), "Edit View2D Settings");
        this.addTab("View 3d", null, (Component)((Object)new ToolView3d()), "Edit View3D Settings");
        this.addTab("Misc", null, (Component)((Object)new ToolMisc()), "ROI, Anonomyize etc.");
        this.addTab("Volume Ops", null, (Component)((Object)new ToolVolumeOps()), "Resize, Image Processing etc.");
        this.addTab("Raycasting", null, (Component)((Object)new ToolRayCasting()), "Control the Offline Renderer");
        this.setEnabledForAll(false);
        MasterControl.get_is().addObserver(this, "ToolPane()");
    }

    private void setEnabledForAll(boolean b) {
        int i = 0;
        while (i < this.getTabCount()) {
            this.setEnabledAt(i, b);
            ++i;
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_CLEAR) {
            this.setSelectedIndex(0);
            this.setEnabledForAll(false);
        } else if (m._type == ImageStack.M_LOADING_END) {
            this.setEnabledForAll(true);
        }
    }
}

