/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import main.ImageStack;
import main.Message;
import main.YaDiV;
import misc.StopWatch;
import misc.grid.RegularGrid3i;
import misc.messages.YObservable;
import misc.messages.YObserverWantsAWTThread;

public final class VoxelCubeHistogram
extends YObservable
implements YObserverWantsAWTThread {
    public static int M_VCH_UPDATE = Message.register_message("VoxelCubeHistogram Update");
    public int[] _histo;
    public int _min_value;
    public int _max_value;
    public int _min_nonzero_index;
    public int _max_nonzero_index;
    public int _nonzero_peak;
    public final ImageStack _is;

    public VoxelCubeHistogram(ImageStack is) {
        this._is = is;
        this.build_histogram();
        this._is.addObserver(this, "VoxelCubeHistogram()");
    }

    private void build_histogram() {
        StopWatch sw = new StopWatch(true);
        RegularGrid3i vc = this._is.get_voxel_cube();
        if (vc == null || vc.get_number_of_voxels() == 0) {
            this._histo = new int[0];
            return;
        }
        this._histo = new int[this._is.get_voxel_value_range()];
        this._min_value = vc.get(0);
        this._max_value = vc.get(0);
        int i = 1;
        while (i < vc.get_number_of_voxels()) {
            int value;
            int n = value = vc.get(i);
            this._histo[n] = this._histo[n] + 1;
            if (value > this._max_value) {
                this._max_value = value;
            }
            if (value < this._min_value) {
                this._min_value = value;
            }
            ++i;
        }
        this._nonzero_peak = this._histo[1];
        i = 2;
        while (i < this._histo.length) {
            if (this._histo[i] > this._nonzero_peak) {
                this._nonzero_peak = this._histo[i];
            }
            ++i;
        }
        this._min_nonzero_index = 1;
        i = 1;
        while (i < this._histo.length) {
            if (this._histo[i] > 0) {
                this._min_nonzero_index = i;
                break;
            }
            ++i;
        }
        this._max_nonzero_index = this._histo.length - 1;
        i = this._histo.length - 1;
        while (i > 0) {
            if (this._histo[i] > 0) {
                this._max_nonzero_index = i;
                break;
            }
            --i;
        }
        YaDiV.report(YaDiV.ReportType.REPORT_TIME, "Computing VCH: " + sw.toString());
        this.setChanged();
        this.notifyObservers(new Message(M_VCH_UPDATE, null));
    }

    public final void render_image(BufferedImage img, Color bg_color, Color fg_color, boolean logarithmic_scale, boolean show_full_range) {
        int max;
        int min;
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        int img_width = img.getWidth();
        int img_height = img.getHeight();
        g2.setColor(bg_color);
        g2.fillRect(0, 0, img_width, img_height);
        if (show_full_range) {
            min = 0;
            max = this._histo.length;
        } else {
            min = this._min_nonzero_index;
            max = this._max_nonzero_index;
        }
        int range = max - min;
        int peak = Integer.MIN_VALUE;
        if (range >= img_width) {
            double values_per_pixel = (double)range / (double)img_width;
            int[] values = new int[img_width];
            int i = 0;
            while (i < values.length) {
                values[i] = 0;
                int j = (int)((double)i * values_per_pixel);
                while (j < (int)((double)(i + 1) * values_per_pixel)) {
                    int n = i;
                    values[n] = values[n] + this._histo[min + j];
                    ++j;
                }
                if (values[i] > peak) {
                    peak = values[i];
                }
                ++i;
            }
            g2.setColor(fg_color);
            double scale = logarithmic_scale ? (double)(img_height - 1) / Math.log(peak) : (double)(img_height - 1) / (double)peak;
            int i2 = 0;
            while (i2 < values.length) {
                int value = logarithmic_scale ? (values[i2] > 0 ? (int)(Math.log(values[i2]) * scale) : 0) : (int)((double)values[i2] * scale);
                g2.drawLine(i2, img_height - 1, i2, img_height - 1 - value);
                ++i2;
            }
        } else {
            double delta_x = (double)img_width / (double)range;
            int[] values = new int[range];
            int i = 0;
            while (i < values.length) {
                values[i] = this._histo[min + i];
                if (values[i] > peak) {
                    peak = values[i];
                }
                ++i;
            }
            g2.setColor(fg_color);
            double scale = logarithmic_scale ? (double)(img_height - 1) / Math.log(peak) : (double)(img_height - 1) / (double)peak;
            int i3 = 0;
            while (i3 < values.length) {
                int value = logarithmic_scale ? (values[i3] > 0 ? (int)(Math.log(values[i3]) * scale) : 0) : (int)((double)values[i3] * scale);
                g2.drawLine((int)((double)i3 * delta_x), img_height - 1, (int)((double)i3 * delta_x), img_height - 1 - value);
                g2.drawLine((int)((double)i3 * delta_x), img_height - 1 - value, (int)((double)(i3 + 1) * delta_x), img_height - 1 - value);
                g2.drawLine((int)((double)(i3 + 1) * delta_x), img_height - 1, (int)((double)(i3 + 1) * delta_x), img_height - 1 - value);
                ++i3;
            }
        }
    }

    @Override
    public final void update(YObservable o, Message m) {
        if (m._type == ImageStack.M_LOADING_END || m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_FILTER3D_END) {
            this.build_histogram();
        }
    }
}

