/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui.LightDialog;
import gui.SegDialog;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import main.Global;
import main.ImageStack;
import main.MainWindow;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.YaDiV;
import main.view3d.LightModel;
import misc.grid.BitCube;
import misc.grid.RegularGrid3i;
import misc.helper.Helper;
import misc.messages.YObservable;
import misc.messages.YObserver;
import settings.Settings;
import settings.SettingsBrowser;
import threads.RSThread;

public final class YDialogs
implements YObserver {
    public static final JFileChooser _seg_file_chooser;
    private static final HashMap<Segment, String> _seg_filenames;
    private static final YDialogs _instance;
    public static MainWindow _win;

    static {
        _seg_filenames = new HashMap();
        String def_seg_dir_name = Settings.get_str_option(YaDiV.class, YaDiV.OPT_DEF_SEG_DIR);
        File f_def_seg_dir = new File(def_seg_dir_name);
        _seg_file_chooser = f_def_seg_dir.exists() ? new JFileChooser(def_seg_dir_name) : new JFileChooser();
        _instance = new YDialogs();
        MasterControl.get_is().addObserver(_instance, "YDialogs");
    }

    private YDialogs() {
    }

    public static final void seg_del_dialog(Segment seg) {
        int n = JOptionPane.showConfirmDialog(_win, "Do you really want to delets this segmentation?", "An Inane Question", 0);
        if (n == 0) {
            MasterControl.get_is().delete_segment(seg);
        }
    }

    public static final void new_seg_dialog(Segment seg) {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() != 2) {
            JOptionPane.showMessageDialog(_win, "Cant create segmentation without a dicom series.", "Inane error", 0);
        } else if (is.get_segment_number() == SegDialog.MAX_SEG_NUM) {
            JOptionPane.showMessageDialog(_win, "Maximum number of segmentations reached.", "Inane error", 0);
        } else {
            SegDialog new_seg_dia = new SegDialog(seg);
            new_seg_dia.setVisible(true);
        }
    }

    public static void save_seg_dialog(final Segment seg) {
        String suggested_name = _seg_filenames.containsKey(seg) ? _seg_filenames.get(seg) : String.valueOf(Helper.get_last_dir(MasterControl.get_is().get_dir_name())) + "_" + seg.get_name() + ".seg";
        _seg_file_chooser.setSelectedFile(new File(suggested_name));
        _seg_file_chooser.setMultiSelectionEnabled(false);
        if (_seg_file_chooser.showSaveDialog(null) == 0) {
            RSThread rst_saving = new RSThread(null, true, false){

                @Override
                public void my_run() {
                    File file = _seg_file_chooser.getSelectedFile();
                    this.init_progress_measure("saving segment ...", 0, MasterControl.get_is().get_voxel_cube().get_dim_z(), 0);
                    if (file.exists() && !file.canWrite()) {
                        YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "could not write file " + file.getAbsolutePath());
                    }
                    if (!file.exists() || YDialogs.overwrite_file_dialog(file.getName())) {
                        seg.addObserver(this, "observing save status");
                        seg.save_seg(file);
                        _seg_filenames.put(seg, file.getAbsolutePath());
                        seg.deleteObserver(this);
                    }
                }

                @Override
                public void update(YObservable sender, Message m) {
                    if (m._type == Segment.M_SEG_SAVING_SLICE) {
                        this.inc_progress_value(1);
                    }
                }
            };
            rst_saving.start();
        }
    }

    public static boolean overwrite_file_dialog(String file_name) {
        int n = JOptionPane.showConfirmDialog(MasterControl.get_window(), String.valueOf(file_name) + " already exists. Overwrite it (original content will be lost)?", "Overwrite File?", 0);
        return n == 0;
    }

    public static void load_seg_dialog() {
        _seg_file_chooser.setMultiSelectionEnabled(true);
        final int dim_z = MasterControl.get_is().get_voxel_cube().get_dim_z();
        if (_seg_file_chooser.showOpenDialog(null) == 0) {
            RSThread rst_loading = new RSThread(null, true, false){

                @Override
                public void my_run() {
                    File[] files = _seg_file_chooser.getSelectedFiles();
                    this.init_progress_measure("loading segment ...", 0, dim_z * files.length, 0);
                    int i = 0;
                    while (i < files.length) {
                        File file = files[i];
                        if (file.exists() && !file.canRead()) {
                            String message = "Error: could not open file " + file.getAbsolutePath();
                            JOptionPane.showMessageDialog(_win, message, "Inane error", 0);
                            YaDiV.report(YaDiV.ReportType.REPORT_ERROR, message);
                        } else {
                            ImageStack is = MasterControl.get_is();
                            RegularGrid3i vc = is.get_voxel_cube();
                            Segment load_seg = new Segment("loading", vc.get_dim_x(), vc.get_dim_y(), vc.get_dim_z());
                            load_seg.addObserver(this, "observing load status");
                            boolean success = load_seg.load_seg(file);
                            load_seg.deleteObserver(this);
                            BitCube bc = load_seg.get_bc();
                            if (!success) {
                                String message = "Could not load segment data from " + file.getAbsolutePath() + ": Wrong Format";
                                JOptionPane.showMessageDialog(_win, message, "Inane error", 0);
                                YaDiV.report(YaDiV.ReportType.REPORT_ERROR, message);
                            } else if (bc.get_dim_x() == vc.get_dim_x() && bc.get_dim_y() == vc.get_dim_y() && bc.get_dim_z() == vc.get_dim_z()) {
                                String seg_name = new String(load_seg.get_name());
                                if (is.get_segment(seg_name) != null) {
                                    String new_name = Helper.get_unique_key(seg_name, is.get_seg_map().keySet());
                                    String message = "A segment with the name \"" + load_seg.get_name() + " already existed. Renamed new segment to \"" + new_name + "\"";
                                    JOptionPane.showMessageDialog(_win, message, "Warningr", 2);
                                    seg_name = new_name;
                                }
                                Segment seg = is.create_segment(seg_name, load_seg.get_color());
                                seg.set_bc(load_seg.get_bc());
                                _seg_filenames.put(seg, file.getAbsolutePath());
                            } else {
                                JOptionPane.showMessageDialog(_win, "Segment dimensions (" + bc.get_dim_x() + "," + bc.get_dim_y() + "," + bc.get_dim_z() + ")" + " do not match the currently opened volume data" + " (" + vc.get_dim_x() + "," + vc.get_dim_y() + "," + vc.get_dim_z() + ").", "Inane error", 0);
                            }
                        }
                        ++i;
                    }
                }

                @Override
                public void update(YObservable yo, Message m) {
                    if (m._type == Segment.M_SEG_HEADER_LOADED) {
                        Segment seg = (Segment)yo;
                        int old_max = this.get_progress_max();
                        this.set_progress_max(old_max - dim_z + seg.get_bc().get_dim_z());
                    } else if (m._type == Segment.M_SEG_SLICE_LOADED) {
                        this.inc_progress_value(1);
                    }
                }
            };
            rst_loading.start();
        }
    }

    public static void show_settings_browser() {
        JFrame win = new JFrame("Settings Browser");
        win.setIconImage(Global.ICON_IMAGE);
        SettingsBrowser sv = new SettingsBrowser("YaDiV");
        win.add(sv);
        win.pack();
        win.setVisible(true);
    }

    public static void light_dialog(LightModel template) {
        int MAX_LIGHT_NUM = 10;
        if (MasterControl.get_lights().size() >= 10) {
            JOptionPane.showMessageDialog(_win, "Maximum number of lights reached.", "Inane error", 0);
        } else {
            LightDialog new_seg_dia = new LightDialog(template);
            new_seg_dia.setVisible(true);
        }
    }

    public static void notify_user(String message) {
        JOptionPane.showMessageDialog(_win, message, "User Notification", 0);
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (yo.getClass() == ImageStack.class) {
            if (m._type == ImageStack.M_CLEAR) {
                _seg_filenames.clear();
            } else if (m._type == ImageStack.M_LOADING_END && Settings.get_bool_option(YaDiV.class, YaDiV.OPT_USE_DATA_DIR_AS_SEG_DIR).booleanValue()) {
                File f = new File(MasterControl.get_is().get_dir_name());
                _seg_file_chooser.setCurrentDirectory(f);
            }
        }
    }
}

