/*
 * Decompiled with CFR 0.152.
 */
package main;

import gui.MyHTMLPane;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jgridmaker.JGridMaker;
import main.MasterControl;
import misc.StopWatch;
import misc.grid.BitCube;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import org.apache.log4j.PropertyConfigurator;
import settings.Settings;
import settings.SettingsOwner;

public class YaDiV
implements SettingsOwner {
    public static final String OPT_DEF_DIR;
    public static final String OPT_MEASURE_TIMES;
    private static final String OPT_DEBUG_MESSAGES;
    public static final String OPT_DEF_SEG_DIR;
    public static final String OPT_USE_DATA_DIR_AS_SEG_DIR;
    public static final String OPT_DEF_IMPORT_DIR;

    static {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        OPT_DEF_DIR = Settings.register_str_opt(YaDiV.class, "Default DICOM Directory", "The default directory that is used for the DICOM file dialog", System.getProperty("user.home"));
        OPT_MEASURE_TIMES = Settings.register_bool_opt(YaDiV.class, "Measure Thread Times", "If enabled, all threads report the time between start_thread() and end_thread()", false);
        OPT_DEBUG_MESSAGES = Settings.register_bool_opt(YaDiV.class, "Print Debug Messages", "If enabled debug messages will be shown", false);
        OPT_DEF_SEG_DIR = Settings.register_str_opt(YaDiV.class, "Default Segment Directory", "The default directory that is used for the segment file dialog", System.getProperty("user.home"));
        OPT_USE_DATA_DIR_AS_SEG_DIR = Settings.register_bool_opt(YaDiV.class, "Use data dir as segment default", "If enabled, the directory containing the volume data will be the default directory for segments.", false);
        OPT_DEF_IMPORT_DIR = Settings.register_str_opt(YaDiV.class, "Default Import Directory", "The default directory that is used for the Import file dialog", System.getProperty("user.home"));
    }

    public static void check_java3d() {
        BitCube bc = new BitCube(10, 10, 10);
        ClassLoader classLoader = bc.getClass().getClassLoader();
        try {
            classLoader.loadClass("javax.media.j3d.BoundingSphere");
        }
        catch (ClassNotFoundException e) {
            MyHTMLPane myhtml_no_java3d = new MyHTMLPane();
            myhtml_no_java3d.setText("YaDiV could not start - you need to install Java3D first. You can download the latest version from <a href=\"https://java3d.dev.java.net/\">https://java3d.dev.java.net/</a>");
            JOptionPane.showMessageDialog(null, myhtml_no_java3d, "Critical Error", 0);
            System.exit(0);
        }
    }

    public static void report(ReportType type, String str) {
        switch (type) {
            case REPORT_TIME: {
                if (!Settings.get_bool_option(YaDiV.class, OPT_MEASURE_TIMES).booleanValue()) {
                    return;
                }
                System.out.println(str);
                System.out.flush();
                break;
            }
            case REPORT_DEBUG: {
                if (!Settings.get_bool_option(YaDiV.class, OPT_DEBUG_MESSAGES).booleanValue()) {
                    return;
                }
                System.out.println(str);
                System.out.flush();
                break;
            }
            default: {
                System.out.println(str);
                System.out.flush();
            }
        }
    }

    public static void main(String[] args) {
        StopWatch sw_pre_total = new StopWatch(true);
        StopWatch sw_tmp = new StopWatch(true);
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-use_logfile")) {
                    try {
                        FileOutputStream fos = new FileOutputStream("ylog.txt");
                        PrintStream ps = new PrintStream(fos);
                        System.setErr(ps);
                        System.setOut(ps);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        YaDiV.report(ReportType.REPORT_TIME, "Argument Parsing  : " + sw_tmp);
        sw_tmp.reset();
        PropertyConfigurator.configure((String)"resources/log4j.properties");
        Settings.load("YaDiV");
        YaDiV.check_java3d();
        YaDiV.report(ReportType.REPORT_TIME, "Log4J + Java3d    : " + sw_tmp);
        sw_tmp.reset();
        PluginManager pm = PluginManagerFactory.createPluginManager();
        pm.addPluginsFrom(new File("resources/plugins/").toURI(), new AddPluginsFromOption[0]);
        JGridMaker.REPORT_TOTAL_TIME = false;
        YaDiV.report(ReportType.REPORT_TIME, "Plugins           : " + sw_tmp);
        sw_tmp.reset();
        YaDiV.report(ReportType.REPORT_TIME, "Pre-GUI Total Time: " + sw_pre_total);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StopWatch sw = new StopWatch(true);
                MasterControl.create_interface();
                YaDiV.report(ReportType.REPORT_TIME, "Create Interface Total Time: " + sw);
                YaDiV.report(ReportType.REPORT_DEBUG, "Stereo: " + MasterControl.get_v3d().get_stereo_available());
            }
        });
    }

    @Override
    public String get_name() {
        return "YaDiV";
    }

    @Override
    public void settings_changed(Object obj, String opt_name, Object opt) {
    }

    public static enum ReportType {
        REPORT_TIME,
        REPORT_ERROR,
        REPORT_DEBUG;

    }
}

