/*
 * Decompiled with CFR 0.152.
 */
package main.seggen;

import gui.LazyInitComponent;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import main.Message;
import main.Segment;
import main.seggen.SegGenBoundingBox;
import misc.AxisAlignedBoundingBox;
import misc.messages.YObservable;
import misc.messages.YObserver;
import settings.Settings;

public abstract class SegGen
extends GMPanel
implements YObserver,
LazyInitComponent {
    protected static Segment _seg;
    protected static AxisAlignedBoundingBox _seg_gen_bb;
    protected static int[] _bb_min;
    protected static int[] _bb_max;
    protected static int[] _identity_mapping;
    protected static boolean _use_bb;
    protected int[] _value_mapping;
    protected int[] _roi_mapping;

    static {
        _seg_gen_bb = new AxisAlignedBoundingBox();
    }

    public SegGen(Segment seg) {
        _seg = seg;
        SegGen.use_bb(Settings.get_bool_option(SegGenBoundingBox.class, SegGenBoundingBox.OPT_USE_BB));
        this.init_color_mapping();
        MasterControl.get_is().addObserver(this, "SegGen()");
        _seg_gen_bb.addObserver(this, "SegGen()");
    }

    public static void use_bb(boolean use_bb) {
        _use_bb = use_bb;
        if (_use_bb) {
            _bb_min = _seg_gen_bb.get_min();
            _bb_max = _seg_gen_bb.get_max();
        } else {
            AxisAlignedBoundingBox bbm = MasterControl.get_is().get_bb();
            _bb_min = bbm.get_min();
            _bb_max = bbm.get_max();
        }
    }

    public static Segment get_tmp_seg() {
        return _seg;
    }

    public static AxisAlignedBoundingBox get_seg_gen_bb() {
        return _seg_gen_bb;
    }

    public static int[] get_real_bb_min() {
        return _bb_min;
    }

    public static int[] get_real_bb_max() {
        return _bb_max;
    }

    private void init_color_mapping() {
        ImageStack is = MasterControl.get_is();
        if (is.get_state() == 2) {
            int number_of_values = is.get_voxel_value_range();
            this._roi_mapping = new int[number_of_values];
            _identity_mapping = new int[number_of_values];
            int i = 0;
            while (i < _identity_mapping.length) {
                SegGen._identity_mapping[i] = i;
                ++i;
            }
        }
    }

    protected void init_value_mapping(boolean use_visual) {
        if (use_visual) {
            int[] roi_mapping = MasterControl.get_v2d().get_bg_image_renderer().get_voxel_color_table()._colors;
            int i = 0;
            while (i < roi_mapping.length) {
                this._roi_mapping[i] = roi_mapping[i] & 0xFF;
                ++i;
            }
            this._value_mapping = this._roi_mapping;
        } else {
            this._value_mapping = _identity_mapping;
        }
    }

    protected void check_state() {
        int is = MasterControl.get_is().get_state();
        if (is == 2) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void update(YObservable yo, Message m) {
        if (m._type == ImageStack.M_LOADING_END) {
            this.init_color_mapping();
        } else if (m._type == ImageStack.M_SEG_START || m._type == ImageStack.M_RESIZE_START || m._type == ImageStack.M_FILTER3D_START) {
            this.setEnabled(false);
        } else if (m._type == ImageStack.M_SEG_END || m._type == ImageStack.M_RESIZE_END || m._type == ImageStack.M_FILTER3D_END) {
            this.setEnabled(true);
        }
    }
}

